/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.Analysis;
import projections.gui.GraphData;
import projections.gui.Util;

public class GraphYAxisCanvas
extends Canvas {
    private GraphData data;
    private int width = 0;
    private int textheight = 0;
    private int labelwidth = 0;
    private int labelincrement = 0;
    private int tickincrement = 0;
    private int numintervals = 0;
    private int maxvalue = 0;
    private double pixelincrement = 0.0;
    private FontMetrics fm;

    public GraphYAxisCanvas() {
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    public int getPreferredWidth() {
        String string;
        int n = 0;
        if (this.data == null) {
            return n;
        }
        if (this.fm == null) {
            Graphics graphics = this.getGraphics();
            this.fm = graphics.getFontMetrics(graphics.getFont());
            graphics.dispose();
        }
        int n2 = 0;
        if (this.data.ymode == 10) {
            string = "(usec)";
            n2 = this.data.xmode == 0 ? this.data.processor.maxTime : this.data.interval.maxTime;
        } else {
            string = "Msgs";
            n2 = this.data.xmode == 0 ? this.data.processor.maxMsgs : this.data.interval.maxMsgs;
        }
        if (this.fm != null) {
            n = this.fm.stringWidth("" + n2) + this.fm.stringWidth(string) + 25;
        }
        return n;
    }

    public void paint(Graphics graphics) {
        String string;
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height - this.data.offset2;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        graphics.setColor(Analysis.background);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Analysis.foreground);
        int n3 = n2 / 2;
        if (this.data.ymode == 10) {
            string = "Time";
            graphics.drawString(string, 5, n3);
            string = "(usec)";
            graphics.drawString(string, 5, n3 + this.fm.getHeight() + 5);
        } else {
            string = "Msgs";
            graphics.drawString(string, 5, n3);
        }
        graphics.drawLine(n - 5, this.data.offset, n - 5, n2 - 1);
        for (int i = 0; i <= this.numintervals; ++i) {
            int n4 = (int)((double)n2 - (double)i * this.pixelincrement) - 1;
            if (i % this.labelincrement == 0) {
                graphics.drawLine(n - 10, n4, n, n4);
                string = "" + i * this.tickincrement;
                graphics.drawString(string, n - 15 - this.fm.stringWidth(string), n4 + this.fm.getHeight() / 2);
                continue;
            }
            graphics.drawLine(n - 7, n4, n - 3, n4);
        }
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.clearRect(0, 0, n, n2);
        this.paint(graphics);
        ((Graphics2D)graphics).setBackground(Color.black);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.textheight == 0) {
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.textheight = fontMetrics.getHeight();
            graphics.dispose();
        }
        this.maxvalue = this.data.ymode == 10 ? (this.data.xmode == 0 ? this.data.processor.maxTime : this.data.interval.maxTime) : (this.data.xmode == 0 ? this.data.processor.maxMsgs : this.data.interval.maxMsgs);
        if (this.maxvalue <= 0) {
            this.tickincrement = 1;
            this.numintervals = 0;
            this.pixelincrement = 1.0;
            this.labelincrement = 1;
        } else {
            this.tickincrement = (int)Math.ceil(5.0 / ((double)(n4 - this.data.offset - this.data.offset2) / (double)this.maxvalue));
            this.tickincrement = Util.getBestIncrement(this.tickincrement);
            this.numintervals = (int)Math.ceil((double)this.maxvalue / (double)this.tickincrement);
            this.pixelincrement = (double)(n4 - this.data.offset - this.data.offset2) / (double)this.numintervals;
            this.labelincrement = (int)Math.ceil((double)(this.textheight + 10) / this.pixelincrement);
            this.labelincrement = Util.getBestIncrement(this.labelincrement);
        }
        this.data.yscale = this.pixelincrement / (double)this.tickincrement;
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }
}

