/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import javax.swing.JTextField;

public class JIntTextField
extends JTextField {
    private String lastValue;
    private int lastCaretPosition;

    public JIntTextField(int n, int n2) {
        super("" + n, n2);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!('0' <= c && c <= '9' || Character.isISOControl(c))) {
                    keyEvent.consume();
                } else {
                    JIntTextField.this.lastCaretPosition = JIntTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + n;
    }

    private void checkValue() {
        try {
            Integer.parseInt(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException numberFormatException) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public int getValue() {
        this.checkValue();
        try {
            return Integer.parseInt(this.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setValue(int n) {
        this.lastValue = this.getText();
        this.setText(String.valueOf(n));
        this.checkValue();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkValue();
    }
}

