/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class MenuManager
implements ActionListener,
ItemListener {
    JMenuBar menubar;
    JFrame parent;

    public MenuManager(JFrame jFrame) {
        this.parent = jFrame;
        this.menubar = new JMenuBar();
        jFrame.setJMenuBar(this.menubar);
    }

    JMenu makeJMenu(Object object, Object[] objectArray) {
        JMenu jMenu = null;
        if (object instanceof JMenu) {
            jMenu = (JMenu)object;
        } else if (object instanceof String) {
            jMenu = new JMenu((String)object);
        } else {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem;
            if (objectArray[i] instanceof String) {
                jMenuItem = new JMenuItem((String)objectArray[i]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                continue;
            }
            if (objectArray[i] instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)objectArray[i];
                jMenuItem.addItemListener(this);
                jMenu.add(jMenuItem);
                continue;
            }
            if (objectArray[i] instanceof JRadioButtonMenuItem) {
                jMenuItem = (JRadioButtonMenuItem)objectArray[i];
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                continue;
            }
            if (objectArray[i] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[i];
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                continue;
            }
            if (objectArray[i] != null) continue;
            jMenu.addSeparator();
        }
        return jMenu;
    }

    void setEnabled(JMenu jMenu, boolean[] blArray) {
        if (blArray.length != jMenu.getItemCount()) {
            System.err.println("Projections Error: Menu items inconsistent!");
            System.exit(-1);
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (!(jMenuItem instanceof JMenuItem)) continue;
                jMenuItem.setEnabled(blArray[i]);
            }
        }
    }

    void setEnabled(JMenu jMenu, int n, boolean bl) {
        if (jMenu.getItemCount() > n) {
            JMenuItem jMenuItem = jMenu.getItem(n);
            if (jMenuItem instanceof JMenuItem) {
                jMenuItem.setEnabled(bl);
            }
        } else {
            System.err.println("Projections Error: Menu items inconsistent!");
            System.exit(-1);
        }
    }

    void setAllTo(JMenu jMenu, boolean bl) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (!(jMenuItem instanceof JMenuItem)) continue;
            jMenuItem.setEnabled(bl);
        }
    }

    abstract void stateChanged(int var1);

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

