/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.ProfileData;

public class ProfileAxisCanvas
extends Canvas {
    private ProfileData data;
    private Image offscreen;
    private FontMetrics fm;
    private int textheight;

    public ProfileAxisCanvas(ProfileData profileData) {
        this.data = profileData;
        this.setForeground(Color.white);
        this.setBackground(Color.black);
    }

    private void drawAxis(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.getSize().width;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.textheight = this.fm.getHeight();
        }
        graphics.setColor(this.getForeground());
        graphics.drawLine(n3 - 1, this.data.offset, n3 - 1, this.data.dch);
        float f = (float)((double)(this.data.dch - this.data.offset) / 100.0);
        int n4 = (int)Math.ceil((float)this.textheight / f);
        int[] nArray = new int[]{1, 2, 5, 25};
        int n5 = -1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n6 = 0;
            n = 0;
            while ((n = (int)((double)nArray[n2] * Math.pow(10.0, n6))) < n4) {
                ++n6;
            }
            if (n - n4 >= n5 - n4 && n5 >= 0) continue;
            n5 = n;
        }
        n4 = n5;
        for (n = 0; n <= 100; ++n) {
            n2 = this.data.dch - (int)((float)n * f) - 1;
            if (n % n4 == 0) {
                String string = "" + n;
                graphics.drawLine(n3 - 10, n2, n3, n2);
                n2 += (int)(0.5 * (double)this.textheight);
                if (n == 0) continue;
                graphics.drawString(string, n3 - 15 - this.fm.stringWidth(string), n2);
                continue;
            }
            graphics.drawLine(n3 - 7, n2, n3, n2);
        }
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.plist == null) {
            return;
        }
        int n = this.getSize().width;
        if (n > 0 && this.data.dch > 0) {
            this.offscreen = this.createImage(n, this.data.dch + 30);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, n, this.data.dch);
            this.drawAxis(graphics);
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.profileWindow.getVSBValue();
            int n2 = this.getSize().width;
            graphics.drawImage(this.offscreen, 0, 0, n2, this.data.vph, 0, n, n2, this.data.vph + n, null);
        }
    }

    public void print(Graphics graphics) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        int n = this.data.profileWindow.getVSBValue();
        graphics.translate(0, -n);
        this.drawAxis(graphics);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

