/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.gui.Analysis;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.JFloatTextField;
import projections.gui.MainWindow;
import projections.gui.PieChartWindow;
import projections.gui.ProfileData;
import projections.gui.ProfileGraph;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class ProfileWindow
extends ProjectionsWindow
implements ActionListener,
ColorSelectable,
ChangeListener {
    private static final int NUM_SYS_EPS = 3;
    private ProfileWindow thisWindow = this;
    private ProfileData data;
    private boolean colorsSet = false;
    private Color[] colors = null;
    private float[][] dataSource = null;
    private int[][] colorMap = null;
    private String[][] nameMap = null;
    private String[] procNames = null;
    private float[] sDataSrc = null;
    private int[] sColorMap = null;
    private String[] sNameMap = null;
    private JTabbedPane tabPane;
    private ProfileGraph displayCanvas;
    private JScrollPane displayPanel;
    private int displayPanelTabIndex;
    private ProfileGraph ampiDisplayCanvas;
    private JScrollPane ampiDisplayPanel;
    private int ampiDisplayPanelTabIndex;
    private JButton btnIncX;
    private JButton btnDecX;
    private JButton btnResX;
    private JButton btnIncY;
    private JButton btnDecY;
    private JButton btnResY;
    private JFloatTextField txtScaleX;
    private JFloatTextField txtScaleY;
    private float thresh = 0.01f;
    private PieChartWindow pieChartWindow;
    private float[][] avgData;
    private EntrySelectionDialog entryDialog;
    private boolean ampiTraceOn = false;

    public ProfileWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        if (Analysis.getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Usage Profile - " + Analysis.getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setLocationRelativeTo(mainWindow);
        this.setVisible(true);
    }

    void windowInit() {
        this.data = new ProfileData(this);
        this.data.plist = Analysis.getValidProcessorList();
        this.data.pstring = Analysis.getValidProcessorString();
        this.data.begintime = 0L;
        this.data.endtime = Analysis.getTotalTime();
    }

    private void CreateMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Select Processors", "Print Profile", null, "Close"}, null, this));
        if (this.ampiTraceOn) {
            jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Pie Chart", "Change Colors", "Usage Table", new String[]{"AMPI", "Usage Profile"}}, null, this));
        } else {
            jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Pie Chart", "Change Colors", "Usage Table"}, null, this));
        }
        jMenuBar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(jMenuBar);
    }

    private void CreateLayout() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.displayCanvas = new ProfileGraph();
        this.displayPanel = new JScrollPane(this.displayCanvas);
        if (this.ampiTraceOn) {
            this.ampiDisplayCanvas = new ProfileGraph();
            this.ampiDisplayPanel = new JScrollPane(this.ampiDisplayCanvas);
            this.tabPane = new JTabbedPane();
            this.tabPane.add("Entry Points", this.displayPanel);
            this.tabPane.add("AMPI Functions", this.ampiDisplayPanel);
            this.displayPanelTabIndex = this.tabPane.indexOfComponent(this.displayPanel);
            this.ampiDisplayPanelTabIndex = this.tabPane.indexOfComponent(this.ampiDisplayPanel);
            this.tabPane.addChangeListener(this);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        jPanel2.setLayout(gridBagLayout);
        this.btnDecX = new JButton("<<");
        JLabel jLabel = new JLabel("X-Axis Scale: ", 0);
        this.txtScaleX = new JFloatTextField(1.0f, 5);
        this.btnIncX = new JButton(">>");
        this.btnResX = new JButton("Reset");
        this.btnDecX.addActionListener(this);
        this.txtScaleX.addActionListener(this);
        this.btnIncX.addActionListener(this);
        this.btnResX.addActionListener(this);
        Util.gblAdd(jPanel2, this.btnDecX, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, jLabel, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.txtScaleX, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.btnIncX, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.btnResX, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        jPanel3.setLayout(gridBagLayout);
        this.btnDecY = new JButton("<<");
        JLabel jLabel2 = new JLabel("Y-Axis Scale: ", 0);
        this.txtScaleY = new JFloatTextField(1.0f, 5);
        this.btnIncY = new JButton(">>");
        this.btnResY = new JButton("Reset");
        this.btnDecY.addActionListener(this);
        this.txtScaleY.addActionListener(this);
        this.btnIncY.addActionListener(this);
        this.btnResY.addActionListener(this);
        Util.gblAdd(jPanel3, this.btnDecY, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, jLabel2, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.txtScaleY, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel3, this.btnIncY, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.btnResY, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        if (this.ampiTraceOn) {
            Util.gblAdd(container, this.tabPane, gridBagConstraints, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        } else {
            Util.gblAdd(container, this.displayPanel, gridBagConstraints, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        }
        Util.gblAdd(container, jPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
        Util.gblAdd(container, jPanel3, gridBagConstraints, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Usage Profile");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            Thread thread = new Thread(){

                public void run() {
                    ProfileWindow.this.setDisplayProfileData();
                    if (ProfileWindow.this.ampiTraceOn) {
                        ProfileWindow.this.setAmpiDisplayProfileData();
                    }
                    ProfileWindow.this.setVisible(true);
                }
            };
            thread.start();
        }
    }

    public void getDialogData() {
        this.data.plist = this.dialog.getValidProcessors();
        this.data.pstring = this.dialog.getValidProcessorString();
        this.data.begintime = this.dialog.getStartTime();
        this.data.endtime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.data.plist);
        this.dialog.setStartTime(this.data.begintime);
        this.dialog.setEndTime(this.data.endtime);
        super.setDialogData();
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.txtScaleX.getValue();
        float f2 = this.txtScaleY.getValue();
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.btnDecX) {
                f3 = (float)((int)(f * 4.0f) - 1) / 4.0f;
                if ((double)f3 < 1.0) {
                    f3 = 1.0f;
                }
            } else if (jButton == this.btnIncX) {
                f3 = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.btnResX) {
                f3 = 1.0f;
            } else if (jButton == this.btnDecY) {
                f4 = (float)((int)(f2 * 4.0f) - 1) / 4.0f;
                if ((double)f4 < 1.0) {
                    f4 = 1.0f;
                }
            } else if (jButton == this.btnIncY) {
                f4 = (float)((int)(f2 * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.btnResY) {
                f4 = 1.0f;
            }
            if (f3 != f && (double)f3 > 0.0) {
                this.txtScaleX.setText("" + f3);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(f3);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(f3);
                    }
                } else {
                    this.displayCanvas.setScaleX(f3);
                }
            }
            if (f4 != f2 && (double)f4 > 0.0) {
                this.txtScaleY.setText("" + f4);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(f4);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(f4);
                    }
                } else {
                    this.displayCanvas.setScaleY(f4);
                }
            }
        } else if (actionEvent.getSource() instanceof JFloatTextField) {
            JFloatTextField jFloatTextField = (JFloatTextField)actionEvent.getSource();
            if (jFloatTextField == this.txtScaleX) {
                f3 = f;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(f3);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(f3);
                    }
                } else {
                    this.displayCanvas.setScaleX(f3);
                }
            } else if (jFloatTextField == this.txtScaleY) {
                f4 = f2;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(f4);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(f4);
                    }
                } else {
                    this.displayCanvas.setScaleY(f4);
                }
            }
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            } else if (string.equals("Pie Chart")) {
                this.pieChartWindow = new PieChartWindow(this.parentWindow, this.avgData[0], this.avgData[0].length, this.thresh, this.colors);
            } else if (string.equals("Change Colors")) {
                this.showChangeColorDialog();
            } else if (string.equals("Usage Table")) {
                this.showUsageTable();
            } else if (string.equals("Usage Profile")) {
                this.showAMPIUsageProfile();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabPane) {
            if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                this.txtScaleX.setText(this.displayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.displayCanvas.getScaleY() + "");
            } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                this.txtScaleX.setText(this.ampiDisplayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.ampiDisplayCanvas.getScaleY() + "");
            }
        }
    }

    public void applyDialogColors() {
        int n = Analysis.getNumUserEntries();
        System.out.println(this.colors[n + 2]);
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    public void showChangeColorDialog() {
        int n = Analysis.getNumUserEntries();
        if (this.entryDialog == null) {
            String[] stringArray = new String[]{"Entry Points"};
            boolean[][] blArray = new boolean[1][n + 3];
            for (int i = 0; i < n + 3; ++i) {
                blArray[0][i] = true;
            }
            boolean[][] blArray2 = new boolean[1][n + 3];
            for (int i = 0; i < n + 3; ++i) {
                blArray2[0][i] = true;
            }
            String[] stringArray2 = new String[n + 3];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = Analysis.getEntryName(i);
            }
            stringArray2[n] = "Pack Time";
            stringArray2[n + 1] = "Unpack Time";
            stringArray2[n + 2] = "Idle Time";
            Color[][] colorArray = new Color[][]{this.colors};
            this.entryDialog = new EntrySelectionDialog(this, this, stringArray, blArray2, colorArray, blArray, stringArray2);
        }
        this.entryDialog.showDialog();
    }

    private void showUsageTable() {
        if (this.dataSource == null) {
            return;
        }
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Entry Points Usage Percent Table");
        jFrame.setDefaultCloseOperation(2);
        Object[] objectArray = new String[]{"Proc#", "Entry Name", "Usage Percent (%)"};
        int n = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            n += this.dataSource[i].length;
        }
        Object[][] objectArray2 = new Object[n][];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        int n2 = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            for (int j = 0; j < this.dataSource[i].length; ++j) {
                objectArray2[n2] = new Object[3];
                objectArray2[n2][0] = this.procNames[i];
                objectArray2[n2][1] = this.nameMap[i][j];
                objectArray2[n2][2] = decimalFormat.format(this.dataSource[i][j]) + "%";
                ++n2;
            }
        }
        JTable jTable = new JTable(objectArray2, objectArray);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setLocationRelativeTo(this.parentWindow);
        jFrame.setSize(500, 250);
        jFrame.setVisible(true);
    }

    private void showAMPIUsageProfile() {
        Serializable serializable;
        Cloneable cloneable;
        JFrame jFrame = new JFrame();
        jFrame.setTitle("AMPI Function Profile Table");
        jFrame.setDefaultCloseOperation(2);
        Object[] objectArray = new String[]{"Processor#", "Function Name", "Source File Name", "Line#", "%/Total", "%/Process"};
        int n = -1;
        this.data.plist.reset();
        Vector[] vectorArray = new Vector[this.data.plist.size()];
        int n2 = 0;
        int n3 = 0;
        while (this.data.plist.hasMoreElements()) {
            n = this.data.plist.nextElement();
            vectorArray[n2] = new Vector();
            Analysis.createAMPIUsage(n, this.data.begintime, this.data.endtime, vectorArray[n2]);
            cloneable = vectorArray[n2];
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)((Vector)cloneable).get(i);
                n3 += ampiProcessProfile.getFinalCallFuncStack().size();
            }
            ++n2;
        }
        cloneable = new DecimalFormat();
        ((DecimalFormat)cloneable).setMaximumFractionDigits(3);
        long l = this.data.endtime - this.data.begintime;
        Object[][] objectArray2 = new Object[n3][];
        n = -1;
        this.data.plist.reset();
        n2 = 0;
        int n4 = 0;
        while (this.data.plist.hasMoreElements()) {
            n = this.data.plist.nextElement();
            serializable = vectorArray[n2++];
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)((Vector)serializable).get(i);
                long l2 = ampiProcessProfile.getAccExecTime();
                Stack stack = ampiProcessProfile.getFinalCallFuncStack();
                Enumeration enumeration = stack.elements();
                while (enumeration.hasMoreElements()) {
                    AmpiFunctionData ampiFunctionData = (AmpiFunctionData)enumeration.nextElement();
                    objectArray2[n4] = new Object[objectArray.length];
                    objectArray2[n4][0] = "" + n;
                    objectArray2[n4][1] = Analysis.getFunctionName(ampiFunctionData.FunctionID);
                    objectArray2[n4][2] = ampiFunctionData.sourceFileName;
                    objectArray2[n4][3] = "" + ampiFunctionData.LineNo;
                    objectArray2[n4][4] = ((NumberFormat)cloneable).format((double)ampiFunctionData.getAccExecTime() / (double)l * 100.0) + "%";
                    objectArray2[n4][5] = ((NumberFormat)cloneable).format((double)ampiFunctionData.getAccExecTime() / (double)l2 * 100.0) + "%";
                    ++n4;
                }
            }
        }
        serializable = new JTable(objectArray2, objectArray);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setLocationRelativeTo(this);
        jFrame.setSize(500, 250);
        jFrame.setVisible(true);
    }

    private void setAmpiDisplayProfileData() {
        Object object;
        int n;
        int n2;
        String[] stringArray = new String[this.data.plist.size()];
        int n3 = -1;
        this.data.plist.reset();
        Vector vector = null;
        int n4 = 0;
        float[][] fArrayArray = new float[this.data.plist.size()][];
        String[][] stringArray2 = new String[this.data.plist.size()][];
        long l = this.data.endtime - this.data.begintime;
        while (this.data.plist.hasMoreElements()) {
            n3 = this.data.plist.nextElement();
            vector = new Vector();
            Analysis.createAMPIUsage(n3, this.data.begintime, this.data.endtime, vector);
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                object = (AmpiProcessProfile)vector.get(n);
                n2 += ((AmpiProcessProfile)object).getFinalCallFuncStack().size();
            }
            fArrayArray[n4] = new float[n2];
            stringArray2[n4] = new String[n2];
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                object = (AmpiProcessProfile)vector.get(n);
                Stack stack = ((AmpiProcessProfile)object).getFinalCallFuncStack();
                Enumeration enumeration = stack.elements();
                while (enumeration.hasMoreElements()) {
                    AmpiFunctionData ampiFunctionData = (AmpiFunctionData)enumeration.nextElement();
                    stringArray2[n4][n2] = Analysis.getFunctionName(ampiFunctionData.FunctionID) + "@" + ampiFunctionData.sourceFileName + "(" + ampiFunctionData.LineNo + ")";
                    fArrayArray[n4][n2] = (float)ampiFunctionData.getAccExecTime() / (float)l * 100.0f;
                    ++n2;
                }
            }
            stringArray[n4] = n3 + "";
            ++n4;
        }
        n2 = 0;
        for (n = 0; n < fArrayArray.length; ++n) {
            n2 += fArrayArray[n].length;
        }
        Color[] colorArray = Analysis.createColorMap(n2);
        object = new int[fArrayArray.length][];
        n2 = 0;
        for (int i = 0; i < fArrayArray.length; ++i) {
            object[i] = new int[fArrayArray[i].length];
            for (int j = 0; j < fArrayArray[i].length; ++j) {
                object[i][j] = n2++;
            }
        }
        String[] stringArray3 = new String[]{"Profile of Usage for Functions in AMPI programs " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.ampiDisplayCanvas.setGraphTiltes(stringArray3);
        this.ampiDisplayCanvas.setXAxis("", "", stringArray);
        this.ampiDisplayCanvas.setYAxis("Usage Percent % (over processor)");
        this.ampiDisplayCanvas.setDisplayDataSource(fArrayArray, (int[][])object, colorArray, stringArray2);
        this.ampiDisplayCanvas.repaint();
    }

    private void setDisplayProfileData() {
        this.createDisplayDataSource();
        String[] stringArray = new String[]{"Profile of Usage for Processors " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.displayCanvas.setGraphTiltes(stringArray);
        String[] stringArray2 = new String[this.data.plist.size() + 1];
        stringArray2[0] = "Avg";
        this.data.plist.reset();
        int n = 1;
        while (this.data.plist.hasMoreElements()) {
            stringArray2[n++] = "" + this.data.plist.nextElement();
        }
        this.procNames = stringArray2;
        this.displayCanvas.setXAxis("", "", stringArray2);
        this.displayCanvas.setYAxis("Usage Percent %");
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    private void createDisplayDataSource() {
        int n;
        Object object;
        int n2;
        this.data.numPs = n2 = this.data.plist.size() + 1;
        this.dataSource = new float[n2][];
        this.colorMap = new int[n2][];
        this.nameMap = new String[n2][];
        int n3 = Analysis.getNumUserEntries();
        float[][] fArray = new float[2][n3 + 3];
        for (int i = 0; i < n3 + 3; ++i) {
            fArray[0][i] = 0.0f;
            fArray[1][i] = 0.0f;
        }
        this.avgData = fArray;
        double d = 1.0 / (double)this.data.plist.size();
        int n4 = 0;
        int n5 = -1;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n5 = this.data.plist.nextElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("[PE: " + n5 + " ] Computing Average.");
            progressMonitor.setProgress(n4);
            object = Analysis.GetUsageData(n5, this.data.begintime, this.data.endtime, this.data.phaselist);
            for (n = 0; n < fArray[0].length && n < ((Object)object[0]).length; ++n) {
                float[] fArray2 = fArray[0];
                int n6 = n;
                fArray2[n6] = fArray2[n6] + (float)((double)object[0][n] * d);
                float[] fArray3 = fArray[1];
                int n7 = n;
                fArray3[n7] = fArray3[n7] + (float)((double)object[1][n] * d);
            }
            ++n4;
        }
        object = new Vector<Integer>();
        for (n = 0; n < n3; ++n) {
            if (!((double)(fArray[0][n] + fArray[1][n]) > 1.0)) continue;
            ((Vector)object).add(new Integer(n));
        }
        int[] nArray = new int[((Vector)object).size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)((Vector)object).elementAt(i);
        }
        if (!this.colorsSet) {
            Color[] colorArray = Analysis.createColorMap(n3, nArray);
            this.colors = new Color[n3 + 3];
            for (int i = 0; i < n3; ++i) {
                this.colors[i] = colorArray[i];
            }
            this.colors[n3] = Color.black;
            this.colors[n3 + 1] = Color.orange;
            this.colors[n3 + 2] = Color.white;
            this.colorsSet = true;
        }
        this.createSingleProcSource(fArray, -1);
        this.dataSource[0] = this.sDataSrc;
        this.colorMap[0] = this.sColorMap;
        this.nameMap[0] = this.sNameMap;
        n4 = 0;
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n5 = this.data.plist.nextElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("[PE: " + n5 + " ] Reading Entry Point Usage.");
            progressMonitor.setProgress(n4);
            float[][] fArray4 = Analysis.GetUsageData(n5, this.data.begintime, this.data.endtime, this.data.phaselist);
            this.createSingleProcSource(fArray4, n5);
            this.dataSource[++n4] = this.sDataSrc;
            this.colorMap[n4] = this.sColorMap;
            this.nameMap[n4] = this.sNameMap;
        }
        progressMonitor.close();
    }

    public void createSingleProcSource(float[][] fArray, int n) {
        float f;
        int n2;
        int n3 = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            if (fArray[0][i] > this.thresh) {
                ++n3;
            }
            if (!(fArray[1][i] > this.thresh)) continue;
            ++n3;
        }
        float[] fArray2 = new float[n3];
        int[] nArray = new int[n3];
        String[] stringArray = new String[n3];
        this.sDataSrc = fArray2;
        this.sColorMap = nArray;
        this.sNameMap = stringArray;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(5);
        decimalFormat.setMinimumFractionDigits(5);
        int n4 = -1;
        int n5 = Analysis.getNumUserEntries();
        String[][] stringArray2 = Analysis.getEntryNames();
        for (n2 = 0; n2 < fArray[0].length; ++n2) {
            f = fArray[0][n2];
            if (f <= this.thresh) continue;
            fArray2[++n4] = f;
            nArray[n4] = n2;
            stringArray[n4] = n2 == n5 ? "PACKING" : (n2 == n5 + 1 ? "UNPACKING" : (n2 == n5 + 2 ? "IDLE" : stringArray2[n2][1] + "::" + stringArray2[n2][0]));
            if (n < 0 || !MainWindow.PRINT_USAGE) continue;
            System.out.println(n + " " + n2 + " " + decimalFormat.format(f) + " " + stringArray[n4]);
        }
        if (Analysis.getVersion() > 4.9) {
            String string = "Message Send Time: ";
            for (n2 = 0; n2 < fArray[1].length; ++n2) {
                f = fArray[1][n2];
                if (f <= this.thresh) continue;
                fArray2[++n4] = f;
                nArray[n4] = n2;
                stringArray[n4] = n2 == n5 ? string + "PACKING" : (n2 == n5 + 1 ? string + "UNPACKING" : (n2 == n5 + 2 ? string + "IDLE" : string + stringArray2[n2][1] + "::" + stringArray2[n2][0]));
                if (n < 0 || !MainWindow.PRINT_USAGE) continue;
                System.out.println(n + " " + n2 + " " + decimalFormat.format(f) + " " + stringArray[n4]);
            }
        }
    }

    public void MakePOArray(long l, long l2) {
    }

    private void setScales() {
    }

    private void setSizes() {
    }

    public int getHSBValue() {
        return 0;
    }

    public int getVSBValue() {
        return 0;
    }
}

