/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import projections.gui.ScaleSlider;

public class ScalePanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private Axis hor;
    private Axis ver;
    private Child child;
    private int lC;
    private int rC;
    private int tC;
    private int bC;
    private StatusDisplay statusDisplay;
    private int lastX = -1;
    private int lastY = -1;
    private boolean inDrag;

    public ScalePanel(ScaleSlider scaleSlider, ScaleSlider scaleSlider2, Child child) {
        this.child = child;
        this.child.addParent(this);
        this.add(this.child);
        this.hor = new Axis(scaleSlider, "Horizontal");
        this.ver = new Axis(scaleSlider2, "Vertical");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    private void drawZoomCenter(Graphics graphics) {
        graphics.setColor(Color.gray);
        int n = 8;
        int n2 = (int)this.hor.getZoomCenter();
        int n3 = (int)this.ver.getZoomCenter();
        graphics.drawLine(n2 - n, n3, n2 + n, n3);
        graphics.drawLine(n2, n3 - n, n2, n3 + n);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    private void hoverPoint(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.lC;
        int n2 = mouseEvent.getY() - this.tC;
        this.status(this.child.getPointInfo(this.hor.s2p(n), this.ver.s2p(n2)) + " Drag to pan");
    }

    private boolean inBounds(int n, int n2) {
        return this.lC < n && n <= this.rC && this.tC < n2 && n2 <= this.bC;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updatePoint(mouseEvent, false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.status("");
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.inDrag) {
            if (mouseEvent.getX() > this.rC) {
                this.ver.zoomStatus("");
            } else if (mouseEvent.getY() > this.bC) {
                this.hor.zoomStatus("");
            } else {
                this.hoverPoint(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inBounds(mouseEvent.getX(), mouseEvent.getY())) {
            this.inDrag = true;
            this.status("Release mouse to end pan");
            this.updatePoint(mouseEvent, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.status("");
        this.updatePoint(mouseEvent, false);
        this.inDrag = false;
        this.lastX = -1;
        this.lastY = -1;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        int n7 = 8;
        this.lC = n4 = 2;
        this.rC = n5 - n7;
        this.tC = n4;
        this.bC = n6 - n7;
        this.hor.setScreenSize(this.rC - this.lC);
        this.ver.setScreenSize(this.bC - this.tC);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n5, this.tC - 1);
        graphics.fillRect(0, 0, this.lC - 1, n6);
        graphics.fillRect(this.rC + 1, 0, n5, n6);
        graphics.fillRect(0, this.bC + 1, n5, n6);
        graphics.setColor(Color.gray);
        graphics.drawRect(this.lC - 1, this.tC - 1, this.rC - this.lC + 1, this.bC - this.tC + 1);
        float[] fArray = this.hor.getTicks(0.0, n5 - n7 - n4);
        for (n3 = 0; n3 < fArray.length / 3; ++n3) {
            n2 = this.lC + (int)fArray[n3 * 3 + 0];
            n = (int)((float)(n7 - 2) * fArray[n3 * 3 + 1]);
            graphics.drawLine(n2, n6 - n7, n2, n6 - n7 + n);
        }
        fArray = this.ver.getTicks(0.0, n6 - n7 - n4);
        for (n3 = 0; n3 < fArray.length / 3; ++n3) {
            n2 = this.tC + (int)fArray[n3 * 3 + 0];
            n = (int)((float)(n7 - 2) * fArray[n3 * 3 + 1]);
            graphics.drawLine(n5 - n7, n2, n5 - n7 + n, n2);
        }
        graphics.translate(this.lC, this.tC);
        graphics.setClip(0, 0, this.rC - this.lC, this.bC - this.tC);
        this.drawZoomCenter(graphics);
        this.child.paint(new Child.RepaintRequest(graphics, this.rC - this.lC, this.bC - this.tC, this.hor, this.ver));
        this.drawZoomCenter(graphics);
    }

    public void setScales(double d, double d2) {
        this.hor.setScale(d);
        this.ver.setScale(d2);
    }

    public void setStatusDisplay(StatusDisplay statusDisplay) {
        this.statusDisplay = statusDisplay;
    }

    private void status(String string) {
        if (this.statusDisplay != null) {
            this.statusDisplay.setStatus(string);
        }
    }

    public double toSlider(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void updatePoint(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((this.lastX != n || this.lastY != n2) && this.inDrag) {
            this.hor.setZoomCenter(n - this.lC);
            this.ver.setZoomCenter(n2 - this.tC);
            if (!bl) {
                this.hor.scroll(n - this.lastX);
                this.ver.scroll(n2 - this.lastY);
            }
            this.repaint();
        }
        this.lastX = n;
        this.lastY = n2;
    }

    public static interface StatusDisplay {
        public void setStatus(String var1);
    }

    public class Axis
    implements ScaleSlider.ValueListener {
        private String direction;
        private double screen;
        private double screenInv;
        private double p2scale;
        private double p2off;
        private double s2scale;
        private double s2off;
        private double zoomCenter;

        public double p2s(double d) {
            return this.screen * (this.p2scale * d + this.p2off);
        }

        public double s2p(double d) {
            return this.s2scale * (d * this.screenInv) + this.s2off;
        }

        public Axis(ScaleSlider scaleSlider, String string) {
            scaleSlider.setValueListener(this);
            this.direction = string;
            this.screenInv = 1.0;
            this.screen = 1.0;
            this.s2off = 0.0;
            this.p2off = 0.0;
            this.s2scale = 1.0;
            this.p2scale = 1.0;
            this.zoomCenter = 0.5;
        }

        public void setScreenSize(int n) {
            this.screen = n;
            this.screenInv = 1.0 / this.screen;
        }

        public void setScale(double d) {
            this.p2scale = 1.0 / d;
            this.s2scale = d;
            this.zoomCenter = 0.5;
        }

        public void setZoom(double d, double d2) {
            this.p2scale = d;
            this.s2off = this.s2scale * d2 + this.s2off - d2 / d;
            this.s2scale = 1.0 / d;
            this.p2off = -this.s2off / this.s2scale;
        }

        public void scroll(double d) {
            double d2 = d * this.screenInv;
            this.s2off -= d2 * this.s2scale;
            this.p2off = -this.s2off / this.s2scale;
        }

        public void zoomStatus(String string) {
            ScalePanel.this.status(this.direction + " zoom is " + string + this.p2scale);
        }

        public void sliderChanged(ScaleSlider scaleSlider) {
            double d = Math.pow(10.0, scaleSlider.getValue());
            this.setZoom(d, this.zoomCenter);
            this.zoomStatus("now ");
            ScalePanel.this.repaint();
        }

        public double getZoomCenter() {
            return this.zoomCenter * this.screen;
        }

        public void setZoomCenter(double d) {
            this.zoomCenter = d * this.screenInv;
            if (this.zoomCenter < 0.0 || this.zoomCenter > 1.0) {
                this.zoomCenter = 0.5;
            }
        }

        public float[] getTicks(double d, double d2) {
            double d3 = 7.0;
            double d4 = this.s2p(d);
            double d5 = this.s2p(d2);
            double d6 = 1.0;
            double d7 = d5 - d4;
            d6 = Math.pow(10.0, Math.ceil(-Math.log(d7 / d3) / Math.log(10.0)));
            int n = (int)Math.ceil(d4 * d6);
            int n2 = (int)Math.floor(d5 * d6);
            float f = (float)(1.0 - Math.log(d7 * d6 / d3) / Math.log(10.0));
            int n3 = n2 - n + 1;
            float[] fArray = new float[3 * n3];
            for (int i = 0; i < n3; ++i) {
                float f2;
                int n4 = n + i;
                double d8 = (double)(n + i) / d6;
                fArray[3 * i + 0] = (float)(d + (d2 - d) * (d8 - d4) / (d5 - d4));
                fArray[3 * i + 2] = (float)d8;
                if (n4 % 10 == 0) {
                    f2 = 1.0f;
                } else if (n4 % 5 == 0) {
                    f2 = 1.3f * f;
                    if (f2 > 1.0f) {
                        f2 = 1.0f;
                    }
                } else {
                    f2 = f;
                }
                fArray[3 * i + 1] = f2 * f2;
            }
            return fArray;
        }
    }

    public static class Child
    extends Component {
        private Vector parents = new Vector();

        public void paint(RepaintRequest repaintRequest) {
            repaintRequest.g.setColor(Color.black);
            repaintRequest.g.fillRect(0, 0, repaintRequest.w, repaintRequest.h);
        }

        public String getPointInfo(double d, double d2) {
            return "At (" + d + "," + d2 + ").";
        }

        public void addParent(ScalePanel scalePanel) {
            this.parents.insertElementAt(scalePanel, this.parents.size());
        }

        public void repaint() {
            for (int i = 0; i < this.parents.size(); ++i) {
                ((ScalePanel)this.parents.elementAt(i)).repaint();
            }
        }

        public static final class RepaintRequest {
            public Graphics g;
            public int w;
            public int h;
            private Axis hor;
            private Axis ver;

            public RepaintRequest(Graphics graphics, int n, int n2, Axis axis, Axis axis2) {
                this.g = graphics;
                this.w = n;
                this.h = n2;
                this.hor = axis;
                this.ver = axis2;
            }

            public double x(double d) {
                return this.hor.p2s(d);
            }

            public double y(double d) {
                return this.ver.p2s(d);
            }

            public double xInv(double d) {
                return this.hor.s2p(d);
            }

            public double yInv(double d) {
                return this.ver.s2p(d);
            }
        }
    }
}

