/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import projections.gui.Analysis;
import projections.gui.ColorMap;
import projections.gui.OrderedIntList;
import projections.gui.ScalePanel;
import projections.gui.U;

public class StlPanel
extends ScalePanel.Child {
    private int[][][] data;
    private int[][] utilData;
    private int[][] idleData;
    private int[][] mergedData;
    private int[][] colors;
    private int intervalSize;
    private int nPe;
    private OrderedIntList validPEs;
    private long totalTime;
    private long startTime;
    private long endTime;
    private ColorMap colorMap;
    private int mode = 0;

    public String getPointInfo(double d, double d2) {
        int n = (int)d2;
        if (n < 0 || n >= this.nPe || d2 < 0.0) {
            return "";
        }
        long l = (long)d;
        if (l < 0L || l >= this.totalTime) {
            return "";
        }
        if (this.validPEs != null) {
            int n2 = 0;
            this.validPEs.reset();
            for (int i = 0; i <= n; ++i) {
                n2 = this.validPEs.nextElement();
            }
            int n3 = Analysis.getNumUserEntries();
            int n4 = (int)(l / (long)this.intervalSize);
            long l2 = l + this.startTime;
            if (this.mode == 0) {
                return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " IDLE = " + this.idleData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
            }
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                if (this.data[i][n][n4] < n6) continue;
                n6 = this.data[i][n][n4];
                n5 = i;
            }
            if (n6 > 0) {
                return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us)." + " EP = " + Analysis.getEntryName(n5);
            }
            return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
        }
        return "";
    }

    public void paint(ScalePanel.Child.RepaintRequest repaintRequest) {
        double d = repaintRequest.y(1.0) - repaintRequest.y(0.0);
        double d2 = repaintRequest.x(1.0) - repaintRequest.x(0.0);
        double d3 = 1.0 / d;
        double d4 = 1.0 / d2;
        double d5 = repaintRequest.xInv(0.0);
        double d6 = repaintRequest.xInv(repaintRequest.w - 1);
        double d7 = repaintRequest.yInv(0.0);
        double d8 = repaintRequest.yInv(repaintRequest.h - 1);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d5 >= (double)this.totalTime) {
            d5 = (double)this.totalTime - 0.001;
        }
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (d6 >= (double)this.totalTime) {
            d6 = (double)this.totalTime - 0.001;
        }
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        if (d7 >= (double)this.nPe) {
            d7 = (double)this.nPe - 0.001;
        }
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        if (d8 >= (double)this.nPe) {
            d8 = (double)this.nPe - 0.001;
        }
        int n = (int)Math.ceil(repaintRequest.x(d5));
        int n2 = (int)Math.floor(repaintRequest.x(d6));
        int n3 = (int)Math.ceil(repaintRequest.y(d7));
        int n4 = (int)Math.floor(repaintRequest.y(d8));
        int n5 = n2 - n;
        int n6 = n4 - n3;
        double d9 = repaintRequest.xInv(n) / (double)this.intervalSize;
        double d10 = d4 / (double)this.intervalSize;
        int n7 = n2 - n;
        if (this.validPEs != null && n5 > 0 && n6 > 0) {
            int n8;
            int[] nArray = new int[n5 * n6];
            int n9 = (int)Math.floor(d7);
            int n10 = (int)Math.ceil(d8);
            this.validPEs.reset();
            int n11 = 0;
            while ((n8 = this.validPEs.nextElement()) != -1) {
                if (n8 == -1) continue;
                int n12 = (int)Math.floor(repaintRequest.y(n11));
                int n13 = (int)Math.floor(repaintRequest.y(n11 + 1));
                if (n12 < n3) {
                    n12 = n3;
                }
                if (n13 > n4) {
                    n13 = n4;
                }
                if (n11 < this.colors.length) {
                    this.renderRow(this.colors[n11], d9, d10, nArray, n5, n12 - n3, n13 - n3, n - n, n2 - n);
                }
                ++n11;
            }
            Image image = this.createImage(new MemoryImageSource(n5, n6, nArray, 0, n5));
            repaintRequest.g.drawImage(image, n, n3, null);
        }
        repaintRequest.g.setColor(Color.black);
        repaintRequest.g.fillRect(0, 0, n, n4);
        repaintRequest.g.fillRect(n, 0, repaintRequest.w, n3);
        repaintRequest.g.fillRect(n2, n3, repaintRequest.w, n4);
        repaintRequest.g.fillRect(0, n4, repaintRequest.w, repaintRequest.h);
    }

    private void renderRow(int[] nArray, double d, double d2, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)(65536.0 * d);
        int n7 = (int)(65536.0 * d2);
        int n8 = n6 + n4 * n7;
        int n9 = 0;
        for (int i = n4; i < n5; ++i) {
            n9 = n8 >> 16;
            if (n9 < 0) {
                n9 = 0;
                continue;
            }
            if (n9 >= nArray.length) {
                n8 += n7;
                continue;
            }
            int n10 = nArray[n9];
            n8 += n7;
            int n11 = n2 * n + i;
            int n12 = n2;
            while (n12 < n3) {
                if (n11 < nArray2.length) {
                    nArray2[n11] = n10;
                }
                ++n12;
                n11 += n;
            }
        }
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    private void applyColorMap(int[][] nArray) {
        int n = nArray.length;
        this.colors = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i].length;
            this.colors[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                if (nArray[i][j] > 255 || nArray[i][j] < 0) {
                    this.colors[i][j] = this.colorMap.apply(255);
                }
                this.colors[i][j] = this.colorMap.apply(nArray[i][j]);
            }
        }
    }

    private void applyColorMap(int[][][] nArray) {
        int n = nArray.length;
        int n2 = nArray[n - 1].length;
        this.colors = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n - 1][i].length;
            this.colors[i] = new int[n3];
            for (int j = 0; j < n3; ++j) {
                int n4 = 0;
                int n5 = 0;
                for (int k = 0; k < n; ++k) {
                    if (nArray[k][i][j] < n5) continue;
                    n5 = nArray[k][i][j];
                    n4 = k;
                }
                this.colors[i][j] = n5 > 0 ? Analysis.getEntryColor(n4).getRGB() : Color.black.getRGB();
            }
        }
    }

    public void setMode(int n) {
        this.mode = n;
        int n2 = Analysis.getNumUserEntries();
        if (n == 0) {
            this.applyColorMap(this.mergedData);
        } else if (n == 1) {
            this.setData(this.validPEs, this.startTime, this.endTime);
            this.applyColorMap(this.data);
        }
        this.repaint();
    }

    public void setData(OrderedIntList orderedIntList, long l, long l2) {
        this.validPEs = orderedIntList;
        this.totalTime = l2 - l;
        this.startTime = l;
        this.endTime = l2;
        int n = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double d = this.totalTime / (long)n;
        if (d < 5.0) {
            d = this.totalTime / (long)(n /= 5);
        }
        this.intervalSize = (int)d;
        int n2 = (int)(l / (long)this.intervalSize);
        int n3 = (int)(l2 / (long)this.intervalSize);
        this.nPe = orderedIntList.size();
        int n4 = Analysis.getNumUserEntries();
        if (this.mode == 0) {
            Analysis.LoadGraphData(this.intervalSize, n2, n3, false, orderedIntList);
            this.utilData = Analysis.getSystemUsageData(1);
            this.idleData = Analysis.getSystemUsageData(2);
            if (this.idleData == null) {
                this.idleData = new int[this.utilData.length][this.utilData[0].length];
            }
            this.mergedData = new int[this.utilData.length][this.utilData[0].length];
            for (int i = 0; i < this.utilData.length; ++i) {
                for (int j = 0; j < this.utilData[i].length; ++j) {
                    if (this.utilData[i][j] == 0) {
                        if (this.idleData[i][j] > 0) {
                            this.mergedData[i][j] = 0;
                            continue;
                        }
                        this.mergedData[i][j] = 0;
                        continue;
                    }
                    this.mergedData[i][j] = this.utilData[i][j];
                }
            }
            this.applyColorMap(this.mergedData);
        } else if (this.mode == 1) {
            Analysis.LoadGraphData(this.intervalSize, n2, n3, true, orderedIntList);
            this.data = new int[n4][][];
            for (int i = 0; i < n4; ++i) {
                this.data[i] = Analysis.getUserEntryData(i, 2);
            }
            this.utilData = Analysis.getSystemUsageData(1);
            this.idleData = Analysis.getSystemUsageData(2);
            this.applyColorMap(this.data);
        }
        orderedIntList.reset();
        this.repaint();
    }
}

