/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import projections.analysis.TimelineMessage;
import projections.gui.Analysis;
import projections.gui.TimelineObject;

public class TimelineMessageCanvas
extends Canvas {
    private String[] sTitles;
    private int[] width;
    private TimelineObject obj;
    private FontMetrics fm;
    private TimelineMessage[] msgs;
    private String[][] names;
    private int w;
    private int h;
    private int numTitles = 17;
    private int numColumns = 5;
    private int[] maxColWidth = null;

    public TimelineMessageCanvas(TimelineObject timelineObject) {
        this.obj = timelineObject;
        this.w = 0;
        this.h = 0;
        this.msgs = timelineObject.getMessages();
        this.names = Analysis.getEntryNames();
        this.sTitles = new String[this.numTitles];
        this.width = new int[this.numTitles];
        int n = timelineObject.getEntry();
        this.sTitles[0] = "DETAILS FOR ENTRY: ";
        this.sTitles[1] = this.names[n][1] + " -- " + this.names[n][0];
        this.sTitles[2] = "BEGIN TIME: ";
        this.sTitles[3] = "" + timelineObject.getBeginTime();
        this.sTitles[4] = "     END TIME: ";
        this.sTitles[5] = "" + timelineObject.getEndTime();
        this.sTitles[6] = "     MSGS: ";
        this.sTitles[7] = "" + timelineObject.getNumMsgs();
        this.sTitles[8] = "CREATED BY: ";
        this.sTitles[9] = "Processor " + timelineObject.getPCreation();
        this.sTitles[10] = "      EXECUTED ON: ";
        this.sTitles[11] = "Processor " + timelineObject.getPCurrent();
        this.sTitles[12] = "MSG#";
        this.sTitles[13] = "MSG SIZE:";
        this.sTitles[14] = "TIME SENT";
        this.sTitles[15] = "TIME SINCE LAST SEND";
        this.sTitles[16] = "TO ENTRY:";
        this.setBackground(Color.black);
        this.setForeground(Color.lightGray);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Graphics graphics;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            int n;
            int n2;
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.h = (this.fm.getHeight() + 5) * (6 + this.obj.getNumMsgs());
            for (n2 = 0; n2 < this.numTitles; ++n2) {
                this.width[n2] = this.fm.stringWidth(this.sTitles[n2]);
            }
            if (this.maxColWidth == null) {
                this.maxColWidth = new int[this.numColumns];
            }
            for (n = 0; n < this.obj.getNumMsgs(); ++n) {
                int n3 = this.fm.stringWidth("" + n);
                int n4 = this.fm.stringWidth("" + this.msgs[n].MsgLen);
                int n5 = this.fm.stringWidth("" + this.msgs[n].Time);
                int n6 = n > 0 ? this.fm.stringWidth("" + (this.msgs[n].Time - this.msgs[n - 1].Time)) : 0;
                int n7 = this.fm.stringWidth(this.names[this.msgs[n].Entry][0]);
                if (n3 > this.maxColWidth[0]) {
                    this.maxColWidth[0] = n3;
                }
                if (n4 > this.maxColWidth[1]) {
                    this.maxColWidth[1] = n4;
                }
                if (n5 > this.maxColWidth[2]) {
                    this.maxColWidth[2] = n5;
                }
                if (n6 > this.maxColWidth[3]) {
                    this.maxColWidth[3] = n6;
                }
                if (n7 <= this.maxColWidth[4]) continue;
                this.maxColWidth[4] = n7;
            }
            for (n2 = 0; n2 < this.maxColWidth.length; ++n2) {
                if (this.width[12 + n2] <= this.maxColWidth[n2]) continue;
                this.maxColWidth[n2] = this.width[12 + n2];
            }
            this.w = this.width[0] + this.width[1];
            n = 0;
            for (n2 = 2; n2 <= 7; ++n2) {
                n += this.width[n2];
            }
            if (n > this.w) {
                this.w = n;
            }
            n = 0;
            for (n2 = 8; n2 <= 11; ++n2) {
                n += this.width[n2];
            }
            if (n > this.w) {
                this.w = n;
            }
            n = 18;
            for (n2 = 12; n2 < this.numTitles; ++n2) {
                n += this.width[n2];
            }
            if (n > this.w) {
                this.w = n;
            }
            n = 18;
            for (n2 = 0; n2 < this.maxColWidth.length; ++n2) {
                n += this.maxColWidth[n2];
            }
            if (n > this.w) {
                this.w = n;
            }
            graphics.dispose();
        }
        return new Dimension(this.w, this.h);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        int n5 = (n3 - this.width[0] - this.width[1]) / 2;
        int n6 = (n3 - this.width[2] - this.width[3] - this.width[4] - this.width[5] - this.width[6] - this.width[7]) / 2;
        int n7 = (n3 - this.width[8] - this.width[9] - this.width[10] - this.width[11]) / 2;
        int n8 = 0;
        for (n2 = 0; n2 < this.maxColWidth.length; ++n2) {
            n8 += this.maxColWidth[n2];
        }
        int n9 = (n3 - n8) / (1 + this.maxColWidth.length);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        int[] nArray = new int[this.numColumns];
        int[] nArray2 = new int[this.numColumns];
        nArray[0] = this.maxColWidth[0] + (int)((double)n9 * 1.3);
        nArray[1] = this.maxColWidth[1] + n9;
        nArray[2] = this.maxColWidth[2] + (int)((double)n9 * 1.3);
        nArray[3] = this.maxColWidth[3] + (int)((double)n9 * 1.3);
        nArray[4] = this.maxColWidth[4] + n9;
        nArray2[0] = 0;
        for (n2 = 1; n2 < nArray2.length; ++n2) {
            nArray2[n2] = nArray2[n2 - 1] + nArray[n2 - 1];
        }
        int n10 = n = this.fm.getHeight() + 5;
        int n11 = 0;
        graphics.setColor(Color.white);
        graphics.drawString(this.sTitles[1], (n3 - this.width[1]) / 2, n10);
        graphics.setColor(Color.red.darker());
        n11 = n6;
        graphics.drawString(this.sTitles[2], n11, n10 += n);
        graphics.drawString(this.sTitles[4], n11 += this.width[2] + this.width[3], n10);
        graphics.drawString(this.sTitles[6], n11 += this.width[4] + this.width[5], n10);
        graphics.setColor(Color.lightGray);
        n11 = n6 + this.width[2];
        graphics.drawString(this.sTitles[3], n11, n10);
        graphics.drawString(this.sTitles[5], n11 += this.width[3] + this.width[4], n10);
        graphics.drawString(this.sTitles[7], n11 += this.width[5] + this.width[6], n10);
        graphics.setColor(Color.green.darker());
        n11 = n7;
        graphics.drawString(this.sTitles[8], n11, n10 += n);
        graphics.drawString(this.sTitles[10], n11 += this.width[8] + this.width[9], n10);
        graphics.setColor(Color.lightGray);
        n11 = n7 + this.width[8];
        graphics.drawString(this.sTitles[9], n11, n10);
        graphics.drawString(this.sTitles[11], n11 += this.width[9] + this.width[10], n10);
        n10 += n;
        graphics.setColor(Color.white);
        for (n2 = 0; n2 < this.numColumns; ++n2) {
            graphics.drawString(this.sTitles[12 + n2], (nArray[n2] - this.width[12 + n2]) / 2 + nArray2[n2], n10);
        }
        graphics.setColor(Color.lightGray);
        String[] stringArray = new String[this.numColumns];
        for (int i = 0; i < this.obj.getNumMsgs(); ++i) {
            stringArray[0] = new String("" + i);
            stringArray[1] = new String("" + this.msgs[i].MsgLen);
            stringArray[2] = new String("" + this.msgs[i].Time);
            stringArray[3] = i > 0 ? new String("" + (int)(this.msgs[i].Time - this.msgs[i - 1].Time)) : "-";
            stringArray[4] = new String(this.names[this.msgs[i].Entry][0]);
            n10 += n;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                graphics.drawString(stringArray[n2], (nArray[n2] - this.fm.stringWidth(stringArray[n2])) / 2 + nArray2[n2], n10);
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

