/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryPList;
import charm.debug.MemoryPanel;
import charm.debug.ParDebug;
import charm.debug.Slot;
import charm.debug.fmt.PList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

public class ScrollableMemory
extends JLabel
implements Scrollable {
    private static final int HOLE_PIXELS = 50;
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;
    private int pe;
    private MemoryPList data;
    private int verticalPixels;
    private int horizontalPixels;
    private int lineScan;
    private int lineWidth;
    private int lineStart;
    private int numLines;
    private int pixelsAvailable;
    private int memorySize;
    private int allocatedMemory;
    private int firstByte;
    private int lastByte;
    private MemoryPList.Hole[] holes;
    private Slot[] crossReference;
    private int[][] rgbnormal;
    private int[][] rgbleak;
    private int[] rgbselected;
    private int[] rgbhole;
    private Slot selectedSlot;
    public int viewX;
    public int viewY;

    public ScrollableMemory(MemoryPanel memoryPanel, int n, int n2, int n3, int n4) {
        boolean bl = true;
        this.lineScan = n2;
        this.numLines = n3;
        this.horizontalPixels = n4;
        this.pe = n;
        this.loadImage(false);
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.setAutoscrolls(true);
    }

    public void loadImage(boolean bl) {
        PList pList = bl ? ParDebug.server.getPList("converse/memory/leak", this.pe, ParDebug.globals) : ParDebug.server.getPList("converse/memory", this.pe);
        this.data = new MemoryPList(pList);
        this.data.sort();
        this.firstByte = Integer.MAX_VALUE;
        this.lastByte = Integer.MIN_VALUE;
        for (int i = 0; i < this.data.size(); ++i) {
            System.out.println("list " + i + " contains " + this.data.size(i) + " elements");
            if (this.data.size(i) == 0) continue;
            if (this.data.elementAt(i, 0).getLocation() < this.firstByte) {
                this.firstByte = this.data.elementAt(i, 0).getLocation();
            }
            if (this.data.elementAt(i, this.data.size(i) - 1).getLocation() <= this.lastByte) continue;
            this.lastByte = this.data.elementAt(i, this.data.size(i) - 1).getLocation() + this.data.elementAt(i, this.data.size(i) - 1).getSize();
        }
        this.holes = this.data.findHoles();
        this.memorySize = this.lastByte - this.firstByte + 1 - this.holes[0].size;
        this.allocatedMemory = 0;
        this.selectedSlot = null;
        this.resizeImage();
    }

    public void resizeImage(int n, int n2, int n3) {
        this.lineScan = n;
        this.numLines = n2;
        this.horizontalPixels = n3;
        this.resizeImage();
    }

    private void resizeImage() {
        int n;
        int n2;
        this.lineWidth = this.lineScan * 3 / 4;
        this.lineStart = (this.lineScan - this.lineWidth) / 2;
        this.verticalPixels = this.numLines * this.lineScan;
        this.pixelsAvailable = this.verticalPixels / this.lineScan * this.horizontalPixels;
        this.crossReference = new Slot[this.pixelsAvailable];
        this.pixelsAvailable -= 50 * this.holes[0].position;
        BufferedImage bufferedImage = new BufferedImage(this.horizontalPixels, this.verticalPixels, 2);
        this.rgbnormal = new int[5][this.lineWidth];
        int n3 = -45747;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbnormal[0][n2] = n3;
        }
        n3 = -2341563;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbnormal[1][n2] = n3;
        }
        n3 = -10840321;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbnormal[2][n2] = n3;
        }
        n3 = -19891;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbnormal[3][n2] = n3;
        }
        n3 = -26881;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbnormal[4][n2] = n3;
        }
        this.rgbleak = new int[5][this.lineWidth];
        n3 = -16711936;
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < (int)(0.75 * (double)this.lineWidth); ++n) {
                this.rgbleak[n2][n] = n3;
            }
            for (n = (int)(0.75 * (double)this.lineWidth); n < this.lineWidth; ++n) {
                this.rgbleak[n2][n] = this.rgbnormal[n2][n];
            }
        }
        this.rgbselected = new int[this.lineWidth];
        n3 = -101;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbselected[n2] = n3;
        }
        this.rgbhole = new int[this.lineWidth];
        n3 = -4934476;
        for (n2 = 0; n2 < this.lineWidth; ++n2) {
            this.rgbhole[n2] = n3;
        }
        for (n2 = 0; n2 < this.data.size(); ++n2) {
            n = this.holes[0].position > 0 ? 1 : 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.data.size(n2); ++i) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                Slot slot = this.data.elementAt(n2, i);
                if (n > 0 && this.holes[n].position < slot.getLocation()) {
                    n11 = this.holes[n].position - this.firstByte - n4;
                    n11 = (int)((long)n11 * (long)this.pixelsAvailable / (long)this.memorySize);
                    n10 = (n11 += n5) / this.horizontalPixels;
                    n11 -= n10 * this.horizontalPixels;
                    n9 = this.holes[n].position - this.firstByte - n4;
                    n9 = (int)((long)n9 * (long)this.pixelsAvailable / (long)this.memorySize);
                    n8 = (n9 += n5 + 50) / this.horizontalPixels;
                    n9 -= n8 * this.horizontalPixels;
                    n7 = n10;
                    for (n6 = n11; n7 < n8 || n6 < n9; ++n6) {
                        if (n6 == this.horizontalPixels) {
                            n6 = 0;
                            ++n7;
                        }
                        bufferedImage.setRGB(n6, n7 * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbhole, 0, 1);
                    }
                    n4 += this.holes[n].size;
                    n5 += 50;
                    n = this.holes[0].position > n ? n + 1 : 0;
                }
                n11 = slot.getLocation() - this.firstByte - n4;
                n11 = (int)((long)n11 * (long)this.pixelsAvailable / (long)this.memorySize);
                n10 = (n11 += n5) / this.horizontalPixels;
                n11 -= n10 * this.horizontalPixels;
                n9 = slot.getLocation() + slot.getSize() - this.firstByte - n4;
                n9 = (int)((long)n9 * (long)this.pixelsAvailable / (long)this.memorySize);
                n8 = (n9 += n5) / this.horizontalPixels;
                n9 -= n8 * this.horizontalPixels;
                n7 = n10;
                for (n6 = n11; n7 < n8 || n6 <= n9; ++n6) {
                    if (n6 == this.horizontalPixels) {
                        n6 = 0;
                        ++n7;
                    }
                    if (slot.isLeak()) {
                        bufferedImage.setRGB(n6, n7 * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbleak[slot.getType()], 0, 1);
                    } else {
                        bufferedImage.setRGB(n6, n7 * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbnormal[slot.getType()], 0, 1);
                    }
                    this.crossReference[n7 * this.horizontalPixels + n6] = slot;
                }
            }
        }
        this.setIcon(new ImageIcon(bufferedImage));
        this.selectSlot(this.selectedSlot);
        this.maxUnitIncrement = this.lineScan;
    }

    private void drawSlot(Slot slot, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n <= this.holes[0].position && this.holes[n].position < slot.getLocation(); ++n) {
            n2 += this.holes[n].size;
            n3 += 50;
        }
        n = slot.getLocation() - this.firstByte - n2;
        n = (int)((long)n * (long)this.pixelsAvailable / (long)this.memorySize);
        int n4 = (n += n3) / this.horizontalPixels;
        n -= n4 * this.horizontalPixels;
        int n5 = slot.getLocation() + slot.getSize() - this.firstByte - n2;
        n5 = (int)((long)n5 * (long)this.pixelsAvailable / (long)this.memorySize);
        int n6 = (n5 += n3) / this.horizontalPixels;
        n5 -= n6 * this.horizontalPixels;
        int n7 = n4;
        for (int i = n; n7 < n6 || i <= n5; ++i) {
            if (i == this.horizontalPixels) {
                i = 0;
                ++n7;
            }
            ((BufferedImage)((ImageIcon)this.getIcon()).getImage()).setRGB(i, n7 * this.lineScan + this.lineStart, 1, this.lineWidth, nArray, 0, 1);
        }
        this.repaint();
    }

    public void selectSlot(Slot slot) {
        if (this.selectedSlot != null) {
            if (this.selectedSlot.isLeak()) {
                this.drawSlot(this.selectedSlot, this.rgbleak[this.selectedSlot.getType()]);
            } else {
                this.drawSlot(this.selectedSlot, this.rgbnormal[this.selectedSlot.getType()]);
            }
        }
        this.selectedSlot = slot;
        if (slot != null) {
            this.drawSlot(slot, this.rgbselected);
        }
    }

    public Dimension getPreferredSize() {
        if (this.missingPicture) {
            return new Dimension(320, 320);
        }
        return super.getPreferredSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        n3 = n == 0 ? rectangle.x : rectangle.y;
        if (n2 < 0) {
            int n4 = n3 - n3 / this.maxUnitIncrement * this.maxUnitIncrement;
            return n4 == 0 ? this.maxUnitIncrement : n4;
        }
        return (n3 / this.maxUnitIncrement + 1) * this.maxUnitIncrement - n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - this.maxUnitIncrement;
        }
        return rectangle.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int n) {
        this.maxUnitIncrement = n;
    }

    public int getBytes() {
        return this.memorySize;
    }

    public int getPixels() {
        return this.pixelsAvailable;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public int getLineSize() {
        return this.lineScan;
    }

    public int getHPixels() {
        return this.horizontalPixels;
    }

    public Slot getMemorySlot(int n, int n2) {
        int n3 = n2 / this.lineScan;
        int n4 = n2 - n3 * this.lineScan;
        if (n4 <= this.lineStart && n3 > 0 && this.crossReference[n3 * this.horizontalPixels + n] == this.crossReference[(n3 - 1) * this.horizontalPixels + n] || n4 > this.lineStart + this.lineWidth && n3 < this.verticalPixels / this.lineScan && this.crossReference[n3 * this.horizontalPixels + n] == this.crossReference[(n3 + 1) * this.horizontalPixels + n]) {
            return this.crossReference[n3 * this.horizontalPixels + n];
        }
        if (n4 <= this.lineStart || n4 > this.lineStart + this.lineWidth) {
            return null;
        }
        return this.crossReference[n3 * this.horizontalPixels + n];
    }

    public int getAllocatedMemory() {
        if (this.allocatedMemory == 0) {
            for (int i = 0; i < this.data.size(0); ++i) {
                this.allocatedMemory += this.data.elementAt(0, i).getSize();
            }
        }
        return this.allocatedMemory;
    }

    public int getNumAllocations() {
        return this.data.size(0);
    }
}

