/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;

public class PNative
extends PAbstract {
    private float[] v_float;
    private int[] v_int;
    private int len;

    PNative(int[] nArray) {
        this.v_int = nArray;
        this.v_float = null;
        this.len = nArray.length;
    }

    PNative(float[] fArray) {
        this.v_int = null;
        this.v_float = fArray;
        this.len = fArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.len > 1) {
            stringBuffer.append("{");
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.v_int != null) {
                stringBuffer.append("" + this.v_int[i]);
            }
            if (this.v_float != null) {
                stringBuffer.append("" + this.v_float[i]);
            }
            if (i + 1 == this.len) continue;
            stringBuffer.append(", ");
        }
        if (this.len > 1) {
            stringBuffer.append("} ");
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.len;
    }

    public int getIntValue(int n) {
        return this.v_int[n];
    }

    public float getFloatValue(int n) {
        return this.v_float[n];
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        super.draw(pDisplayStyle, n);
        for (int i = 0; i < this.len; ++i) {
            String string = "??";
            if (this.v_int != null) {
                string = Integer.toString(this.v_int[i]);
            }
            if (this.v_float != null) {
                string = Float.toString(this.v_float[i]);
            }
            if (pDisplayStyle.drawString(string)) continue;
            return false;
        }
        return true;
    }
}

