/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.MemoryDialog;
import charm.debug.ScrollableMemory;
import charm.debug.Slot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class MemoryPanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    private JMenuBar menuBar;
    private JMenu menuAction;
    private JMenuItem menuLeak;
    private JMenu menuInfo;
    private JMenuItem menuStat;
    private JSlider verticalZoom;
    private JSlider horizontalZoom;
    private JScrollPane displayPane;
    private JPanel topPane;
    private JPanel controlPane;
    private ScrollableMemory memoryData;
    private JButton update;
    private JTextField horizontalPixels;
    private JTextField verticalLines;
    private JTextField lineSize;
    private JLabel bytesPixel;
    private JButton minusLines;
    private JButton plusLines;
    private JButton minusVert;
    private JButton plusVert;
    private JButton minusHPixels;
    private JButton plusHPixels;
    private JLabel minusBytes;
    private JLabel plusBytes;
    private JTextArea info;
    private JScrollPane infoScrollPane;
    private boolean traceWrite;

    public MemoryPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.menuBar = new JMenuBar();
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuLeak = new JMenuItem("Search Leaks", 76);
        this.menuAction.add(this.menuLeak);
        this.menuLeak.addActionListener(this);
        this.menuInfo = new JMenu("Info");
        this.menuBar.add(this.menuInfo);
        this.menuInfo.setMnemonic('I');
        this.menuStat = new JMenuItem("Show Statistics", 76);
        this.menuInfo.add(this.menuStat);
        this.menuStat.addActionListener(this);
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.controlPane = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.controlPane.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(50, 1));
        jLabel.setMinimumSize(new Dimension(10, 1));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.controlPane.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        this.minusLines = new JButton("-");
        this.minusLines.addActionListener(this);
        gridBagLayout.setConstraints(this.minusLines, gridBagConstraints);
        this.controlPane.add(this.minusLines);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.verticalLines = new JTextField();
        this.verticalLines.setHorizontalAlignment(4);
        this.verticalLines.addActionListener(this);
        JLabel jLabel2 = new JLabel("Number of lines");
        jPanel2.add(this.verticalLines);
        jPanel2.add(jLabel2);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.controlPane.add(jPanel2);
        this.plusLines = new JButton("+");
        this.plusLines.addActionListener(this);
        gridBagLayout.setConstraints(this.plusLines, gridBagConstraints);
        this.controlPane.add(this.plusLines);
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(50, 1));
        jLabel3.setMinimumSize(new Dimension(10, 1));
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.controlPane.add(jLabel3);
        gridBagConstraints.weightx = 0.0;
        this.minusHPixels = new JButton("-");
        this.minusHPixels.addActionListener(this);
        gridBagLayout.setConstraints(this.minusHPixels, gridBagConstraints);
        this.controlPane.add(this.minusHPixels);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.horizontalPixels = new JTextField();
        this.horizontalPixels.setHorizontalAlignment(4);
        this.horizontalPixels.addActionListener(this);
        JLabel jLabel4 = new JLabel("Horizontal pixels", 0);
        jPanel3.add(this.horizontalPixels);
        jPanel3.add(jLabel4);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.controlPane.add(jPanel3);
        this.plusHPixels = new JButton("+");
        this.plusHPixels.addActionListener(this);
        gridBagLayout.setConstraints(this.plusHPixels, gridBagConstraints);
        this.controlPane.add(this.plusHPixels);
        JLabel jLabel5 = new JLabel();
        jLabel5.setPreferredSize(new Dimension(50, 1));
        jLabel5.setMinimumSize(new Dimension(10, 1));
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this.controlPane.add(jLabel5);
        this.update = new JButton("Update");
        this.update.setActionCommand("update");
        this.update.addActionListener(this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.update, gridBagConstraints);
        this.controlPane.add(this.update);
        JLabel jLabel6 = new JLabel();
        jLabel6.setPreferredSize(new Dimension(1, 1));
        jLabel6.setMinimumSize(new Dimension(1, 1));
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        this.controlPane.add(jLabel6);
        this.minusVert = new JButton("-");
        this.minusVert.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.minusVert, gridBagConstraints);
        this.controlPane.add(this.minusVert);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.lineSize = new JTextField();
        this.lineSize.setHorizontalAlignment(4);
        this.lineSize.addActionListener(this);
        JLabel jLabel7 = new JLabel("Line size");
        jPanel4.add(this.lineSize);
        jPanel4.add(jLabel7);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.controlPane.add(jPanel4);
        this.plusVert = new JButton("+");
        this.plusVert.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.plusVert, gridBagConstraints);
        this.controlPane.add(this.plusVert);
        this.bytesPixel = new JLabel(" ");
        this.bytesPixel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.bytesPixel, gridBagConstraints);
        this.controlPane.add(this.bytesPixel);
        this.topPane.add((Component)this.controlPane, "North");
        this.displayPane = new JScrollPane();
        this.topPane.add((Component)this.displayPane, "Center");
        this.info = new JTextArea();
        this.info.setText("Prova di scrittura\ndi una frase lunga.");
        this.info.setEditable(false);
        this.infoScrollPane = new JScrollPane(this.info);
        this.infoScrollPane.setBorder(BorderFactory.createTitledBorder("Information"));
        this.infoScrollPane.setPreferredSize(new Dimension(100, 150));
        JSplitPane jSplitPane = new JSplitPane(0, this.topPane, this.infoScrollPane);
        jSplitPane.setResizeWeight(1.0);
        this.add(jSplitPane);
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void loadData(MemoryDialog memoryDialog) {
        int n = memoryDialog.getPe();
        int n2 = memoryDialog.getScan();
        int n3 = memoryDialog.getLines();
        int n4 = memoryDialog.getHPixels();
        this.verticalLines.setText("" + n3);
        this.horizontalPixels.setText("" + n4);
        this.lineSize.setText("" + n2);
        this.memoryData = new ScrollableMemory(this, n, n2, n3, n4);
        this.memoryData.addMouseListener(this);
        this.memoryData.addMouseMotionListener(this);
        this.displayBytes();
        this.displayPane.setViewportView(this.memoryData);
        this.traceWrite = true;
    }

    private void displayBytes() {
        int n = this.memoryData.getBytes() / this.memoryData.getPixels();
        if (n >= 10) {
            this.bytesPixel.setText("Bytes per pixel: " + n);
        } else {
            int n2 = (int)((long)this.memoryData.getBytes() * 10L / (long)this.memoryData.getPixels()) % 10;
            int n3 = (int)((long)this.memoryData.getBytes() * 100L / (long)this.memoryData.getPixels()) % 10;
            this.bytesPixel.setText("Bytes per pixel: " + n + "." + n2 + n3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.menuLeak) {
            System.out.println("Leak search");
            this.memoryData.loadImage(true);
            this.traceWrite = true;
            this.displayBytes();
            this.repaint();
        } else if (actionEvent.getSource() == this.menuStat) {
            JOptionPane.showMessageDialog(this, "Memory Usage: " + NumberFormat.getInstance().format(this.memoryData.getAllocatedMemory()) + " bytes\nAllocated blocks: " + NumberFormat.getInstance().format(this.memoryData.getNumAllocations()), "Memory Statistics", 1);
        } else if (actionEvent.getActionCommand().equals("update")) {
            this.memoryData.loadImage(false);
            this.traceWrite = true;
            this.displayBytes();
            this.repaint();
        } else {
            int n;
            int n2;
            int n3;
            try {
                n3 = Integer.parseInt(this.verticalLines.getText());
                n2 = Integer.parseInt(this.lineSize.getText());
                n = Integer.parseInt(this.horizontalPixels.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
                return;
            }
            if (n2 <= 3) {
                JOptionPane.showMessageDialog(this, "The width of the line must be greater than 3", "Error", 0);
                this.lineSize.requestFocus();
            } else if (n3 <= 0) {
                JOptionPane.showMessageDialog(this, "The number of lines must be positive", "Error", 0);
                this.verticalLines.requestFocus();
            } else if (n <= 10) {
                JOptionPane.showMessageDialog(this, "The number of horizontal pixels must be greater than 10", "Error", 0);
                this.horizontalPixels.requestFocus();
            } else {
                if (actionEvent.getSource() == this.minusLines) {
                    n3 = (int)((double)n3 - (double)n3 * 0.1);
                    this.verticalLines.setText("" + n3);
                }
                if (actionEvent.getSource() == this.plusLines) {
                    n3 = (int)((double)n3 + (double)n3 * 0.1);
                    this.verticalLines.setText("" + n3);
                }
                if (actionEvent.getSource() == this.verticalLines) {
                    // empty if block
                }
                if (actionEvent.getSource() == this.minusVert) {
                    if ((n2 = (int)((double)n2 - (double)n2 * 0.1)) < 4) {
                        n2 = 4;
                    }
                    this.lineSize.setText("" + n2);
                }
                if (actionEvent.getSource() == this.plusVert) {
                    n2 = (int)((double)n2 + (double)n2 * 0.1);
                    this.lineSize.setText("" + n2);
                }
                if (actionEvent.getSource() == this.lineSize) {
                    // empty if block
                }
                if (actionEvent.getSource() == this.minusHPixels) {
                    n = (int)((double)n - (double)n * 0.1);
                    this.horizontalPixels.setText("" + n);
                }
                if (actionEvent.getSource() == this.plusHPixels) {
                    n = (int)((double)n + (double)n * 0.1);
                    this.horizontalPixels.setText("" + n);
                }
                if (actionEvent.getSource() == this.horizontalPixels) {
                    // empty if block
                }
                if (n3 != this.memoryData.getNumLines() || n2 != this.memoryData.getLineSize() || n != this.memoryData.getHPixels()) {
                    this.memoryData.resizeImage(n2, n3, n);
                    this.displayBytes();
                    this.repaint();
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.memoryData) {
            this.traceWrite = !this.traceWrite;
            this.updatePosition(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.deletePosition();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.memoryData) {
            this.memoryData.viewX = mouseEvent.getX();
            this.memoryData.viewY = mouseEvent.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updatePosition(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.memoryData) {
            JViewport jViewport = (JViewport)this.memoryData.getParent();
            Point point = jViewport.getViewPosition();
            int n = point.x - (mouseEvent.getX() - this.memoryData.viewX);
            int n2 = point.y - (mouseEvent.getY() - this.memoryData.viewY);
            int n3 = this.memoryData.getWidth() - jViewport.getWidth();
            int n4 = this.memoryData.getHeight() - jViewport.getHeight();
            if (n > n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            jViewport.setViewPosition(new Point(n, n2));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.memoryData) {
            this.updatePosition(mouseEvent);
        } else {
            this.deletePosition();
        }
    }

    private void updatePosition(MouseEvent mouseEvent) {
        if (this.traceWrite) {
            Slot slot = this.memoryData.getMemorySlot(mouseEvent.getX(), mouseEvent.getY());
            if (slot != null) {
                this.info.setText(slot.toString());
                this.info.setCaretPosition(0);
                this.memoryData.selectSlot(slot);
            } else {
                this.info.setText("");
                this.memoryData.selectSlot(null);
            }
        }
    }

    private void deletePosition() {
        if (this.traceWrite) {
            this.info.setText("");
            this.memoryData.selectSlot(null);
        }
    }
}

