/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Stack;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class CallTable
extends ProjDefs {
    private int numPe;
    private int numEPs;
    private double[][] byteSum;
    private double[][] msgCount;
    private double[][] sumSquares;
    private int[][] minStats;
    private int[][] maxStats;
    private double[][] varStats;
    private boolean[] exists;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;
    private DecimalFormat _format;

    public CallTable(long l, long l2, OrderedIntList orderedIntList) {
        this.peList = orderedIntList;
        this.numPe = this.peList.size();
        this.numEPs = Analysis.getNumUserEntries();
        this.startTime = l;
        this.endTime = l2;
        this.byteSum = new double[this.numEPs][this.numEPs];
        this.msgCount = new double[this.numEPs][this.numEPs];
        this.sumSquares = new double[this.numEPs][this.numEPs];
        this.minStats = new int[this.numEPs][this.numEPs];
        this.maxStats = new int[this.numEPs][this.numEPs];
        this.varStats = new double[this.numEPs][this.numEPs];
        this.exists = new boolean[this.numEPs];
        this._format = new DecimalFormat("###,###.###");
    }

    public void GatherData(Component component) {
        int n;
        LogEntryData logEntryData = new LogEntryData();
        int n2 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(component, "Generating Call Table", "", 0, this.numPe);
        while (this.peList.hasMoreElements()) {
            int n3 = this.peList.nextElement();
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                break;
            }
            progressMonitor.setNote("[PE: " + n3 + " ] Reading data.");
            progressMonitor.setProgress(n2 + 1);
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n3), Analysis.getVersion());
            try {
                int n4;
                int n5;
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                Stack<Integer> stack = new Stack<Integer>();
                while (logEntryData.time < this.endTime && logEntryData.type != 2) {
                    if (logEntryData.type == 1) {
                        stack.push(new Integer(logEntryData.entry));
                        stack.push(new Integer(logEntryData.msglen));
                    }
                    if (logEntryData.type == 3) {
                        n5 = logEntryData.entry;
                        while (!stack.empty()) {
                            n = (Integer)stack.pop();
                            n4 = (Integer)stack.pop();
                            if (this.minStats[n5][n4] > n || this.minStats[n5][n4] == 0) {
                                this.minStats[n5][n4] = n;
                            }
                            if (this.maxStats[n5][n4] < n) {
                                this.maxStats[n5][n4] = n;
                            }
                            double[] dArray = this.msgCount[n5];
                            int n6 = n4;
                            dArray[n6] = dArray[n6] + 1.0;
                            double[] dArray2 = this.byteSum[n5];
                            int n7 = n4;
                            dArray2[n7] = dArray2[n7] + (double)n;
                            double[] dArray3 = this.sumSquares[n5];
                            int n8 = n4;
                            dArray3[n8] = dArray3[n8] + (double)n * (double)n;
                            if (this.exists[n5]) continue;
                            this.exists[n5] = true;
                        }
                        genericLogReader.nextEvent(logEntryData);
                        break;
                    }
                    genericLogReader.nextEvent(logEntryData);
                }
                while (logEntryData.time < this.endTime) {
                    if (logEntryData.type == 2) {
                        n5 = logEntryData.entry;
                        genericLogReader.nextEvent(logEntryData);
                        while (logEntryData.type != 3 && logEntryData.type != 7 && logEntryData.time < this.endTime) {
                            if (logEntryData.type == 1) {
                                n4 = logEntryData.entry;
                                n = logEntryData.msglen;
                                if (this.minStats[n5][n4] > n || this.minStats[n5][n4] == 0) {
                                    this.minStats[n5][n4] = n;
                                }
                                if (this.maxStats[n5][n4] < n) {
                                    this.maxStats[n5][n4] = n;
                                }
                                double[] dArray = this.msgCount[n5];
                                int n9 = n4;
                                dArray[n9] = dArray[n9] + 1.0;
                                double[] dArray4 = this.byteSum[n5];
                                int n10 = n4;
                                dArray4[n10] = dArray4[n10] + (double)n;
                                double[] dArray5 = this.sumSquares[n5];
                                int n11 = n4;
                                dArray5[n11] = dArray5[n11] + (double)n * (double)n;
                                if (!this.exists[n5]) {
                                    this.exists[n5] = true;
                                }
                            }
                            genericLogReader.nextEvent(logEntryData);
                        }
                    }
                    genericLogReader.nextEvent(logEntryData);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
        for (int i = 0; i < this.numEPs; ++i) {
            if (!this.exists[i]) continue;
            for (n = 0; n < this.numEPs; ++n) {
                if (this.msgCount[i][n] == 1.0) {
                    this.varStats[i][n] = 0.0;
                    continue;
                }
                if (!(this.msgCount[i][n] > 1.0)) continue;
                double d = this.byteSum[i][n] / this.msgCount[i][n];
                this.varStats[i][n] = (this.sumSquares[i][n] - 2.0 * d * this.byteSum[i][n] + d * d * this.msgCount[i][n]) / (this.msgCount[i][n] - 1.0);
            }
        }
        progressMonitor.close();
    }

    public String[][] getCallTableText(boolean bl, boolean bl2) {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.numEPs; ++i) {
            if (!this.exists[i]) continue;
            ++n2;
            for (n = 0; n < this.numEPs; ++n) {
                if (!(this.msgCount[i][n] > 0.0)) continue;
                n2 += 2;
            }
            n2 += 2;
        }
        String[][] stringArray = new String[n2][1];
        n = 0;
        for (int i = 0; i < this.numEPs; ++i) {
            if (!this.exists[i]) continue;
            if (bl) {
                stringArray[n][0] = Analysis.getEntryChareName(i) + "::" + Analysis.getEntryName(i);
            } else {
                String string = Analysis.getEntryName(i);
                int n3 = string.indexOf(40);
                if (n3 != -1) {
                    string = string.substring(0, n3);
                }
                stringArray[n][0] = string;
            }
            ++n;
            for (int j = 0; j < this.numEPs; ++j) {
                if (!(this.msgCount[i][j] > 0.0)) continue;
                if (bl) {
                    stringArray[n][0] = "        " + Analysis.getEntryChareName(j) + "::" + Analysis.getEntryName(j);
                } else {
                    String string = Analysis.getEntryName(j);
                    int n4 = string.indexOf(40);
                    if (n4 != -1) {
                        string = string.substring(0, n4);
                    }
                    stringArray[n][0] = "        " + string;
                }
                stringArray[++n][0] = bl2 ? "                Msg's Rec'd=" + this._format.format(this.msgCount[i][j]) + "  Bytes Rec'd=" + this._format.format(this.byteSum[i][j]) + "  Min=" + this._format.format(this.minStats[i][j]) + "  Max=" + this._format.format(this.maxStats[i][j]) + "  Mean=" + this._format.format(this.byteSum[i][j] / this.msgCount[i][j]) + "  Variance=" + this._format.format(this.varStats[i][j]) : "";
                ++n;
            }
            stringArray[n][0] = "";
            stringArray[++n][0] = "";
            ++n;
        }
        return stringArray;
    }

    public void PrintToFile() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("calltable"));
            bufferedWriter.write("CALL TABLE FOR " + Analysis.getFilename() + ".sts -\n");
            for (int i = 0; i < this.numEPs; ++i) {
                if (!this.exists[i]) continue;
                bufferedWriter.write("\n\n");
                bufferedWriter.write(Analysis.getEntryChareName(i) + "::" + Analysis.getEntryName(i) + "[EPid #" + i + "]\n");
                for (int j = 0; j < this.numEPs; ++j) {
                    if (!(this.msgCount[i][j] > 0.0)) continue;
                    bufferedWriter.write("    " + Analysis.getEntryChareName(j) + "::" + Analysis.getEntryName(j) + "[EPid #" + j + "] - " + this.msgCount[i][j] + " messages, " + this.byteSum[i][j] + " bytes\n");
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

