/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

public class IntervalUtils {
    private static int getDestIndex(long l, long l2, long l3, boolean bl) {
        if (!bl && l % l3 == 0L) {
            return (int)(l / l3 - l2 - 1L);
        }
        return (int)(l / l3 - l2);
    }

    public static void fillIntervals(double[] dArray, long l, long l2, long l3, long l4, double d, boolean bl) {
        int n;
        long l5 = l2 + (long)dArray.length - 1L;
        long l6 = l2 * l;
        long l7 = (l5 + 1L) * l;
        long l8 = l4 - l3;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (l4 <= l6 || l3 >= l7) {
            return;
        }
        if (l3 < l6) {
            d3 = (double)(l6 - l3) / (double)l8;
            l3 = l6;
        }
        if (l4 > l7) {
            d4 = (double)(l4 - l7) / (double)l8;
            l4 = l7;
        }
        l8 = l4 - l3;
        d2 = d * (1.0 - d3 - d4);
        d = bl ? Math.rint(d2) : d2;
        int n2 = IntervalUtils.getDestIndex(l3, l2, l, true);
        if (n2 == (n = IntervalUtils.getDestIndex(l4, l2, l, false))) {
            int n3 = n2;
            dArray[n3] = dArray[n3] + d;
            return;
        }
        d3 = (double)(((long)n2 + l2 + 1L) * l - l3) / (double)l8;
        d4 = (double)(l4 - ((long)n + l2) * l) / (double)l8;
        if (!bl) {
            d5 += d3 * d;
            int n4 = n2;
            dArray[n4] = dArray[n4] + d3 * d;
            d5 += d4 * d;
            int n5 = n;
            dArray[n5] = dArray[n5] + d4 * d;
            d -= d5;
            int n6 = n - n2 - 1;
            int n7 = n2 + 1;
            while (n7 < n) {
                int n8 = n7++;
                dArray[n8] = dArray[n8] + d / (double)n6;
            }
        } else {
            double d6 = Math.rint(d * (1.0 - d3 - d4));
            double d7 = Math.rint((d - d6) * d3);
            double d8 = d - d6 - d7;
            int n9 = n2;
            dArray[n9] = dArray[n9] + d7;
            int n10 = n;
            dArray[n10] = dArray[n10] + d8;
            double d9 = 0.0;
            d5 = d6 / (double)(n - n2 - 1);
            for (int i = n2 + 1; i < n; ++i) {
                int n11 = i;
                dArray[n11] = dArray[n11] + Math.floor(d9 += d5);
                d9 -= Math.floor(d9);
                if (i != n - 1) continue;
                int n12 = i;
                dArray[n12] = dArray[n12] + Math.rint(d9);
            }
        }
    }

    public static double utilToTime(double d, double d2) {
        return d * d2 / 100.0;
    }

    public static double timeToUtil(double d, double d2) {
        return d / d2 * 100.0;
    }

    public static void utilToTime(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * d / 100.0;
        }
    }

    public static void timeToUtil(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] / d * 100.0;
        }
    }

    public static double getBestIntervalSize(double d, int n) {
        double d2 = 1.0;
        double d3 = 10.0;
        double d4 = 1.0;
        int n2 = 0;
        while (true) {
            if (d > d2 && d <= d3) {
                d4 = d3;
                n2 = (int)Math.ceil(d * (double)n / d4);
                break;
            }
            d2 *= 10.0;
            d3 *= 10.0;
        }
        while (!(n2 > 10 && n2 <= 1000 || n2 <= 10 && d4 == 1.0)) {
            if (n2 <= 10) {
                n2 *= 10;
                d4 /= 10.0;
                continue;
            }
            n2 = (int)Math.ceil((double)n2 / 10.0);
            d4 *= 10.0;
        }
        return d4;
    }

    public static double[] rebin(double[] dArray, double d, int n) {
        double[] dArray2 = new double[n];
        double d2 = (double)dArray.length * d / (double)n;
        for (int i = 0; i < dArray.length; ++i) {
            int n2;
            int n3 = (int)Math.floor((double)i * d / d2);
            if (n3 == (n2 = i == dArray.length - 1 ? n - 1 : (int)Math.floor((double)(i + 1) * d / d2))) {
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + dArray[i];
                continue;
            }
            double d3 = ((double)(n3 + 1) * d2 - (double)i * d) / d;
            int n5 = n3;
            dArray2[n5] = dArray2[n5] + dArray[i] * d3;
            double d4 = ((double)(i + 1) * d - (double)n2 * d2) / d;
            int n6 = n2;
            dArray2[n6] = dArray2[n6] + dArray[i] * d4;
            double d5 = dArray[i] * (1.0 - d3 - d4);
            double d6 = 0.0;
            if (n2 - n3 - 1 > 0) {
                d6 = d5 / (double)(n2 - n3 - 1);
            }
            int n7 = n3 + 1;
            while (n7 < n2) {
                int n8 = n7++;
                dArray2[n8] = dArray2[n8] + d6;
            }
        }
        return dArray2;
    }

    public static double[] rebin(double[] dArray, double d, double d2) {
        int n = (int)Math.ceil((double)dArray.length * d / d2);
        return IntervalUtils.rebin(dArray, d, n);
    }

    public static int getBin(long l, long l2) {
        return (int)(l2 / l);
    }

    public static void printArray(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        long l = 100L;
        long l2 = 150L;
        long l3 = 450L;
        double[] dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 0L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 10L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 14L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 15L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 40L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 44L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, l, 45L, l2, l3, l3 - l2, false);
        IntervalUtils.printArray(dArray);
    }
}

