/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class LogReader
extends ProjDefs {
    public static final int SYS_Q = 0;
    public static final int SYS_CPU = 1;
    public static final int SYS_IDLE = 2;
    public static final int IDLE_ENTRY = -1;
    public static final int CREATE = 0;
    public static final int PROCESS = 1;
    public static final int TIME = 2;
    private int[][][] sysUsgData;
    private int[][][][] userEntries;
    private int[][][][] categorized;
    private int numProcessors;
    private int numUserEntries;
    private long startTime;
    private int currentEntry;
    private int currentMtype;
    private int interval;
    private int curPeIdx;
    private int numIntervals;
    private long intervalSize;
    private int intervalStart;
    private int intervalEnd;
    private int processing;
    private boolean byEntryPoint;
    private LogEntryData curData = new LogEntryData();
    private GenericLogReader reader;
    private long sendTime;
    private int[] destPEs;
    private long prevTime = 0L;
    private boolean deltaEncoded = false;
    private int tokenExpected = 2;

    public long getIntervalSize() {
        return this.intervalSize;
    }

    private final void addToInterval(int n, int n2, boolean bl) {
        if (this.processing <= 0) {
            return;
        }
        if (n2 < this.intervalStart || n2 > this.intervalEnd) {
            return;
        }
        if (this.currentEntry == -1) {
            int[] nArray = this.sysUsgData[2][this.curPeIdx];
            int n3 = n2 - this.intervalStart;
            nArray[n3] = nArray[n3] + (bl ? 100 : n);
        } else {
            int[] nArray = this.sysUsgData[1][this.curPeIdx];
            int n4 = n2 - this.intervalStart;
            nArray[n4] = nArray[n4] + (bl ? 100 : n);
            if (this.byEntryPoint) {
                int[] nArray2 = this.userEntries[this.currentEntry][2][this.curPeIdx];
                int n5 = n2 - this.intervalStart;
                nArray2[n5] = nArray2[n5] + n;
                int n6 = this.mtypeToCategoryIdx(this.currentMtype);
                if (n6 != -1) {
                    int[] nArray3 = this.categorized[n6][2][this.curPeIdx];
                    int n7 = n2 - this.intervalStart;
                    nArray3[n7] = nArray3[n7] + n;
                }
            }
        }
        this.startTime += (long)n;
    }

    private final void count(int n, int n2, int n3) {
        if (!this.byEntryPoint) {
            return;
        }
        if (this.userEntries[n2][n3][this.curPeIdx] == null) {
            this.userEntries[n2][n3][this.curPeIdx] = new int[this.numIntervals + 1];
        }
        if (n3 == 1 && this.userEntries[n2][2][this.curPeIdx] == null) {
            this.userEntries[n2][2][this.curPeIdx] = new int[this.numIntervals + 1];
        }
        int[] nArray = this.userEntries[n2][n3][this.curPeIdx];
        int n4 = this.interval - this.intervalStart;
        nArray[n4] = nArray[n4] + 1;
        int n5 = this.mtypeToCategoryIdx(n);
        if (n5 != -1) {
            if (this.categorized[n5][n3][this.curPeIdx] == null) {
                this.categorized[n5][n3][this.curPeIdx] = new int[this.numIntervals + 1];
                if (n3 == 1) {
                    this.categorized[n5][2][this.curPeIdx] = new int[this.numIntervals + 1];
                }
            }
            int[] nArray2 = this.categorized[n5][n3][this.curPeIdx];
            int n6 = this.interval - this.intervalStart;
            nArray2[n6] = nArray2[n6] + 1;
        }
    }

    private void fillToInterval(int n) {
        if (this.interval >= n) {
            return;
        }
        int n2 = (int)((long)(this.interval + 1) * this.intervalSize - this.startTime);
        this.addToInterval(n2, this.interval, false);
        this.rescale(this.interval);
        for (int i = this.interval + 1; i < n; ++i) {
            this.addToInterval((int)this.intervalSize, i, true);
        }
        this.interval = n;
    }

    public int[][][][] getSystemMsgs() {
        return this.categorized;
    }

    public int[][][] getSystemUsageData() {
        return this.sysUsgData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntries;
    }

    private void intervalCalc(int n, int n2, int n3, long l) throws IOException {
        this.fillToInterval((int)(l / this.intervalSize));
        switch (n) {
            case 4: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n4 = this.interval - this.intervalStart;
                nArray[n4] = nArray[n4] + 1;
                break;
            }
            case 1: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n5 = this.interval - this.intervalStart;
                nArray[n5] = nArray[n5] + 1;
                this.count(n2, n3, 0);
                break;
            }
            case 21: {
                break;
            }
            case 2: {
                ++this.processing;
                this.startTime = l;
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n6 = this.interval - this.intervalStart;
                nArray[n6] = nArray[n6] - 1;
                this.currentMtype = n2;
                this.currentEntry = n3;
                this.count(this.currentMtype, this.currentEntry, 1);
                break;
            }
            case 3: {
                if (n2 == -5) break;
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(l - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            case 14: {
                ++this.processing;
                this.startTime = l;
                this.currentEntry = -1;
                break;
            }
            case 15: {
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(l - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            default: {
                System.out.println("Unhandled type " + n + " in logreader!");
            }
        }
    }

    private final int mtypeToCategoryIdx(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 14: 
            case 15: {
                return 4;
            }
        }
        return -1;
    }

    public void read(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        this.numProcessors = Analysis.getNumProcessors();
        this.numUserEntries = Analysis.getNumUserEntries();
        this.intervalSize = l;
        this.intervalStart = n;
        this.intervalEnd = n2;
        this.numIntervals = this.intervalEnd - this.intervalStart + 1;
        this.byEntryPoint = bl;
        if (orderedIntList == null) {
            orderedIntList = new OrderedIntList();
            for (int i = 0; i < this.numProcessors; ++i) {
                orderedIntList.insert(i);
            }
        } else {
            this.numProcessors = orderedIntList.size();
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading log files", "", 0, this.numProcessors);
        progressMonitor.setNote("Allocating Global Memory");
        progressMonitor.setProgress(0);
        this.sysUsgData = new int[3][this.numProcessors][];
        if (this.byEntryPoint) {
            this.userEntries = new int[this.numUserEntries][3][this.numProcessors][this.numIntervals];
            this.categorized = new int[5][3][this.numProcessors][];
        }
        orderedIntList.reset();
        int n3 = orderedIntList.nextElement();
        this.curPeIdx = 0;
        while (n3 != -1) {
            progressMonitor.setProgress(this.curPeIdx);
            progressMonitor.setNote("[PE: " + n3 + " ] Allocating Memory.");
            this.sysUsgData[0][this.curPeIdx] = new int[this.numIntervals + 1];
            this.sysUsgData[1][this.curPeIdx] = new int[this.numIntervals + 1];
            this.sysUsgData[2][this.curPeIdx] = new int[this.numIntervals + 1];
            progressMonitor.setNote("[PE: " + n3 + " ] Reading data.");
            if (progressMonitor.isCanceled()) {
                this.userEntries = null;
                this.categorized = null;
                this.sysUsgData = null;
                return;
            }
            this.processing = 0;
            this.interval = 0;
            this.currentEntry = -1;
            this.startTime = 0L;
            int n4 = 2;
            this.reader = new GenericLogReader(n3, Analysis.getVersion());
            boolean bl2 = false;
            try {
                while (true) {
                    this.reader.nextEvent(this.curData);
                    ++n4;
                    switch (this.curData.type) {
                        case 14: 
                        case 15: {
                            this.intervalCalc(this.curData.type, 0, 0, this.curData.time);
                            break;
                        }
                        case 1: {
                            this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            break;
                        }
                        case 2: {
                            if (bl2) {
                                this.intervalCalc(3, this.curData.mtype, this.curData.entry, this.curData.time);
                                bl2 = false;
                            }
                            this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            if (!bl2) {
                                this.intervalCalc(this.curData.type, -5, this.curData.entry, this.curData.time);
                            } else {
                                this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            }
                            bl2 = false;
                            break;
                        }
                        case 4: {
                            this.intervalCalc(this.curData.type, this.curData.mtype, 0, this.curData.time);
                            break;
                        }
                        case 7: {
                            this.fillToInterval(this.numIntervals);
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                System.err.println("Error! Failed to close reader!");
                System.exit(-1);
            }
            ++this.curPeIdx;
            n3 = orderedIntList.nextElement();
        }
        progressMonitor.close();
    }

    private void rescale(int n) {
        if (n < this.intervalStart || n > this.intervalEnd) {
            return;
        }
        this.sysUsgData[1][this.curPeIdx][n - this.intervalStart] = (int)((long)(this.sysUsgData[1][this.curPeIdx][n - this.intervalStart] * 100) / this.intervalSize);
        this.sysUsgData[2][this.curPeIdx][n - this.intervalStart] = (int)((long)(this.sysUsgData[2][this.curPeIdx][n - this.intervalStart] * 100) / this.intervalSize);
    }
}

