/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import projections.misc.LogLoadException;

public class ProjectionsConfigurationReader {
    private String baseName;
    private String logDirectory;
    private String configurationName;
    private Hashtable configData = new Hashtable();
    private boolean dirty;

    public ProjectionsConfigurationReader(String string, String string2) {
        this.baseName = string;
        this.logDirectory = string2;
        this.configurationName = string + ".projrc";
        this.dirty = false;
        try {
            this.read();
        }
        catch (LogLoadException logLoadException) {
            System.err.println(logLoadException.toString());
            System.exit(-1);
        }
    }

    public void read() throws LogLoadException {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.configurationName)));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                Object object = this.readValue(string2, stringTokenizer);
                if (object != null) {
                    this.configData.put(string2, object);
                    continue;
                }
                System.err.println("Internal Error: Unknown projections configuration key [" + string2 + "]! Please inform developers.");
                System.exit(-1);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                File file = new File(this.configurationName);
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                System.exit(-1);
            }
        }
        catch (IOException iOException) {
            throw new LogLoadException(this.configurationName, 1);
        }
    }

    public void add(String string, Object object) {
        this.configData.put(string, object);
        this.dirty = true;
    }

    public Object getValue(String string) {
        return this.configData.get(string);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (LogLoadException logLoadException) {
            System.err.println(logLoadException.toString());
            System.exit(-1);
        }
    }

    private Object readValue(String string, StringTokenizer stringTokenizer) {
        if (string.equals("REAL_TOTAL_TIME")) {
            return Long.valueOf(stringTokenizer.nextToken());
        }
        if (string.equals("POSE_REAL_TOTAL_TIME")) {
            return Double.valueOf(stringTokenizer.nextToken());
        }
        if (string.equals("POSE_VIRT_TOTAL_TIME")) {
            return Long.valueOf(stringTokenizer.nextToken());
        }
        return null;
    }

    private void writeValue(String string, Object object, PrintWriter printWriter) {
        if (string.equals("REAL_TOTAL_TIME")) {
            printWriter.print((Long)object);
        } else if (string.equals("POSE_REAL_TOTAL_TIME")) {
            printWriter.print((Double)object);
        } else if (string.equals("POSE_VIRT_TOTAL_TIME")) {
            printWriter.print((Long)object);
        } else {
            System.err.println("Internal Error: Unknown key [" + string + "]! Please report to developers!");
            System.exit(-1);
        }
    }

    private void flush() throws LogLoadException {
        if (this.dirty) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.configurationName));
                Iterator iterator = this.configData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    printWriter.print((String)entry.getKey() + " ");
                    this.writeValue((String)entry.getKey(), entry.getValue(), printWriter);
                    printWriter.println();
                }
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new LogLoadException(this.configurationName, 0);
            }
            catch (IOException iOException) {
                throw new LogLoadException(this.configurationName, 3);
            }
        } else {
            return;
        }
    }
}

