/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import projections.analysis.Chare;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.misc.LogLoadException;

public class StsReader
extends ProjDefs {
    private boolean hasPAPI = false;
    private double version;
    private String Machine;
    private int NumPe;
    private int TotalChares;
    private int EntryCount;
    private int TotalMsgs;
    private String[] ClassNames;
    private Chare[] ChareList;
    private long[] MsgTable;
    private String[][] EntryNames;
    private int userEventIndex = 0;
    private Hashtable userEventIndices = new Hashtable();
    private Hashtable userEvents = new Hashtable();
    private String[] userEventNames;
    private int functionEventIndex = 0;
    private Hashtable functionEventIndices = new Hashtable();
    private Hashtable functionEvents = new Hashtable();
    private String[] functionEventNames;
    private int numPapiEvents;
    private String[] papiEventNames;

    public StsReader(String string) throws LogLoadException {
        this(string, false);
    }

    public StsReader(String string, boolean bl) throws LogLoadException {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                Comparable<StringBuffer> comparable;
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("VERSION")) {
                    this.version = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                if (string4.equals("MACHINE")) {
                    this.Machine = stringTokenizer.nextToken();
                    continue;
                }
                if (string4.equals("PROCESSORS")) {
                    this.NumPe = Integer.parseInt(stringTokenizer.nextToken());
                    continue;
                }
                if (string4.equals("TOTAL_CHARES")) {
                    this.TotalChares = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList = new Chare[this.TotalChares];
                    this.ClassNames = new String[this.TotalChares];
                    continue;
                }
                if (string4.equals("TOTAL_EPS")) {
                    this.EntryCount = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames = new String[this.EntryCount][2];
                    continue;
                }
                if (string4.equals("TOTAL_MSGS")) {
                    this.TotalMsgs = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable = new long[this.TotalMsgs];
                    continue;
                }
                if (string4.equals("CHARE") || string2.equals("BOC")) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    this.ChareList[n] = new Chare();
                    this.ChareList[n].ChareID = n;
                    this.ChareList[n].NumEntries = 0;
                    this.ChareList[n].Name = stringTokenizer.nextToken();
                    this.ChareList[n].Type = new String(string4);
                    this.ClassNames[n] = this.ChareList[n].Name;
                    continue;
                }
                if (string4.equals("ENTRY")) {
                    String string5 = stringTokenizer.nextToken();
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    comparable = new StringBuffer(stringTokenizer.nextToken());
                    String string6 = ((StringBuffer)comparable).toString();
                    if (-1 != string6.indexOf(40) && -1 == string6.indexOf(41)) {
                        do {
                            string3 = stringTokenizer.nextToken();
                            ((StringBuffer)comparable).append(" ");
                            ((StringBuffer)comparable).append(string3);
                        } while (!string3.endsWith(")"));
                    }
                    string6 = ((StringBuffer)comparable).toString();
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    this.EntryNames[n][0] = string6;
                    this.EntryNames[n][1] = this.ClassNames[n2];
                    if (bl) continue;
                    Analysis.activityManager.registerActivity("Entry Method", n, this.EntryNames[n][0]);
                    continue;
                }
                if (string4.equals("MESSAGE")) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    this.MsgTable[n] = n4;
                    continue;
                }
                if (string4.equals("FUNCTION")) {
                    comparable = new Integer(stringTokenizer.nextToken());
                    if (this.functionEvents.containsKey(comparable)) continue;
                    string3 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + " ";
                    }
                    this.functionEvents.put(comparable, string3);
                    this.functionEventNames[this.functionEventIndex] = string3;
                    this.functionEventIndices.put(comparable, new Integer(this.functionEventIndex));
                    if (!bl) {
                        Analysis.activityManager.registerActivity("Function", this.functionEventIndex, string3);
                    }
                    ++this.functionEventIndex;
                    continue;
                }
                if (string4.equals("EVENT")) {
                    comparable = new Integer(stringTokenizer.nextToken());
                    if (this.userEvents.containsKey(comparable)) continue;
                    string3 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + " ";
                    }
                    this.userEvents.put(comparable, string3);
                    this.userEventNames[this.userEventIndex] = string3;
                    this.userEventIndices.put(comparable, new Integer(this.userEventIndex++));
                    continue;
                }
                if (string4.equals("TOTAL_EVENTS")) {
                    this.userEventNames = new String[Integer.parseInt(stringTokenizer.nextToken())];
                    continue;
                }
                if (string4.equals("TOTAL_FUNCTIONS")) {
                    this.functionEventNames = new String[Integer.parseInt(stringTokenizer.nextToken())];
                    continue;
                }
                if (string4.equals("TOTAL_PAPI_EVENTS")) {
                    this.hasPAPI = true;
                    this.numPapiEvents = Integer.parseInt(stringTokenizer.nextToken());
                    this.papiEventNames = new String[this.numPapiEvents];
                    continue;
                }
                if (string4.equals("PAPI_EVENT")) {
                    this.hasPAPI = true;
                    this.papiEventNames[Integer.parseInt((String)stringTokenizer.nextToken())] = stringTokenizer.nextToken();
                    continue;
                }
                if (!string4.equals("END")) continue;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LogLoadException(string, 0);
        }
        catch (IOException iOException) {
            throw new LogLoadException(string, 1);
        }
    }

    public double getVersion() {
        return this.version;
    }

    public int getEntryCount() {
        return this.EntryCount;
    }

    public int getProcessorCount() {
        return this.NumPe;
    }

    public String getMachineName() {
        return this.Machine;
    }

    public String[][] getEntryNames() {
        return this.EntryNames;
    }

    public int getNumUserDefinedEvents() {
        return this.userEvents.size();
    }

    public int getUserEventIndex(int n) {
        Integer n2 = new Integer(n);
        return (Integer)this.userEventIndices.get(n2);
    }

    public String getUserEventName(int n) {
        Integer n2 = new Integer(n);
        return (String)this.userEvents.get(n2);
    }

    public String[] getUserEventNames() {
        return this.userEventNames;
    }

    public int getNumFunctionEvents() {
        if (this.functionEvents.size() == 0) {
            return 0;
        }
        return this.functionEvents.size() + 1;
    }

    public int getFunctionEventIndex(int n) {
        Integer n2 = new Integer(n);
        return (Integer)this.functionEventIndices.get(n2);
    }

    public String getFunctionEventDescriptor(int n) {
        Integer n2 = new Integer(n);
        return (String)this.functionEvents.get(n2);
    }

    public String[] getFunctionEventDescriptors() {
        return this.functionEventNames;
    }

    public int getNumPerfCounts() {
        if (this.hasPAPI) {
            return this.numPapiEvents;
        }
        return 0;
    }

    public String[] getPerfCountNames() {
        if (this.hasPAPI) {
            return this.papiEventNames;
        }
        return null;
    }

    public boolean hasPapi() {
        return this.hasPAPI;
    }
}

