/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.analysis.CallTable;
import projections.gui.Analysis;
import projections.gui.CallTableTextArea;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;

public class CallTableWindow
extends ProjectionsWindow
implements ItemListener {
    private CallTableWindow thisWindow = this;
    private CallTableTextArea textArea;
    private Label lTitle;
    private Panel titlePanel;
    private JPanel mainPanel;
    private JPanel checkBoxPanel1;
    private JPanel checkBoxPanel2;
    private JPanel controlPanel;
    private JButton setRanges;
    private CheckboxGroup cbg1;
    private Checkbox epDetailOn;
    private Checkbox epDetailOff;
    private CheckboxGroup cbg2;
    private Checkbox statsOn;
    private Checkbox statsOff;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;
    private CallTable ct;
    private boolean epDetailToggle;
    private boolean statsToggle;

    void windowInit() {
    }

    public CallTableWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Call Table - " + Analysis.getFilename() + ".sts");
        this.mainPanel = new JPanel();
        this.epDetailToggle = false;
        this.statsToggle = false;
        this.setLayout(this.mainPanel);
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        if (actionEvent.getSource() instanceof JButton && (jButton = (JButton)actionEvent.getSource()) == this.setRanges) {
            this.showDialog();
        }
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    CallTableWindow.this.ct = new CallTable(CallTableWindow.this.startTime, CallTableWindow.this.endTime, CallTableWindow.this.validPEs);
                    CallTableWindow.this.ct.GatherData(CallTableWindow.this.thisWindow);
                    CallTableWindow.this.textArea.setText(CallTableWindow.this.ct.getCallTableText(CallTableWindow.this.epDetailToggle, CallTableWindow.this.statsToggle));
                    return null;
                }

                public void finished() {
                }
            };
            swingWorker.start();
        }
    }

    private void CreateLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.textArea = new CallTableTextArea();
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new Label("CALL TABLE", 1);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        this.cbg1 = new CheckboxGroup();
        this.epDetailOff = new Checkbox("EP Detail Off", this.cbg1, true);
        this.epDetailOff.addItemListener(this);
        this.epDetailOn = new Checkbox("EP Detail On", this.cbg1, false);
        this.epDetailOn.addItemListener(this);
        this.checkBoxPanel1 = new JPanel();
        Util.gblAdd(this.checkBoxPanel1, this.epDetailOff, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel1, this.epDetailOn, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        this.cbg2 = new CheckboxGroup();
        this.statsOff = new Checkbox("Statistics Off", this.cbg2, true);
        this.statsOff.addItemListener(this);
        this.statsOn = new Checkbox("Statistics On", this.cbg2, false);
        this.statsOn.addItemListener(this);
        this.checkBoxPanel2 = new JPanel();
        Util.gblAdd(this.checkBoxPanel2, this.statsOff, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel2, this.statsOn, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.titlePanel, gridBagConstraints, 0, 1, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.textArea, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel1, gridBagConstraints, 0, 3, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel2, gridBagConstraints, 0, 4, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 5, 1, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            this.setCheckboxData(checkbox);
            this.setCursor(new Cursor(0));
        }
    }

    public void setCheckboxData(Checkbox checkbox) {
        if (checkbox == this.epDetailOff) {
            this.epDetailToggle = false;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (checkbox == this.epDetailOn) {
            this.epDetailToggle = true;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (checkbox == this.statsOff) {
            this.statsToggle = false;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        } else if (checkbox == this.statsOn) {
            this.statsToggle = true;
            this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
        }
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    public void showWindow() {
    }
}

