/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PopUpAble;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisDiscrete;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;
import projections.gui.graph.YAxisFixed;

public abstract class GenericGraphWindow
extends ProjectionsWindow
implements PopUpAble {
    static final Color BACKGROUND = Analysis.background;
    protected GraphPanel graphPanel;
    protected Graph graphCanvas;
    protected DataSource dataSource;
    protected XAxis xAxis;
    protected YAxis yAxis;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu fileMenu = new JMenu("File");
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;

    protected abstract void setGraphSpecificData();

    void windowInit() {
        this.validPEs = Analysis.getValidProcessorList();
        this.startTime = 0L;
        this.endTime = Analysis.getTotalTime();
    }

    public GenericGraphWindow(String string, MainWindow mainWindow, Integer n) {
        super(string, mainWindow, n);
        this.setBackground(BACKGROUND);
        this.menuBar.add(this.fileMenu);
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Set Range", "Close"}, null, this);
        this.setJMenuBar(this.menuBar);
    }

    public abstract String[] getPopup(int var1, int var2);

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        this.graphCanvas = new Graph();
        this.graphPanel = new GraphPanel(this.graphCanvas);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.graphPanel);
        return jPanel;
    }

    protected void setStackGraph(boolean bl) {
        if (this.graphCanvas != null) {
            this.graphCanvas.setStackGraph(bl);
        } else {
            System.err.println("Warning: The graph canvas has not yet been initialized! Ignoring request.");
        }
    }

    protected void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    protected void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    protected void setXAxis(String string, String string2) {
        this.xAxis = new XAxisFixed(string, string2);
    }

    protected void setXAxis(String string, OrderedIntList orderedIntList) {
        this.xAxis = new XAxisDiscrete(string, orderedIntList);
    }

    protected void setXAxis(String string, String string2, double d, double d2) {
        this.xAxis = new XAxisFixed(string, string2);
        ((XAxisFixed)this.xAxis).setLimits(d, d2);
    }

    protected void setYAxis(String string, String string2) {
        this.yAxis = this.dataSource != null ? new YAxisAuto(string, string2, this.dataSource) : new YAxisFixed(string, string2, 0.0);
    }

    protected void setDataSource(String string, int[] nArray) {
        this.dataSource = new DataSource1D(string, nArray);
        this.dataSource.setColors(Analysis.getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, double[][] dArray) {
        this.dataSource = new DataSource2D(string, dArray);
        this.dataSource.setColors(Analysis.getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, double[][] dArray, Color[] colorArray, GenericGraphWindow genericGraphWindow) {
        this.dataSource = new DataSource2D(string, dArray, (PopUpAble)genericGraphWindow);
        this.dataSource.setColors(colorArray);
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, int[] nArray, GenericGraphWindow genericGraphWindow) {
        this.dataSource = new DataSource1D(string, nArray, genericGraphWindow);
        this.dataSource.setColors(Analysis.getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String string, double[][] dArray, GenericGraphWindow genericGraphWindow) {
        this.dataSource = new DataSource2D(string, dArray, (PopUpAble)genericGraphWindow);
        this.dataSource.setColors(Analysis.getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void refreshGraph() {
        this.graphCanvas.setData(this.dataSource, this.xAxis, this.yAxis);
        this.graphCanvas.repaint();
    }
}

