/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import projections.gui.Analysis;
import projections.gui.GraphData;
import projections.gui.GraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedGraphDataList;
import projections.gui.ZItem;

public class GraphDisplayCanvas
extends Canvas {
    private GraphData data;
    private OrderedGraphDataList graphDataList;
    private Image offscreen;

    public GraphDisplayCanvas() {
        this.setBackground(Analysis.background);
    }

    private void addDataForBar(ZItem zItem, int n) {
        int n2 = this.getSize().height;
        int n3 = 0;
        if (this.data.xmode == 0) {
            n3 = zItem.curPData[n];
            if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
                MainWindow.dataDump.println(n3);
            }
        } else {
            n3 = zItem.curIData[n];
            if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
                MainWindow.dataDump.println(n3);
            }
        }
        n3 = zItem.ymode == 12 ? n2 - (int)(this.data.wscale * (double)n3) : n2 - (int)(this.data.yscale * (double)n3);
        this.graphDataList.insert(n3, zItem.color);
    }

    private void drawDisplay(Graphics graphics) {
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Analysis.background);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Analysis.foreground);
        graphics.translate(-this.data.displayPanel.getHSBValue(), 0);
        if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
            if (this.data.xmode == 0) {
                MainWindow.dataDump.println("--- Graph PE ---");
            } else {
                MainWindow.dataDump.println("--- Graph INT ---");
            }
        }
        if (this.data.graphtype == 20) {
            for (int i = 0; i < this.data.onGraph.length; ++i) {
                if (this.data.ymode == 11) {
                    if (this.data.onGraph[i].ymode == 10) continue;
                    this.drawItemLine(graphics, this.data.onGraph[i]);
                    continue;
                }
                if (this.data.onGraph[i].ymode == 11) continue;
                this.drawItemLine(graphics, this.data.onGraph[i]);
            }
        } else {
            this.graphDataList = new OrderedGraphDataList();
            for (int i = this.data.minx; i <= this.data.maxx; ++i) {
                this.graphDataList.removeAll();
                for (int j = 0; j < this.data.onGraph.length; ++j) {
                    if (this.data.ymode == 11) {
                        if (this.data.onGraph[j].ymode == 10) continue;
                        this.addDataForBar(this.data.onGraph[j], i);
                        continue;
                    }
                    if (this.data.onGraph[j].ymode == 11) continue;
                    this.addDataForBar(this.data.onGraph[j], i);
                }
                this.drawItemBar(graphics, i);
            }
        }
        if (MainWindow.dataDump != null && GraphWindow.dumpNow) {
            MainWindow.dataDump.flush();
            GraphWindow.dumpNow = false;
        }
    }

    private void drawItemBar(Graphics graphics, int n) {
        int n2 = (int)(this.data.xscale * (double)n);
        int n3 = (int)(this.data.xscale * (double)(n + 1)) - n2 - 1;
        if (n3 < 1) {
            n3 = 1;
        }
        n2 += this.data.offset3;
        this.graphDataList.reset();
        while (this.graphDataList.hasMoreElements()) {
            int n4 = this.graphDataList.currentY();
            Color color = this.graphDataList.currentC();
            int n5 = this.getSize().height - n4;
            if (n5 > 0) {
                graphics.setColor(color);
                graphics.fillRect(n2, n4, n3, n5);
            }
            this.graphDataList.nextElement();
        }
    }

    private void drawItemLine(Graphics graphics, ZItem zItem) {
        graphics.setColor(zItem.color);
        int n = -1;
        int n2 = -1;
        int n3 = this.getSize().height;
        for (int i = this.data.minx; i <= this.data.maxx; ++i) {
            int n4;
            boolean bl = false;
            int n5 = this.data.offset3 + (int)((double)i * this.data.xscale);
            if (this.data.xmode == 0) {
                n4 = zItem.curPData[i];
                if (MainWindow.dataDump != null) {
                    MainWindow.dataDump.println(n4);
                }
            } else {
                n4 = zItem.curIData[i];
                if (MainWindow.dataDump != null) {
                    MainWindow.dataDump.println(n4);
                }
            }
            n4 = zItem.ymode == 12 ? n3 - (int)(this.data.wscale * (double)n4) : n3 - (int)(this.data.yscale * (double)n4);
            if (n2 >= 0 && (n4 != n3 || n != n4)) {
                graphics.drawLine(n2, n, n5, n4);
            }
            n2 = n5;
            n = n4;
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            return;
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        this.drawDisplay(graphics2);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.drawImage(this.offscreen, 0, 0, n, n2, 0, 0, n, n2, null);
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawDisplay(graphics);
        ((Graphics2D)graphics).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getSize().width != n3 || this.getSize().height != n4) {
            try {
                this.offscreen = this.createImage(n3, n4);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("NOT ENOUGH MEMORY!");
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

