/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.Analysis;
import projections.gui.GraphData;

public class GraphTitleCanvas
extends Canvas {
    private GraphData data;
    private FontMetrics fm;

    public GraphTitleCanvas() {
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    public int getPreferredHeight() {
        Graphics graphics;
        int n = 0;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        if (this.fm != null) {
            n = this.fm.getHeight() + 20;
        }
        return n;
    }

    public void paint(Graphics graphics) {
        String string;
        if (this.data == null) {
            return;
        }
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        if (this.data.xmode == 0) {
            string = "Interval";
            if (this.data.interval.list.size() > 1) {
                string = string + "s";
            }
            string = string + " " + this.data.interval.string;
        } else {
            string = "Processor";
            if (this.data.processor.list.size() > 1) {
                string = string + "s";
            }
            string = string + " " + this.data.processor.string;
        }
        int n = (this.getSize().width - this.fm.stringWidth(string)) / 2;
        int n2 = (this.getSize().height + this.fm.getHeight()) / 2;
        graphics.setColor(Analysis.background);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Analysis.foreground);
        graphics.drawString(string, n, n2);
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        this.setForeground(Color.black);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.clearRect(0, 0, n, n2);
        this.paint(graphics);
        ((Graphics2D)graphics).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }
}

