/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import projections.gui.Analysis;
import projections.gui.GraphData;
import projections.gui.Util;

public class GraphXAxisCanvas
extends Canvas {
    private GraphData data;
    private FontMetrics fm;
    private int maxvalue;
    private int tickincrement;
    private int numintervals;
    private int labelincrement;
    private double pixelincrement;
    private Image offscreen;

    public GraphXAxisCanvas() {
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    private void drawAxis(Graphics graphics) {
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Analysis.background);
        graphics.fillRect(0, 0, n, n2);
        int n3 = this.data.displayPanel.getHSBValue();
        graphics.translate(-n3, 0);
        int n4 = (int)Math.floor((double)(n3 - this.data.offset3) / this.pixelincrement);
        int n5 = (int)Math.ceil((double)(n3 - this.data.offset3 + n) / this.pixelincrement);
        this.data.minx = n4 * this.tickincrement;
        this.data.maxx = n5 * this.tickincrement;
        if (this.data.minx < 0) {
            this.data.minx = 0;
        }
        if (this.data.maxx > this.maxvalue) {
            this.data.maxx = this.maxvalue;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > this.numintervals) {
            n5 = this.numintervals;
        }
        int n6 = this.data.offset3 + (int)((double)n4 * this.pixelincrement);
        int n7 = this.data.offset3 + (int)((double)n5 * this.pixelincrement);
        if (this.data.graphtype == 21) {
            n7 += (int)this.pixelincrement;
        }
        graphics.setColor(Analysis.foreground);
        graphics.drawLine(n6, 5, n7, 5);
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        String string = this.data.xmode == 0 ? "Processor" : "Time (in s)";
        int n8 = n3 + (n - this.fm.stringWidth(string)) / 2;
        int n9 = n2 - 5;
        graphics.drawString(string, n8, n9);
        for (int i = n4; i <= n5; ++i) {
            int n10 = this.data.offset3 + (int)((double)i * this.pixelincrement);
            if (this.data.graphtype == 21) {
                n10 += (int)(this.pixelincrement / 2.0);
            }
            if (i % this.labelincrement == 0) {
                String string2;
                graphics.drawLine(n10, 0, n10, 10);
                if (this.data.xmode == 0) {
                    this.data.origProcList.reset();
                    int n11 = this.data.origProcList.nextElement();
                    for (int j = 0; j < i * this.tickincrement; ++j) {
                        n11 = this.data.origProcList.nextElement();
                    }
                    string2 = "" + n11;
                } else {
                    double d = (double)(i * this.tickincrement + this.data.intervalStart) * (double)this.data.interval.size / 1000000.0;
                    string2 = "" + d;
                }
                graphics.drawString(string2, n10 - this.fm.stringWidth(string2) / 2, 15 + this.fm.getHeight());
                continue;
            }
            graphics.drawLine(n10, 3, n10, 7);
        }
    }

    public int getPreferredHeight() {
        Graphics graphics;
        int n = 0;
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
        }
        if (this.fm != null) {
            n = this.fm.getHeight() * 2 + 20;
        }
        return n;
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            return;
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        this.drawAxis(graphics2);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.drawImage(this.offscreen, 0, 0, n, n2, 0, 0, n, n2, null);
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        this.setForeground(Color.black);
        this.drawAxis(graphics);
        ((Graphics2D)graphics).setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.fm == null) {
            Graphics graphics = this.getGraphics();
            this.fm = graphics.getFontMetrics(graphics.getFont());
            graphics.dispose();
        }
        this.maxvalue = this.data.xmode == 0 ? this.data.processor.num - 1 : this.data.interval.num - 1;
        int n5 = this.fm.stringWidth("" + this.maxvalue);
        this.data.offset3 = n5 / 2;
        if (this.data.graphtype == 21) {
            ++this.maxvalue;
        }
        int n6 = (int)((float)n3 * this.data.scale) - 2 * this.data.offset3;
        this.tickincrement = (int)Math.ceil(5.0 / ((double)n6 / (double)this.maxvalue));
        this.tickincrement = Util.getBestIncrement(this.tickincrement);
        this.numintervals = (int)Math.ceil((double)this.maxvalue / (double)this.tickincrement);
        this.pixelincrement = (double)n6 / (double)this.numintervals;
        this.labelincrement = (int)Math.ceil((double)(n5 + 20) / this.pixelincrement);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        this.data.xscale = this.pixelincrement / (double)this.tickincrement;
        if (this.data.graphtype == 21) {
            --this.numintervals;
            --this.maxvalue;
        }
        if (this.getSize().width != n3 || this.getSize().height != n4) {
            try {
                this.offscreen = this.createImage(n3, n4);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("NOT ENOUGH MEMORY!");
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
        this.maxvalue = 0;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

