/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import projections.gui.Analysis;
import projections.gui.IntTextField;
import projections.gui.LogFileViewerWindow;
import projections.gui.Util;

public class LogFileViewerDialog
extends Dialog
implements ActionListener,
TextListener {
    private IntTextField textField;
    private int pnum;
    private int pmax;
    private Button bOK;
    private Button bCancel;
    private LogFileViewerWindow logFilesWindow;

    public LogFileViewerDialog(LogFileViewerWindow logFileViewerWindow) {
        super(logFileViewerWindow, "Select Log File", true);
        this.logFilesWindow = logFileViewerWindow;
        this.pmax = Analysis.getNumProcessors() - 1;
        Label label = new Label("Select a processor to view the log file for.");
        Label label2 = new Label("Valid processors: (0 - " + this.pmax + ")");
        this.textField = new IntTextField(0, 5);
        this.textField.addTextListener(this);
        this.textField.addActionListener(this);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.setLayout(gridBagLayout);
        Util.gblAdd(this, label, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(this, label2, gridBagConstraints, 0, 1, 1, 1, 1, 1, 0, 5, 5, 5);
        Util.gblAdd(this, this.textField, gridBagConstraints, 0, 2, 1, 1, 1, 1, 5, 5, 5, 5);
        Panel panel = new Panel();
        panel.add(this.bOK);
        panel.add(this.bCancel);
        Util.gblAdd(this, panel, gridBagConstraints, 0, 3, 1, 1, 1, 1, 5, 5, 5, 5);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bOK) {
                this.logFilesWindow.setLogFileNum(this.textField.getValue());
            }
            this.logFilesWindow.CloseDialog();
        } else if (actionEvent.getSource() instanceof IntTextField) {
            this.logFilesWindow.setLogFileNum(this.textField.getValue());
            this.logFilesWindow.CloseDialog();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() instanceof IntTextField) {
            IntTextField intTextField = (IntTextField)textEvent.getSource();
            if (intTextField.getValue() < 0) {
                int n = intTextField.getCaretPosition();
                intTextField.setText("0");
                intTextField.setCaretPosition(n);
            } else if (intTextField.getValue() > this.pmax) {
                int n = intTextField.getCaretPosition();
                intTextField.setText("" + this.pmax);
                intTextField.setCaretPosition(n);
            }
        }
    }
}

