/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import projections.analysis.IntervalUtils;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.BackGroundImagePanel;
import projections.gui.CallTableWindow;
import projections.gui.CommTimeWindow;
import projections.gui.CommWindow;
import projections.gui.FunctionTool;
import projections.gui.GraphWindow;
import projections.gui.HelpWindow;
import projections.gui.HistogramWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.LogFileViewerWindow;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.MultiRunWindow;
import projections.gui.PoseAnalysisWindow;
import projections.gui.ProfileWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.ScreenInfo;
import projections.gui.StlPanel;
import projections.gui.StlWindow;
import projections.gui.SwingWorker;
import projections.gui.TimeProfileWindow;
import projections.gui.TimelineWindow;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ActionListener,
ScalePanel.StatusDisplay {
    protected static final int NUM_WINDOWS = 14;
    protected static final int GRAPH_WIN = 0;
    protected static final int MULTI_WIN = 1;
    protected static final int PROFILE_WIN = 2;
    protected static final int TIME_PROF_WIN = 3;
    protected static final int COMM_WIN = 4;
    protected static final int COMM_TIME_WIN = 5;
    protected static final int CALL_TABLE_WIN = 6;
    protected static final int ANIMATION_WIN = 7;
    protected static final int LOGVIEW_WIN = 8;
    protected static final int HIST_WIN = 9;
    protected static final int TIMELINE_WIN = 10;
    protected static final int OVERVIEW_WIN = 11;
    protected static final int FUNCTION_WIN = 12;
    protected static final int POSE_WIN = 13;
    private static final int DEFAULT_NUM_RUNS = 1;
    public static final int NUM_RUN_MODES = 3;
    public static final int MODE_HIGH_MEM = 0;
    public static final int MODE_LOW_MEM = 1;
    public static final int MODE_MEDIUM = 2;
    public static double CUR_VERSION = 4.0;
    public static boolean IGNORE_IDLE = false;
    public static boolean BLUEGENE = false;
    public static int[] BLUEGENE_SIZE = new int[]{16, 8, 8};
    public static int CUR_MODE = 0;
    public static boolean PRINT_USAGE = false;
    public static PrintWriter dataDump = null;
    private MainWindow thisWindow = this;
    protected JFrame[][] childWindows;
    protected String[] toolDescriptions;
    private boolean[][] crossToolMask;
    private GraphWindow graphWindow;
    private TimelineWindow timelineWindow;
    private ProfileWindow profileWindow;
    private CommWindow commWindow;
    private CommTimeWindow commTimeWindow;
    private CallTableWindow callTableWindow;
    private HelpWindow helpWindow;
    private LogFileViewerWindow logFileViewerWindow;
    private HistogramWindow histogramWindow;
    private StlWindow stlWindow;
    private MultiRunWindow multiRunWindow;
    private AnimationWindow animationWindow;
    private TimeProfileWindow timeProfileWindow;
    private FunctionTool functionWindow;
    private PoseAnalysisWindow poseAnalysisWindow;
    private MainTitlePanel titlePanel;
    private BackGroundImagePanel background;
    private MainMenuManager menuManager;
    private MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    private SummaryDataSource sumDataSource;
    private SummaryXAxis sumXAxis;
    private SummaryYAxis sumYAxis;
    private GraphPanel graphPanel;
    private ScalePanel scalePanel;
    private StlPanel stl;
    private ScaleSlider hor;
    private ScaleSlider ver;
    private Label status;
    private ScalePanel.StatusDisplay sd;
    private Image bgimage;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;

    public MainWindow() {
        ScreenInfo.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setBackground(Color.lightGray);
        this.childWindows = new JFrame[1][14];
        this.initializeTools();
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void initializeTools() {
        this.toolDescriptions = new String[14];
        this.toolDescriptions[0] = "Graph";
        this.toolDescriptions[1] = "Multirun";
        this.toolDescriptions[2] = "Usage Profile";
        this.toolDescriptions[4] = "Communication";
        this.toolDescriptions[5] = "Communication vs Time";
        this.toolDescriptions[6] = "Call Table";
        this.toolDescriptions[8] = "View Logs";
        this.toolDescriptions[9] = "Histograms";
        this.toolDescriptions[7] = "Animation";
        this.toolDescriptions[10] = "Timeline";
        this.toolDescriptions[11] = "Overview";
        this.toolDescriptions[3] = "Time Profile Graph";
        this.toolDescriptions[12] = "AMPI Functions";
        this.crossToolMask = new boolean[14][14];
    }

    private void createLayout() {
        try {
            URL uRL = this.getClass().getResource("/projections/images/bgimage");
            this.bgimage = Toolkit.getDefaultToolkit().getImage(uRL);
            this.background = new BackGroundImagePanel(this.bgimage, true);
        }
        catch (Exception exception) {
            System.out.println("Error loading background image.  Continuing.");
            this.background = new BackGroundImagePanel(null);
        }
        this.setContentPane(this.background);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.background.setLayout(this.gbl);
        this.titlePanel = new MainTitlePanel(this);
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this, this.runStatusPanel);
        Util.gblAdd(this.background, this.titlePanel, this.gbc, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.background, this.runStatusPanel, this.gbc, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.background, this.summaryGraphPanel, this.gbc, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.background.setPreferredSize(new Dimension(ScreenInfo.screenWidth, ScreenInfo.screenHeight));
        this.pack();
    }

    public String getChildName(int n) {
        if (n == 0) {
            return "GraphWindow";
        }
        if (n == 1) {
            return "MultiRunWindow";
        }
        if (n == 2) {
            return "ProfileWindow";
        }
        if (n == 4) {
            return "CommWindow";
        }
        if (n == 5) {
            return "CommTimeWindow";
        }
        if (n == 6) {
            return "CallTableWindow";
        }
        if (n == 7) {
            return "AnimationWindow";
        }
        if (n == 8) {
            return "LogFileViewerWindow";
        }
        if (n == 9) {
            return "HistogramWindow";
        }
        if (n == 10) {
            return "TimelineWindow";
        }
        if (n == 11) {
            return "StlWindow";
        }
        if (n == 3) {
            return "TimeProfileWindow";
        }
        if (n == 12) {
            return "FunctionTool";
        }
        if (n == 13) {
            return "PoseAnalysisWindow";
        }
        return null;
    }

    public void menuToolSelected(String string) {
        if (string.equals("Graphs")) {
            this.showChildWindow("GraphWindow", 0);
        } else if (string.equals("Histograms")) {
            this.showChildWindow("HistogramWindow", 9);
        } else if (string.equals("Timelines")) {
            this.showChildWindow("TimelineWindow", 10);
        } else if (string.equals("Usage Profile")) {
            this.showChildWindow("ProfileWindow", 2);
        } else if (string.equals("Communication")) {
            this.showChildWindow("CommWindow", 4);
        } else if (string.equals("Communication vs Time")) {
            this.showChildWindow("CommTimeWindow", 5);
        } else if (string.equals("Call Table")) {
            this.showChildWindow("CallTableWindow", 6);
        } else if (string.equals("Animation")) {
            this.showChildWindow("AnimationWindow", 7);
        } else if (string.equals("View Log Files")) {
            this.showChildWindow("LogFileViewerWindow", 8);
        } else if (string.equals("Overview")) {
            this.showChildWindow("StlWindow", 11);
        } else if (string.equals("Time Profile Graph")) {
            this.showChildWindow("TimeProfileWindow", 3);
        } else if (string.equals("Multirun Analysis")) {
            this.showChildWindow("MultiRunWindow", 1);
        } else if (string.equals("Function Tool")) {
            this.showChildWindow("FunctionTool", 12);
        } else if (string.equals("POSE Analysis")) {
            this.showChildWindow("PoseAnalysisWindow", 13);
        }
    }

    public void changeBackground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Background Color", Analysis.background);
        if (color != null) {
            Analysis.background = color;
            this.repaintAllWindows();
        }
    }

    public void changeForeground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Foreground Color", Analysis.foreground);
        if (color != null) {
            Analysis.foreground = color;
            this.repaintAllWindows();
        }
    }

    public void setGrayscale() {
        Analysis.setGrayscale();
        this.repaintAllWindows();
    }

    public void setFullColor() {
        Analysis.setFullColor();
        this.repaintAllWindows();
    }

    private void repaintAllWindows() {
        for (int i = 0; i < 14; ++i) {
            if (this.childWindows[0][i] == null) continue;
            if (this.childWindows[0][i] instanceof GraphWindow) {
                ((GraphWindow)this.childWindows[0][i]).refreshDisplay();
                continue;
            }
            if (this.childWindows[0][i] instanceof TimelineWindow) {
                ((TimelineWindow)this.childWindows[0][i]).refreshDisplay();
                continue;
            }
            this.childWindows[0][i].repaint();
        }
        this.repaint();
    }

    public void showChildWindow(String string, int n) {
        try {
            if (this.childWindows[0][n] == null) {
                String string2 = this.getClass().getPackage().getName() + "." + string;
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(this.getClass(), Class.forName("java.lang.Integer"));
                this.childWindows[0][n] = (ProjectionsWindow)constructor.newInstance(this, new Integer(n));
            } else if (this.childWindows[0][n] instanceof ProjectionsWindow) {
                ((ProjectionsWindow)this.childWindows[0][n]).showDialog();
            } else {
                this.childWindows[0][n].show();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showOpenFileDialog() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new MainFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.setTitle("Projections -" + jFileChooser.getSelectedFile());
            this.openFile(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openFile(String string) {
        final String string2 = string;
        this.sumDataSource = null;
        this.sumXAxis = null;
        this.sumYAxis = null;
        this.graphPanel = null;
        this.hor = null;
        this.ver = null;
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Analysis.initAnalysis(string2, MainWindow.this.thisWindow);
                }
                catch (IOException iOException) {
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    stringIndexOutOfBoundsException.printStackTrace();
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                if (Analysis.hasSummaryData() || Analysis.hasLogData()) {
                    // empty if block
                }
                return null;
            }

            public void finished() {
                MainWindow.this.setTitle("Projections - " + string2);
                if (Analysis.hasSummaryData()) {
                    Analysis.loadSummaryData();
                    double[] dArray = Analysis.getSummaryAverageData();
                    long l = Analysis.getSummaryIntervalSize();
                    long l2 = (long)IntervalUtils.getBestIntervalSize(l, dArray.length);
                    if (l2 != l) {
                        IntervalUtils.utilToTime(dArray, (double)l);
                        double[] dArray2 = IntervalUtils.rebin(dArray, (double)l, l2);
                        IntervalUtils.timeToUtil(dArray2, (double)l2);
                        try {
                            dataDump = new PrintWriter(new FileWriter("SummaryDump.out"));
                            dataDump.println("--- Summary Graph ---");
                            for (int i = 0; i < dArray2.length; ++i) {
                                dataDump.println(dArray2[i]);
                            }
                            dataDump.flush();
                        }
                        catch (IOException iOException) {
                            System.err.println("Failed to handle dump file SummaryDump.out");
                            System.exit(-1);
                        }
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray2);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray2.length, l2);
                    } else {
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray.length, Analysis.getSummaryIntervalSize());
                    }
                    MainWindow.this.sumYAxis = new SummaryYAxis();
                    MainWindow.this.graphPanel = new GraphPanel(new Graph(MainWindow.this.sumDataSource, MainWindow.this.sumXAxis, MainWindow.this.sumYAxis));
                    MainWindow.this.summaryGraphPanel.add("data", MainWindow.this.graphPanel, "run data");
                }
                if (Analysis.hasLogData()) {
                    MainWindow.this.menuManager.fileOpened();
                } else if (Analysis.hasSummaryData()) {
                    MainWindow.this.menuManager.summaryOnly();
                }
                if (Analysis.hasPoseDopData()) {
                    MainWindow.this.menuManager.addPose();
                }
            }
        };
        swingWorker.start();
    }

    public void closeChildWindow(int n) {
        this.childWindows[0][n] = null;
    }

    public void shutdown() {
        System.exit(0);
    }

    public void closeCurrent() {
        this.closeAll();
    }

    public void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        this.setTitle("Projections");
    }

    public Color getGraphColor(int n) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(n);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public static void help() {
        System.out.println("-h:\t\tshow this page");
        System.out.println("-V:\t\tshow Projections version");
        System.out.println("-u <ver>:\tuse old version format");
        System.out.println("-bg:        use hop count info for BG machines");
        System.out.println("-bgsize <x> <y> <z>");
        System.out.println("-print_usage: details written to stdout when viewing usage profiles.");
        System.out.println("-memory_mode <high|medium|low> Projections favors appropriate log granularity if available.");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h")) {
                MainWindow.help();
                continue;
            }
            if (stringArray[i].equals("-V")) {
                System.out.println("Projections version: " + Analysis.getVersion());
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-u")) {
                double d;
                if (++i == stringArray.length) {
                    MainWindow.help();
                }
                if ((d = Double.parseDouble(stringArray[i])) > CUR_VERSION) {
                    System.out.println("Invalid (future) Projections version!");
                    System.exit(1);
                }
                CUR_VERSION = d;
                continue;
            }
            if (stringArray[i].equals("-idle")) {
                IGNORE_IDLE = true;
                continue;
            }
            if (stringArray[i].equals("-bg")) {
                BLUEGENE = true;
                continue;
            }
            if (stringArray[i].equals("-bgsize")) {
                MainWindow.BLUEGENE_SIZE[0] = Integer.parseInt(stringArray[++i]);
                MainWindow.BLUEGENE_SIZE[1] = Integer.parseInt(stringArray[++i]);
                MainWindow.BLUEGENE_SIZE[2] = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-print_usage")) {
                PRINT_USAGE = true;
                continue;
            }
            if (stringArray[i].equals("-memory_mode")) {
                if (++i == stringArray.length) {
                    MainWindow.help();
                }
                if (stringArray[i].equals("high")) {
                    CUR_MODE = 0;
                    continue;
                }
                if (stringArray[i].equals("medium")) {
                    CUR_MODE = 2;
                    continue;
                }
                if (stringArray[i].equals("low")) {
                    CUR_MODE = 1;
                    continue;
                }
                MainWindow.help();
                continue;
            }
            string = stringArray[i];
        }
        MainWindow mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        mainWindow.setVisible(true);
        if (string != null) {
            mainWindow.openFile(string);
        }
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }
}

