/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import projections.gui.PopUpAble;
import projections.gui.Util;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class PoseVTDopDisplayPanel
extends JPanel
implements PopUpAble {
    private GraphPanel graphPanel;
    private JPanel controlPanel;
    private Graph graph;

    public PoseVTDopDisplayPanel() {
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.setLayout(gridBagLayout);
        this.graph = new Graph();
        this.graphPanel = new GraphPanel(this.graph);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this, this.graphPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, this.controlPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0);
    }

    public void setGraphData(int[] nArray, long l, int n, int n2) {
        DataSource1D dataSource1D = new DataSource1D("Degree of Parallism (Model): " + (long)n * l + " to " + (long)n2 * l, nArray, this);
        dataSource1D.setColors(new Color[]{Color.cyan});
        XAxisFixed xAxisFixed = new XAxisFixed("Virtual Time: interval size = " + l, "");
        xAxisFixed.setLimits((double)n * (double)l, l);
        YAxisAuto yAxisAuto = new YAxisAuto("Number of Simultaneous Model Events", "", dataSource1D);
        this.graph.setData(dataSource1D, xAxisFixed, yAxisAuto);
    }

    public void refreshGraph() {
        this.graph.repaint();
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        return null;
    }
}

