/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import projections.gui.CallBack;
import projections.gui.GrepFileFilter;
import projections.gui.MultiRunWindow;
import projections.gui.ProjectionsFileMgr;
import projections.gui.Wait;

public class ProjectionsFileChooser {
    private Frame owner_ = null;
    private String title_ = null;
    private int type_ = 1;
    private JFileChooser fChoose_ = null;
    private JDialog dialog_ = null;
    private JList list_ = null;
    private int listSize_ = 0;
    private Wait wait_ = new Wait(true);
    private ProjectionsFileMgr fileMgr_ = null;
    public static final int MULTIPLE_FILES = 1;
    public static final int SINGLE_FILE = 2;
    public String[] userSelect_returnVal;
    public int[] userSelect_selected;
    public CallBack callback;

    public ProjectionsFileChooser(Frame frame) {
        this(frame, "ProjectionsFileChooser", 1);
    }

    public ProjectionsFileChooser(Frame frame, String string, int n) {
        if (n != 1 && n != 2) {
            System.err.println("ProjectionFileChooser must init with:\n  ProjectionFileChooser.MULTIPLE_FILES or\n  ProjectionFileChooser.SINGLE_FILE");
            System.exit(-1);
        }
        this.owner_ = frame;
        this.title_ = string;
        this.type_ = n;
        this.fChoose_ = this.initFileChooser(this.title_ + ": File(s) Open");
        this.dialog_ = this.initFileDialog(this.title_ + ": Choose Files");
    }

    public int getFiles(String[] stringArray) throws IOException {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        Vector vector = this.filterFiles(fileArray, this.fChoose_.getFileFilter());
        this.fileMgr_ = new ProjectionsFileMgr(vector);
        return this.fileMgr_.getNumFiles();
    }

    public int showDialog(CallBack callBack) {
        this.callback = callBack;
        return this.showDialog();
    }

    public int showDialog() {
        int n = this.fChoose_.showDialog(null, "Open/Search");
        try {
            if (n == 0) {
                Vector vector = this.filterFiles(this.fChoose_.getSelectedFiles(), this.fChoose_.getFileFilter());
                this.userSubselect(vector);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(-1);
        }
        return n;
    }

    public ProjectionsFileMgr getProjectionsFileMgr() {
        return this.fileMgr_;
    }

    private JFileChooser initFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser(string);
        String string2 = null;
        try {
            string2 = System.getProperty("PWD");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        JTextArea jTextArea = new JTextArea("INSTRUCTIONS:\n* Use the list to the left to choose\n  either directories (to search) or sts files.\n* If a single sts file is chosen, the\n  run will be analyzed.\n* If directories are chosen, the chosen\n  dirs and all subdirs will be searched\n  for any sts files, which can be further\n  subselected.\n* So, if several multi-run simulations are\n  stored in several directories, just choose\n  the parent directory and all the\n  simulations will be found.\n* NOTE: Use shift/control keys to select!");
        jTextArea.setEditable(false);
        jFileChooser.setAccessory(jTextArea);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.addChoosableFileFilter(new GrepFileFilter("sts", "STS Files (*sts*)"));
        return jFileChooser;
    }

    private JDialog initFileDialog(String string) {
        JDialog jDialog = new JDialog(this.owner_, false);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjectionsFileChooser.this.dialog_.hide();
            }
        });
        jDialog.setTitle(string);
        jDialog.setSize(600, 480);
        JTextArea jTextArea = new JTextArea("All of the files below have been found\nto match the file open filter in all of\nthe subdirectories searched.  Highlighted\nfiles will be opened by Projections, so\nfurther subselect only the files that are\ndesired.  NOTE: Can use control/shift keys\nto subselect.\n");
        jTextArea.setEditable(false);
        jDialog.getContentPane().add((Component)jTextArea, "North");
        JButton jButton = new JButton("Select All");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = new int[ProjectionsFileChooser.this.listSize_];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
                ProjectionsFileChooser.this.list_.setSelectedIndices(nArray);
            }
        });
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectionsFileChooser.this.userSelect_selected = ProjectionsFileChooser.this.list_.getSelectedIndices();
                ProjectionsFileChooser.this.userSelect_returnVal = new String[ProjectionsFileChooser.this.userSelect_selected.length];
                for (int i = 0; i < ProjectionsFileChooser.this.userSelect_selected.length; ++i) {
                    ProjectionsFileChooser.this.userSelect_returnVal[i] = (String)ProjectionsFileChooser.this.list_.getModel().getElementAt(ProjectionsFileChooser.this.userSelect_selected[i]);
                }
                try {
                    ProjectionsFileChooser.this.fileMgr_ = new ProjectionsFileMgr(ProjectionsFileChooser.this.userSelect_returnVal);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ProjectionsFileChooser.this.dialog_.hide();
                ((MultiRunWindow)ProjectionsFileChooser.this.owner_).dialogCallback();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jDialog.getContentPane().add((Component)jPanel, "South");
        return jDialog;
    }

    private Vector filterFiles(File[] fileArray, FileFilter fileFilter) {
        Vector vector = new Vector();
        Vector<File> vector2 = new Vector<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            vector2.addElement(fileArray[i]);
        }
        this.recurseFilterFiles(vector2, vector, fileFilter);
        return vector;
    }

    private void recurseFilterFiles(Vector vector, Vector vector2, FileFilter fileFilter) {
        for (int i = 0; i < vector.size(); ++i) {
            File file = (File)vector.elementAt(i);
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                Vector<File> vector3 = new Vector<File>();
                for (int j = 0; j < stringArray.length; ++j) {
                    vector3.addElement(new File(file, stringArray[j]));
                }
                this.recurseFilterFiles(vector3, vector2, fileFilter);
                continue;
            }
            if (!fileFilter.accept(file)) continue;
            vector2.addElement(file);
        }
    }

    private String[] userSubselect(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            File file = (File)vector.elementAt(i);
            try {
                stringArray[i] = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                System.out.println("exception in USersubselect");
                stringArray[i] = "IOException index " + i;
            }
            nArray[i] = i;
        }
        this.list_ = new JList<String>(stringArray);
        this.listSize_ = stringArray.length;
        this.list_.setSelectedIndices(nArray);
        this.dialog_.getContentPane().add((Component)new JScrollPane(this.list_), "Center");
        this.dialog_.show();
        return this.userSelect_returnVal;
    }
}

