/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import projections.analysis.TimelineMessage;
import projections.gui.Analysis;
import projections.gui.JLongTextField;
import projections.gui.LabelPanel;
import projections.gui.TimelineObject;
import projections.gui.Util;

public class TimelineMessagePanel
extends JPanel {
    private JPanel headerPanel;
    private JTable dataTable;
    private JLabel epLabel;
    private JPanel beginTimeField;
    private JPanel endTimeField;
    private JPanel numMsgsField;
    private JPanel createdPEField;
    private JPanel executedPEField;
    private TimelineObject obj;
    private TimelineMessage[] messages;
    private Object[][] tableData;
    private Object[] columnNames;
    private static final int NUM_FIELDS = 6;

    TimelineMessagePanel(TimelineObject timelineObject) {
        this.obj = timelineObject;
        this.messages = timelineObject.getMessages();
        this.tableData = new Object[timelineObject.getNumMsgs()][6];
        this.columnNames = new Object[6];
        this.setData();
        this.createLayout();
    }

    private void setData() {
        this.columnNames[0] = "Message #";
        this.columnNames[1] = "Message Size";
        this.columnNames[2] = "Time Sent";
        this.columnNames[3] = "Time since last Send";
        this.columnNames[4] = "Target EP";
        this.columnNames[5] = "Destination PE(s)";
        for (int i = 0; i < this.tableData.length; ++i) {
            this.tableData[i][0] = new Integer(i);
            this.tableData[i][1] = new Integer(this.messages[i].MsgLen);
            this.tableData[i][2] = new Long(this.messages[i].Time);
            this.tableData[i][3] = new Long(i > 0 ? this.messages[i].Time - this.messages[i - 1].Time : 0L);
            this.tableData[i][4] = Analysis.getEntryName(this.messages[i].Entry);
            if (this.messages[i].destPEs != null) {
                this.tableData[i][5] = "";
                for (int j = 0; j < this.messages[i].destPEs.length - 1; ++j) {
                    this.tableData[i][5] = (String)this.tableData[i][5] + this.messages[i].destPEs[j] + ", ";
                }
                this.tableData[i][5] = (String)this.tableData[i][5] + this.messages[i].destPEs[this.messages[i].destPEs.length - 1] + "";
                continue;
            }
            this.tableData[i][5] = "unknown";
        }
    }

    private void createLayout() {
        this.epLabel = new JLabel(Analysis.getEntryChareName(this.obj.getEntry()) + " -- " + Analysis.getEntryName(this.obj.getEntry()), 0);
        this.beginTimeField = new LabelPanel("BEGIN TIME:", new JLongTextField(this.obj.getBeginTime(), 10));
        this.endTimeField = new LabelPanel("END TIME:", new JLongTextField(this.obj.getEndTime(), 10));
        this.numMsgsField = new LabelPanel("MSGS:", new JTextField("" + this.obj.getNumMsgs(), 10));
        this.createdPEField = new LabelPanel("CREATED BY:", new JTextField("Processor " + this.obj.getPCreation()));
        this.executedPEField = new LabelPanel("EXECUTED ON:", new JTextField("Processor " + this.obj.getPCurrent()));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.headerPanel, this.epLabel, gridBagConstraints, 0, 0, 3, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.beginTimeField, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.endTimeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.numMsgsField, gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.createdPEField, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.executedPEField, gridBagConstraints, 1, 2, 1, 1, 1, 1);
        this.dataTable = new JTable(this.tableData, this.columnNames);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        this.setLayout(gridBagLayout);
        Util.gblAdd(this, this.headerPanel, gridBagConstraints, 0, 0, 1, 1, 1, 0);
        gridBagConstraints.fill = 1;
        Util.gblAdd(this, jPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
    }
}

