/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import projections.gui.Util;

public class LegendCanvas
extends Canvas
implements MouseListener,
ActionListener {
    private String[] labels = null;
    private Color[] colorMap = null;
    private int[] sortMap = null;
    private int[] reverseMap = null;
    private boolean[] selection;
    private boolean[] showFilter = null;
    private FontMetrics fm;
    private int textheight;
    private int maxTextWidth;
    private Rectangle boundingBox;
    private ScrollPane sp;
    private int posx;
    private int posy;

    public LegendCanvas() {
        this.setSize(this.getPreferredSize());
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        if (this.labels == null) {
            return;
        }
        this.fm = graphics.getFontMetrics(graphics.getFont());
        this.textheight = this.fm.getHeight();
        this.maxTextWidth = 10;
        this.posx = 10;
        this.posy = 10;
        int n = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            if (!this.showFilter[this.sortMap[i]]) continue;
            this.reverseMap[n] = this.sortMap[i];
            ++n;
            if (this.selection[this.sortMap[i]]) {
                this.paintSelected(graphics, this.labels[this.sortMap[i]], this.colorMap[this.sortMap[i]]);
                continue;
            }
            this.paintLabel(graphics, this.labels[this.sortMap[i]], this.colorMap[this.sortMap[i]]);
        }
        this.setSize(new Dimension(this.maxTextWidth, this.posy));
    }

    public void setColors(Color[] colorArray) {
        this.colorMap = colorArray;
        this.repaint();
    }

    public void setFilter(boolean[] blArray) {
        this.showFilter = blArray;
        if (this.showFilter == null) {
            this.defaultShowFilter(this.labels.length);
        }
        this.repaint();
    }

    public void setSort(int[] nArray) {
        this.sortMap = nArray;
        if (this.sortMap == null) {
            this.defaultSortMap(this.labels.length);
        }
        this.repaint();
    }

    public void setData(String[] stringArray, Color[] colorArray, boolean[] blArray, int[] nArray) {
        this.labels = stringArray;
        this.selection = new boolean[this.labels.length];
        this.reverseMap = new int[this.labels.length];
        this.colorMap = colorArray;
        if (blArray == null) {
            this.defaultShowFilter(this.labels.length);
        } else {
            this.showFilter = blArray;
        }
        if (nArray == null) {
            this.defaultSortMap(this.labels.length);
        } else {
            this.sortMap = nArray;
        }
        this.repaint();
    }

    public boolean[] getSelection() {
        return Util.andFilters(this.selection, this.showFilter);
    }

    public int[] getSort() {
        return this.sortMap;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    private void paintLabel(Graphics graphics, String string, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(this.posx, this.posy, this.textheight * 2, this.textheight);
        graphics.drawString(string, this.posx + this.textheight * 3, this.posy + this.textheight);
        if (this.posx + this.textheight * 3 + this.fm.stringWidth(string) > this.maxTextWidth) {
            this.maxTextWidth = this.posx + this.textheight * 3 + this.fm.stringWidth(string);
        }
        graphics.setColor(this.getBackground());
        graphics.drawRect(this.posx + 1, this.posy + 1, (this.textheight - 1) * 2 - 1, this.textheight - 2 - 1);
        this.posy += this.textheight * 3 / 2;
        graphics.setColor(color2);
    }

    private void paintSelected(Graphics graphics, String string, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(color.brighter());
        graphics.drawRect(this.posx, this.posy, this.textheight * 2, this.textheight);
        graphics.drawLine(this.posx, this.posy, this.posx + this.textheight * 2, this.posy + this.textheight);
        graphics.drawLine(this.posx + this.textheight * 2, this.posy, this.posx, this.posy + this.textheight);
        graphics.drawString(string, this.posx + this.textheight * 3, this.posy + this.textheight);
        if (this.posx + this.textheight * 3 + this.fm.stringWidth(string) > this.maxTextWidth) {
            this.maxTextWidth = this.posx + this.textheight * 3 + this.fm.stringWidth(string);
        }
        this.posy += this.textheight * 3 / 2;
        graphics.setColor(color2);
    }

    private int yPixelToLineNum(int n) {
        int n2 = 10;
        int n3 = (n - n2) / (this.textheight * 3 / 2);
        if (n - n2 > n3 * (this.textheight * 3 / 2) + this.textheight) {
            return -1;
        }
        return n3;
    }

    private void defaultShowFilter(int n) {
        this.showFilter = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.showFilter[i] = true;
        }
    }

    private void defaultShowFilter() {
        for (int i = 0; i < this.showFilter.length; ++i) {
            this.showFilter[i] = true;
        }
    }

    private void defaultSortMap(int n) {
        this.sortMap = new int[n];
        for (int i = 0; i < n; ++i) {
            this.sortMap[i] = i;
        }
    }

    private void defaultSortMap() {
        for (int i = 0; i < this.sortMap.length; ++i) {
            this.sortMap[i] = i;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("select")) {
            for (int i = 0; i < this.selection.length; ++i) {
                this.selection[i] = true;
            }
            this.repaint();
        } else if (string.equals("unselect")) {
            for (int i = 0; i < this.selection.length; ++i) {
                this.selection[i] = false;
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.yPixelToLineNum(mouseEvent.getY());
        if (n != -1) {
            this.selection[this.reverseMap[n]] = !this.selection[this.reverseMap[n]];
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

