/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.File;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericSummaryReader;
import projections.analysis.StsReader;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.MiscUtil;

public class MultiRunData {
    private StsReader[] stsReaders;
    private int[] sortedStsMap;
    private double[][][] dataTable;
    public static final int NUM_TYPES = 4;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_TIMES_CALLED = 1;
    public static final int TYPE_NUM_MSG_SENT = 2;
    public static final int TYPE_SIZE_MSG = 3;
    private static final String[] typeNames = new String[]{"Execution Time", "Num Msgs Received", "Num Msgs Sent", "Msg Size"};
    private double[] runWallTimes;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;

    public MultiRunData(String[] stringArray) throws IOException {
        try {
            int n;
            this.numRuns = stringArray.length;
            if (this.numRuns == 0) {
                throw new IOException("MultiRunData cannot be initialized with zero runs!");
            }
            this.stsReaders = new StsReader[this.numRuns];
            int[] nArray = new int[this.numRuns];
            for (int i = 0; i < this.numRuns; ++i) {
                this.stsReaders[i] = new StsReader(stringArray[i], true);
                nArray[i] = this.stsReaders[i].getProcessorCount();
            }
            this.sortedStsMap = MiscUtil.sortAndMap(nArray);
            MiscUtil.applyMap(this.stsReaders, this.sortedStsMap);
            OrderedIntList[][] orderedIntListArrayArray = new OrderedIntList[this.numRuns][];
            boolean bl = true;
            boolean bl2 = true;
            for (n = 0; n < this.numRuns; ++n) {
                orderedIntListArrayArray[n] = MultiRunData.detectFiles(this.stsReaders[n]);
                bl = bl && !orderedIntListArrayArray[n][1].isEmpty();
                bl2 = bl2 && !orderedIntListArrayArray[n][0].isEmpty();
            }
            this.numEPs = this.stsReaders[0].getEntryCount();
            for (n = 1; n < this.numRuns; ++n) {
                if (this.numEPs == this.stsReaders[n].getEntryCount()) continue;
                System.err.println("Error! Incompatible data sets!");
                System.exit(-1);
            }
            this.epNames = new String[this.numEPs];
            for (n = 0; n < this.numEPs; ++n) {
                this.epNames[n] = this.stsReaders[0].getEntryNames()[n][0];
            }
            this.runNames = new String[this.numRuns];
            for (n = 0; n < this.numRuns; ++n) {
                this.runNames[n] = "(" + nArray[n] + ")" + "[" + this.stsReaders[n].getMachineName() + "]";
            }
            this.dataTable = new double[4][this.numRuns][this.numEPs];
            this.runWallTimes = new double[this.numRuns];
            if (bl) {
                for (int i = 0; i < this.numRuns; ++i) {
                    int n2 = nArray[i];
                    OrderedIntList orderedIntList = orderedIntListArrayArray[i][1];
                    orderedIntList.reset();
                    double d = (double)n2 / ((double)orderedIntList.size() * 1.0);
                    ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading summary Data for run " + i + " of " + this.numRuns, "", 0, orderedIntList.size());
                    progressMonitor.setMillisToDecideToPopup(100);
                    progressMonitor.setMillisToPopup(1000);
                    int n3 = 0;
                    while (orderedIntList.hasMoreElements()) {
                        int n4 = orderedIntList.nextElement();
                        if (!progressMonitor.isCanceled()) {
                            progressMonitor.setNote("[PE: " + n4 + " ] Reading Processor data.");
                            progressMonitor.setProgress(n3);
                        } else {
                            System.err.println("Fatal error! Multirun  cannot function without  a complete read!");
                            System.exit(-1);
                        }
                        GenericSummaryReader genericSummaryReader = new GenericSummaryReader(Analysis.getSumName(n4), Analysis.getVersion());
                        for (int j = 0; j < this.numEPs; ++j) {
                            double[] dArray = this.dataTable[0][i];
                            int n5 = j;
                            dArray[n5] = dArray[n5] + (double)genericSummaryReader.epData[j][0] * d;
                            double[] dArray2 = this.dataTable[1][i];
                            int n6 = j;
                            dArray2[n6] = dArray2[n6] + (double)genericSummaryReader.epData[j][1] * d;
                        }
                        int n7 = i;
                        this.runWallTimes[n7] = this.runWallTimes[n7] + (double)genericSummaryReader.numIntervals * genericSummaryReader.intervalSize * 1000000.0 * d;
                        ++n3;
                    }
                    progressMonitor.close();
                }
            } else if (!bl2) {
                System.err.println("No data available! Catastrophic error!");
                System.exit(-1);
            }
        }
        catch (IOException iOException) {
            throw new IOException("MultiRun data read failed: 13" + iOException);
        }
    }

    public int getNumEPs() {
        return this.numEPs;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public double[][] getData(int n) {
        return this.dataTable[n];
    }

    public double[][][] getData() {
        return this.dataTable;
    }

    public double[] getEPData(int n, int n2) {
        return this.dataTable[n][n2];
    }

    public double[] getRunData(int n, int n2) {
        double[] dArray = new double[this.numRuns];
        for (int i = 0; i < this.numRuns; ++i) {
            dArray[i] = this.dataTable[n][i][n2];
        }
        return dArray;
    }

    public double[] getRunWallTimes() {
        return this.runWallTimes;
    }

    public String[] getEPNames() {
        return this.epNames;
    }

    public String[] getRunNames() {
        return this.runNames;
    }

    public static String getTypeName(int n) {
        return typeNames[n];
    }

    private static OrderedIntList[] detectFiles(StsReader stsReader) {
        int n;
        OrderedIntList[] orderedIntListArray = new OrderedIntList[5];
        for (n = 0; n < 5; ++n) {
            orderedIntListArray[n] = new OrderedIntList();
        }
        for (n = 0; n < stsReader.getProcessorCount(); ++n) {
            if (new File(Analysis.getSumName(n)).isFile()) {
                orderedIntListArray[1].insert(n);
            }
            if (new File(Analysis.getSumDetailName(n)).isFile()) {
                orderedIntListArray[3].insert(n);
            }
            if (!new File(Analysis.getLogName(n)).isFile()) continue;
            orderedIntListArray[0].insert(n);
        }
        return orderedIntListArray;
    }
}

