/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class PrintUtils
implements Printable {
    private Component itemToBePrinted = null;

    public PrintUtils(Component component) {
        this.itemToBePrinted = component;
    }

    public void setComponent(Component component) {
        this.itemToBePrinted = component;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        this.printComponent(graphics, pageFormat);
        return 0;
    }

    private void printComponent(Graphics graphics, PageFormat pageFormat) {
        Dimension dimension = this.itemToBePrinted.getSize();
        System.out.println("Component dimensions = " + dimension.width + "x" + dimension.height);
        double d = pageFormat.getImageableHeight();
        double d2 = pageFormat.getImageableWidth();
        System.out.println("Paper dimensions = " + d2 + "x" + d);
        double d3 = Math.min(d2 / (double)dimension.width, d / (double)dimension.height);
        ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        ((Graphics2D)graphics).scale(d3, d3);
        this.itemToBePrinted.printAll(graphics);
    }
}

