/*****************************************************************************
 * $Source: /cvsroot/charm/src/xlat-i/xi-util.h,v $
 * $Author: gzheng $
 * $Date: 2005/02/03 08:33:53 $
 * $Revision: 1.18 $
 *****************************************************************************/

#ifndef _XI_UTIL_H
#define _XI_UTIL_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "conv-config.h"

#if CMK_STL_USE_DOT_H /* Pre-standard C++ */
#  include <iostream.h>
#else /* ISO C++ */
#  include <iostream>
   using namespace std;
#endif


#define SZ 1024

class XStr {
  private:
    char *s;
    unsigned int len, blklen;
    void initTo(const char *_s);
    void operator=(const XStr &str); //<- don't use this
  public:
    // MAB: following append methods were earlier private. However,
    // in order to minimize changes to sdag translator, they have been made
    // public. Once the sdag translator is fully embedded in charmxi,
    // they will be made private again.
    void append(const char *_s);
    void append(char c);
    // MAB: the print method is needed for debugging sdag translator.
    // this too will go away later.
    void print(int indent) { 
      for (int i=0; i<indent; i++) cout << "  ";
      cout << get_string();
    }
    // MAB: this method appends character c to every line
    // basically substitutes every \n with a "c\n"
    void line_append(const char c);
  public:
    XStr();
    XStr(const char *_s);
    XStr(const XStr &_s); //Copy constructor
    ~XStr() { delete[] s; }
    char *get_string(void) { return s; }
    const char *get_string_const(void) const { return s; }
    // this is to allow XStr to be substituted for CString in
    // structured dagger translator without a lot of changes
    char *charstar(void) { return get_string(); }
    //This operator allows us to use XStr's interchangably with char *'s:
    operator char *() {return get_string();}
    //Comparison operators
    int operator==(XStr &s2) const {return 0==strcmp(s,s2.s);}
    int operator!=(XStr &s2) const {return 0!=strcmp(s,s2.s);}
    int operator==(const char *s2) const {return 0==strcmp(s,s2);}
    int operator!=(const char *s2) const {return 0!=strcmp(s,s2);}
    //Addition operator
    XStr operator+ (const XStr &s2) const {XStr ret(*this);ret.append(s2.s); return ret;}
    //Insertion operators
    XStr& operator << (const char *_s) { append(_s); return *this;}
//      XStr& operator << (const string & _s) { append(_s.c_str()); return *this;}
    XStr& operator << (char c) { append(c); return *this;}
    XStr& operator << (int i) ;
    XStr& operator << (const XStr& x) { append(x.get_string_const()); return *this; }
    void spew(const char*b, const char *a1 = 0, const char *a2 = 0, 
              const char *a3 = 0, const char *a4 = 0, const char *a5 = 0);
};

#define endx "\n"

class Printable {
  public:
    virtual void print(XStr& str) = 0;
    //This lets us cast printables to XStr
    operator XStr () {XStr ret;print(ret);return ret;}
    //These let us stream Printables to XStr.
    friend XStr & operator << (XStr &str,Printable &p) {p.print(str);return str;}
    friend XStr & operator << (XStr &str,Printable *p) {p->print(str);return str;}
};

#endif
