#ifndef _DECL_HbmLB_H_
#define _DECL_HbmLB_H_
#include "charm++.h"
#include "LBDatabase.decl.h"

#include "BaseLB.decl.h"

#include "NeighborLBMsg.h"

#include "CentralLBMsg.h"

#include "HybridLBMsg.h"


/* DECLS: group HbmLB: BaseLB{
HbmLB(CkMigrateMessage* impl_msg);
void HbmLB(const CkLBOptions &impl_noname_0);
void ProcessAtSync(void);
void ReceiveStats(double t, int frompe, int level);
void ResumeClients(CkReductionMsg* impl_msg);
void ResumeClients(int balancing);
void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2);
void ReceiveMigrationDelta(double delta, int lblevel, int level);
void Loadbalancing(int level);
void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4);
void ReceiveResumeClients(int fromlevel, int balancing);
void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n);
void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9);
};
 */
 class HbmLB;
 class CkIndex_HbmLB;
 class CProxy_HbmLB;
 class CProxyElement_HbmLB;
/* --------------- index object ------------------ */
class CkIndex_HbmLB:public CProxyElement_BaseLB{
  public:
    typedef HbmLB local_t;
    typedef CkIndex_HbmLB index_t;
    typedef CProxy_HbmLB proxy_t;
    typedef CProxyElement_HbmLB element_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: HbmLB(CkMigrateMessage* impl_msg);
 */
    static int __idx_HbmLB_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_HbmLB_CkMigrateMessage; }
    static void _call_HbmLB_CkMigrateMessage(void* impl_msg,HbmLB* impl_obj);

/* DECLS: void HbmLB(const CkLBOptions &impl_noname_0);
 */
    static int __idx_HbmLB_marshall1;
    static int ckNew(const CkLBOptions &impl_noname_0) { return __idx_HbmLB_marshall1; }
    static void _call_HbmLB_marshall1(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_HbmLB_marshall1(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_HbmLB_marshall1(PUP::er &p,void *msg);

/* DECLS: void ProcessAtSync(void);
 */
    static int __idx_ProcessAtSync_void;
    static int ProcessAtSync(void) { return __idx_ProcessAtSync_void; }
    static void _call_ProcessAtSync_void(void* impl_msg,HbmLB* impl_obj);

/* DECLS: void ReceiveStats(double t, int frompe, int level);
 */
    static int __idx_ReceiveStats_marshall3;
    static int ReceiveStats(double t, int frompe, int level) { return __idx_ReceiveStats_marshall3; }
    static void _call_ReceiveStats_marshall3(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ReceiveStats_marshall3(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ReceiveStats_marshall3(PUP::er &p,void *msg);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    static int __idx_ResumeClients_CkReductionMsg;
    static int ResumeClients(CkReductionMsg* impl_msg) { return __idx_ResumeClients_CkReductionMsg; }
    static void _call_ResumeClients_CkReductionMsg(void* impl_msg,HbmLB* impl_obj);

/* DECLS: void ResumeClients(int balancing);
 */
    static int __idx_ResumeClients_marshall5;
    static int ResumeClients(int balancing) { return __idx_ResumeClients_marshall5; }
    static void _call_ResumeClients_marshall5(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ResumeClients_marshall5(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ResumeClients_marshall5(PUP::er &p,void *msg);

/* DECLS: void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2);
 */
    static int __idx_ReceiveMigrationCount_marshall6;
    static int ReceiveMigrationCount(int impl_noname_1, int impl_noname_2) { return __idx_ReceiveMigrationCount_marshall6; }
    static void _call_ReceiveMigrationCount_marshall6(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ReceiveMigrationCount_marshall6(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ReceiveMigrationCount_marshall6(PUP::er &p,void *msg);

/* DECLS: void ReceiveMigrationDelta(double delta, int lblevel, int level);
 */
    static int __idx_ReceiveMigrationDelta_marshall7;
    static int ReceiveMigrationDelta(double delta, int lblevel, int level) { return __idx_ReceiveMigrationDelta_marshall7; }
    static void _call_ReceiveMigrationDelta_marshall7(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ReceiveMigrationDelta_marshall7(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ReceiveMigrationDelta_marshall7(PUP::er &p,void *msg);

/* DECLS: void Loadbalancing(int level);
 */
    static int __idx_Loadbalancing_marshall8;
    static int Loadbalancing(int level) { return __idx_Loadbalancing_marshall8; }
    static void _call_Loadbalancing_marshall8(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_Loadbalancing_marshall8(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_Loadbalancing_marshall8(PUP::er &p,void *msg);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4);
 */
    static int __idx_NotifyObjectMigrationDone_marshall9;
    static int NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4) { return __idx_NotifyObjectMigrationDone_marshall9; }
    static void _call_NotifyObjectMigrationDone_marshall9(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_NotifyObjectMigrationDone_marshall9(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_NotifyObjectMigrationDone_marshall9(PUP::er &p,void *msg);

/* DECLS: void ReceiveResumeClients(int fromlevel, int balancing);
 */
    static int __idx_ReceiveResumeClients_marshall10;
    static int ReceiveResumeClients(int fromlevel, int balancing) { return __idx_ReceiveResumeClients_marshall10; }
    static void _call_ReceiveResumeClients_marshall10(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ReceiveResumeClients_marshall10(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ReceiveResumeClients_marshall10(PUP::er &p,void *msg);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n);
 */
    static int __idx_ObjMigrated_marshall11;
    static int ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n) { return __idx_ObjMigrated_marshall11; }
    static void _call_ObjMigrated_marshall11(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_ObjMigrated_marshall11(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_ObjMigrated_marshall11(PUP::er &p,void *msg);

/* DECLS: void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9);
 */
    static int __idx_reportLBQulity_marshall12;
    static int reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9) { return __idx_reportLBQulity_marshall12; }
    static void _call_reportLBQulity_marshall12(void* impl_msg,HbmLB* impl_obj);
    static int _callmarshall_reportLBQulity_marshall12(char* impl_buf,HbmLB* impl_obj);
    static void _marshallmessagepup_reportLBQulity_marshall12(PUP::er &p,void *msg);
};
/* --------------- element proxy ------------------ */
class CProxyElement_HbmLB: public CProxyElement_BaseLB{
  public:
    typedef HbmLB local_t;
    typedef CkIndex_HbmLB index_t;
    typedef CProxy_HbmLB proxy_t;
    typedef CProxyElement_HbmLB element_t;

    CProxyElement_HbmLB(void) {}
    CProxyElement_HbmLB(const IrrGroup *g) : CProxyElement_BaseLB(g){  }
    CProxyElement_HbmLB(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_BaseLB(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_HbmLB(CkGroupID _gid,int _onPE) : CProxyElement_BaseLB(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_BaseLB::ckSetGroupID(g);
    }
    HbmLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HbmLB* ckLocalBranch(CkGroupID gID) {
      return (HbmLB*)CkLocalBranch(gID);
    }
/* DECLS: HbmLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HbmLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveStats(double t, int frompe, int level);
 */
    void ReceiveStats(double t, int frompe, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double t, int frompe, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|t;
    implP|frompe;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|t;
    implP|frompe;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2);
 */
    void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigrationDelta(double delta, int lblevel, int level);
 */
    void ReceiveMigrationDelta(double delta, int lblevel, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double delta, int lblevel, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|delta;
    implP|lblevel;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|delta;
    implP|lblevel;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4);
 */
    void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_3, int impl_noname_4
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_3;
    implP|impl_noname_4;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_3;
    implP|impl_noname_4;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveResumeClients(int fromlevel, int balancing);
 */
    void ReceiveResumeClients(int fromlevel, int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int fromlevel, int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|fromlevel;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|fromlevel;
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9);
 */
    void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }
};
PUPmarshall(CProxyElement_HbmLB);
/* ---------------- collective proxy -------------- */
class CProxy_HbmLB: public CProxy_BaseLB{
  public:
    typedef HbmLB local_t;
    typedef CkIndex_HbmLB index_t;
    typedef CProxy_HbmLB proxy_t;
    typedef CProxyElement_HbmLB element_t;

    CProxy_HbmLB(void) {}
    CProxy_HbmLB(const IrrGroup *g) : CProxy_BaseLB(g){  }
    CProxy_HbmLB(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_BaseLB(_gid,CK_DELCTOR_ARGS){  }
    CProxy_HbmLB(CkGroupID _gid) : CProxy_BaseLB(_gid){  }
    CProxyElement_HbmLB operator[](int onPE) const
      {return CProxyElement_HbmLB(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_BaseLB::ckSetGroupID(g);
    }
    HbmLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HbmLB* ckLocalBranch(CkGroupID gID) {
      return (HbmLB*)CkLocalBranch(gID);
    }
/* DECLS: HbmLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HbmLB(const CkLBOptions &impl_noname_0);
 */
    static CkGroupID ckNew(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_HbmLB(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID(),0);
    }
    void ProcessAtSync(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ProcessAtSync_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveStats(double t, int frompe, int level);
 */
    void ReceiveStats(double t, int frompe, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double t, int frompe, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|t;
    implP|frompe;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|t;
    implP|frompe;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveStats(double t, int frompe, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: double t, int frompe, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|t;
    implP|frompe;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|t;
    implP|frompe;
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ReceiveStats_marshall3, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID(),0);
    }
    void ResumeClients(CkReductionMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ResumeClients_CkReductionMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID(),0);
    }
    void ResumeClients(int balancing, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ResumeClients_marshall5, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2);
 */
    void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveMigrationCount(int impl_noname_1, int impl_noname_2, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ReceiveMigrationCount_marshall6, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigrationDelta(double delta, int lblevel, int level);
 */
    void ReceiveMigrationDelta(double delta, int lblevel, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double delta, int lblevel, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|delta;
    implP|lblevel;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|delta;
    implP|lblevel;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveMigrationDelta(double delta, int lblevel, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: double delta, int lblevel, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|delta;
    implP|lblevel;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|delta;
    implP|lblevel;
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ReceiveMigrationDelta_marshall7, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, ckGetGroupID(),0);
    }
    void Loadbalancing(int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_Loadbalancing_marshall8, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4);
 */
    void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_3, int impl_noname_4
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_3;
    implP|impl_noname_4;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_3;
    implP|impl_noname_4;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, ckGetGroupID(),0);
    }
    void NotifyObjectMigrationDone(int impl_noname_3, int impl_noname_4, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int impl_noname_3, int impl_noname_4
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_3;
    implP|impl_noname_4;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_3;
    implP|impl_noname_4;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_NotifyObjectMigrationDone_marshall9, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveResumeClients(int fromlevel, int balancing);
 */
    void ReceiveResumeClients(int fromlevel, int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int fromlevel, int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|fromlevel;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|fromlevel;
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveResumeClients(int fromlevel, int balancing, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int fromlevel, int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|fromlevel;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|fromlevel;
    implP|balancing;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ReceiveResumeClients_marshall10, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, ckGetGroupID(),0);
    }
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_ObjMigrated_marshall11, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9);
 */
    void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, ckGetGroupID(),0);
    }
    void reportLBQulity(double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: double impl_noname_5, double impl_noname_6, double impl_noname_7, int impl_noname_8, double impl_noname_9
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_5;
    implP|impl_noname_6;
    implP|impl_noname_7;
    implP|impl_noname_8;
    implP|impl_noname_9;
  }
      CkSendMsgBranchMulti(CkIndex_HbmLB::__idx_reportLBQulity_marshall12, impl_msg, npes, pes, ckGetGroupID(),0);
    }
};
PUPmarshall(CProxy_HbmLB);
typedef CBaseT<BaseLB,CProxy_HbmLB>  CBase_HbmLB;

extern void _registerHbmLB(void);
#endif
