
/* DEFS: message LBMigrateMsg{
MigrateInfo moves[];
char avail_vector[];
double expectedLoad[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_LBMigrateMsg::operator new(size_t s){
  return LBMigrateMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_LBMigrateMsg::operator new(size_t s, int* sz){
  return LBMigrateMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_LBMigrateMsg::operator new(size_t s, int* sz,const int pb){
  return LBMigrateMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_LBMigrateMsg::operator new(size_t s, int sz0, int sz1, int sz2) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return LBMigrateMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_LBMigrateMsg::operator new(size_t s, int sz0, int sz1, int sz2, const int p) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return LBMigrateMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_LBMigrateMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[4];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(MigrateInfo)*sizes[0]);
  if(sizes==0)
    offsets[2] = offsets[0];
  else
    offsets[2] = offsets[1] + ALIGN8(sizeof(char)*sizes[1]);
  if(sizes==0)
    offsets[3] = offsets[0];
  else
    offsets[3] = offsets[2] + ALIGN8(sizeof(double)*sizes[2]);
  LBMigrateMsg *newmsg = (LBMigrateMsg *) CkAllocMsg(msgnum, offsets[3], pb);
  newmsg->moves = (MigrateInfo *) ((char *)newmsg + offsets[0]);
  newmsg->avail_vector = (char *) ((char *)newmsg + offsets[1]);
  newmsg->expectedLoad = (double *) ((char *)newmsg + offsets[2]);
  return (void *) newmsg;
}
void* CMessage_LBMigrateMsg::pack(LBMigrateMsg *msg) {
  msg->moves = (MigrateInfo *) ((char *)msg->moves - (char *)msg);
  msg->avail_vector = (char *) ((char *)msg->avail_vector - (char *)msg);
  msg->expectedLoad = (double *) ((char *)msg->expectedLoad - (char *)msg);
  return (void *) msg;
}
LBMigrateMsg* CMessage_LBMigrateMsg::unpack(void* buf) {
  LBMigrateMsg *msg = (LBMigrateMsg *) buf;
  msg->moves = (MigrateInfo *) ((size_t)msg->moves + (char *)msg);
  msg->avail_vector = (char *) ((size_t)msg->avail_vector + (char *)msg);
  msg->expectedLoad = (double *) ((size_t)msg->expectedLoad + (char *)msg);
  return msg;
}
int CMessage_LBMigrateMsg::__idx=0;
#endif

/* DEFS: message LBVectorMigrateMsg{
VectorMigrateInfo moves[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_LBVectorMigrateMsg::operator new(size_t s){
  return LBVectorMigrateMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_LBVectorMigrateMsg::operator new(size_t s, int* sz){
  return LBVectorMigrateMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_LBVectorMigrateMsg::operator new(size_t s, int* sz,const int pb){
  return LBVectorMigrateMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_LBVectorMigrateMsg::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return LBVectorMigrateMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_LBVectorMigrateMsg::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return LBVectorMigrateMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_LBVectorMigrateMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(VectorMigrateInfo)*sizes[0]);
  LBVectorMigrateMsg *newmsg = (LBVectorMigrateMsg *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->moves = (VectorMigrateInfo *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void* CMessage_LBVectorMigrateMsg::pack(LBVectorMigrateMsg *msg) {
  msg->moves = (VectorMigrateInfo *) ((char *)msg->moves - (char *)msg);
  return (void *) msg;
}
LBVectorMigrateMsg* CMessage_LBVectorMigrateMsg::unpack(void* buf) {
  LBVectorMigrateMsg *msg = (LBVectorMigrateMsg *) buf;
  msg->moves = (VectorMigrateInfo *) ((size_t)msg->moves + (char *)msg);
  return msg;
}
int CMessage_LBVectorMigrateMsg::__idx=0;
#endif

/* DEFS: group BaseLB: IrrGroup{
BaseLB(CkMigrateMessage* impl_msg);
void BaseLB(const CkLBOptions &impl_noname_0);
void unregister(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_BaseLB::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: BaseLB(CkMigrateMessage* impl_msg);
 */

/* DEFS: void BaseLB(const CkLBOptions &impl_noname_0);
 */

/* DEFS: void unregister(void);
 */
/* DEFS: BaseLB(CkMigrateMessage* impl_msg);
 */
 int CkIndex_BaseLB::__idx_BaseLB_CkMigrateMessage=0;
void CkIndex_BaseLB::_call_BaseLB_CkMigrateMessage(void* impl_msg,BaseLB * impl_obj)
{
  new (impl_obj) BaseLB((CkMigrateMessage*)impl_msg);
}

/* DEFS: void BaseLB(const CkLBOptions &impl_noname_0);
 */
CkGroupID CProxy_BaseLB::ckNew(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const CkLBOptions &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkLBOptions &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkLBOptions &)impl_noname_0;
  }
  return CkCreateGroup(CkIndex_BaseLB::__idx, CkIndex_BaseLB::__idx_BaseLB_marshall1, impl_msg);
}
  CProxy_BaseLB::CProxy_BaseLB(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const CkLBOptions &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkLBOptions &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkLBOptions &)impl_noname_0;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_BaseLB::__idx, CkIndex_BaseLB::__idx_BaseLB_marshall1, impl_msg));
}
 int CkIndex_BaseLB::__idx_BaseLB_marshall1=0;
void CkIndex_BaseLB::_call_BaseLB_marshall1(void* impl_msg,BaseLB * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkLBOptions &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CkLBOptions impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) BaseLB(impl_noname_0);
}
int CkIndex_BaseLB::_callmarshall_BaseLB_marshall1(char* impl_buf,BaseLB * impl_obj) {
  /*Unmarshall pup'd fields: const CkLBOptions &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CkLBOptions impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) BaseLB(impl_noname_0);
  return implP.size();
}
void CkIndex_BaseLB::_marshallmessagepup_BaseLB_marshall1(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkLBOptions &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CkLBOptions impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("impl_noname_0");
  implDestP|impl_noname_0;
}

/* DEFS: void unregister(void);
 */
 int CkIndex_BaseLB::__idx_unregister_void=0;
void CkIndex_BaseLB::_call_unregister_void(void* impl_msg,BaseLB * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->unregister();
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_BaseLB::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,BaseLB::isIrreducible());
// REG: BaseLB(CkMigrateMessage* impl_msg);
  __idx_BaseLB_CkMigrateMessage = CkRegisterEp("BaseLB(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_BaseLB_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_BaseLB_CkMigrateMessage);

// REG: void BaseLB(const CkLBOptions &impl_noname_0);
  __idx_BaseLB_marshall1 = CkRegisterEp("BaseLB(const CkLBOptions &impl_noname_0)",
     (CkCallFnPtr)_call_BaseLB_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_BaseLB_marshall1,(CkMarshallUnpackFn)_callmarshall_BaseLB_marshall1);
  CkRegisterMessagePupFn(__idx_BaseLB_marshall1,(CkMessagePupFn)_marshallmessagepup_BaseLB_marshall1);

// REG: void unregister(void);
  __idx_unregister_void = CkRegisterEp("unregister(void)",
     (CkCallFnPtr)_call_unregister_void, 0, __idx, 0+CK_EP_INTRINSIC);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerBaseLB(void)
{
  static int _done = 0; if(_done) return; _done = 1;
      _registerLBDatabase();

/* REG: message LBMigrateMsg{
MigrateInfo moves[];
char avail_vector[];
double expectedLoad[];
}
;
*/
CMessage_LBMigrateMsg::__register("LBMigrateMsg", sizeof(LBMigrateMsg),(CkPackFnPtr) LBMigrateMsg::pack,(CkUnpackFnPtr) LBMigrateMsg::unpack);

/* REG: message LBVectorMigrateMsg{
VectorMigrateInfo moves[];
}
;
*/
CMessage_LBVectorMigrateMsg::__register("LBVectorMigrateMsg", sizeof(LBVectorMigrateMsg),(CkPackFnPtr) LBVectorMigrateMsg::pack,(CkUnpackFnPtr) LBVectorMigrateMsg::unpack);

/* REG: group BaseLB: IrrGroup{
BaseLB(CkMigrateMessage* impl_msg);
void BaseLB(const CkLBOptions &impl_noname_0);
void unregister(void);
};
*/
  CkIndex_BaseLB::__register("BaseLB", sizeof(BaseLB));

}
#endif
