package projector.core;

/**
 * Author: Arun Singla 
 * May 2, 2002
 */

/**
 * EventObject  
 * The abstract base class for all events traced by projector. 
 */
public abstract class EventObject implements Cloneable
{
	public int 	  proc;			// processor on which event occured
 	public int    language;		// language to which the event belongs
	public int    eventType;	// language specfic event Type
	public double timestamp;	// timestamp

	// the following attributes are specifically for 'TraceReader:nextGlobalEvent' method
	public int    nextLang;		// language ID of next event
	public int    nextSeek;		// seek in corresponding log file
	public int    eLen;
	public int[]  entity;
	public int    iLen;
	public int[]  iData;
	public String sData;

	public EventObject(){};
	public EventObject(EventObject e){
		this.proc = e.proc;
		this.language = e.language;
		this.eventType = e.eventType;
		this.timestamp = e.timestamp;
		this.nextLang = e.nextLang;
		this.nextSeek = e.nextSeek;
		this.eLen = e.eLen;
		if(e.entity != null){
			this.entity = (int [])(e.entity).clone();
		}else{
			this.entity = null;
		}
		this.iLen = e.iLen;
		if(e.iData != null){
			this.iData = (int [])(e.iData).clone();
		}else{
			this.iData = null;
		}
		if(e.sData != null){
			this.sData = new String(e.sData);
		}else{
			this.sData = null;
		}
	}
  	public  	    void parseEntity(int[] entity) throws AbortException {}
  	public abstract void parseIData(int[] iData)   throws AbortException; 
  	public          void parseSData(String sData)  throws AbortException{}
}

