/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import projections.analysis.ProjMain;
import projections.gui.MainWindow;
import projections.gui.MenuManager;

public class MainMenuManager
extends MenuManager
implements ActionListener,
ItemListener {
    private JMenu fileMenu;
    private JMenu preferencesMenu;
    private JMenu toolMenu;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private static final int OPENED_SUMMARY = 2;
    private MainWindow parent;

    public MainMenuManager(JFrame parent) {
        super(parent);
        this.parent = (MainWindow)parent;
        this.createMenus();
    }

    void stateChanged(int state) {
        switch (state) {
            case 0: {
                boolean[] blArray = new boolean[5];
                blArray[0] = true;
                blArray[4] = true;
                this.setEnabled(this.fileMenu, blArray);
                boolean[] blArray2 = new boolean[4];
                blArray2[0] = true;
                blArray2[1] = true;
                this.setEnabled(this.preferencesMenu, blArray2);
                boolean[] blArray3 = new boolean[17];
                blArray3[13] = true;
                this.setEnabled(this.toolMenu, blArray3);
                break;
            }
            case 2: {
                boolean[] blArray = new boolean[5];
                blArray[0] = true;
                blArray[1] = true;
                blArray[2] = true;
                blArray[4] = true;
                this.setEnabled(this.fileMenu, blArray);
                boolean[] blArray4 = new boolean[4];
                blArray4[0] = true;
                blArray4[1] = true;
                this.setEnabled(this.preferencesMenu, blArray4);
                boolean[] blArray5 = new boolean[17];
                blArray5[0] = true;
                blArray5[2] = true;
                blArray5[8] = true;
                blArray5[9] = true;
                blArray5[13] = true;
                blArray5[15] = true;
                blArray5[16] = true;
                this.setEnabled(this.toolMenu, blArray5);
                break;
            }
            case 1: {
                boolean[] blArray = new boolean[5];
                blArray[0] = true;
                blArray[1] = true;
                blArray[2] = true;
                blArray[4] = true;
                this.setEnabled(this.fileMenu, blArray);
                boolean[] blArray6 = new boolean[4];
                blArray6[0] = true;
                blArray6[1] = true;
                this.setEnabled(this.preferencesMenu, blArray6);
                this.setEnabled(this.toolMenu, new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true});
            }
        }
    }

    private void createMenus() {
        Object[] objectArray = new Object[5];
        objectArray[0] = "Open File(s)";
        objectArray[1] = "Close current data";
        objectArray[2] = "Close all data";
        objectArray[4] = "Quit";
        this.fileMenu = this.makeJMenu("File", objectArray);
        this.menubar.add(this.fileMenu);
        this.preferencesMenu = this.makeJMenu("Preferences", new Object[]{"Change Background Color", "Change Foreground Color", "Use Default Grayscale Colors", "Use Standard Colors"});
        this.menubar.add(this.preferencesMenu);
        this.toolMenu = this.makeJMenu("Tools", MainWindow.windowMenuNames);
        this.menubar.add(this.toolMenu);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)e.getSource();
            String arg = mi.getText();
            if (arg.equals("Open File(s)")) {
                this.parent.showOpenFileDialog();
            }
            if (arg.equals("Close current data")) {
                this.parent.closeCurrent();
            } else if (arg.equals("Close all data")) {
                this.parent.closeAll();
            } else if (arg.equals("Quit")) {
                ProjMain.shutdown(0);
            } else if (arg.equals("Change Background Color")) {
                this.parent.changeBackground();
            } else if (arg.equals("Change Foreground Color")) {
                this.parent.changeForeground();
            } else if (arg.equals("Use Default Grayscale Colors")) {
                this.parent.setGrayscale();
            } else if (arg.equals("Use Standard Colors")) {
                this.parent.setFullColor();
            } else {
                int i = 0;
                while (i < 18 && i < MainWindow.windowMenuNames.length) {
                    if (MainWindow.windowMenuNames[i].equals(arg)) {
                        this.parent.showChildWindow(MainWindow.windowClassNames[i], i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void fileOpened() {
        this.stateChanged(1);
    }

    public void lastFileClosed() {
        this.stateChanged(0);
    }

    public void summaryOnly() {
        this.stateChanged(2);
    }
}

