/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.CpdUtil;
import charm.debug.EpCheckBox;
import charm.debug.EpTreeCheckBox;
import charm.debug.EpTreeListener;
import charm.debug.EpTreeRenderer;
import charm.debug.GdbProcess;
import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.ChareInfo;
import charm.debug.pdata.CharePList;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.EpPList;
import charm.debug.preference.PyFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PythonDialog
extends JDialog
implements ActionListener {
    private static final String beginning = "def method(self):";
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenuItem menuOpen;
    private JMenuItem menuSave;
    private JComboBox chare;
    private JTextArea input;
    private JScrollPane inputScrollPane;
    private JScrollPane entryScrollPane;
    private JButton confirm;
    private JButton cancel;
    private boolean confirmed;
    private String parsedString;
    private GdbProcess info;

    public PythonDialog(Frame parent, boolean modal, CharePList chareItems, ChareTypePList chareTypeItems, GdbProcess gdb, CpdUtil server) {
        super(parent, "Python script", modal);
        ChareInfo type;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.confirmed = false;
        this.parsedString = null;
        this.info = gdb;
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane top = new JSplitPane(1);
        top.setResizeWeight(0.5);
        JPanel topLeft = new JPanel();
        topLeft.setLayout(new BorderLayout());
        this.chare = new JComboBox();
        this.chare.addItem("Select one...");
        int i = 0;
        while ((type = chareItems.elementAt(i)) != null) {
            this.chare.addItem(type);
            ++i;
        }
        topLeft.add((Component)this.chare, "North");
        this.input = new JTextArea("", 20, 40);
        this.input.setText("def method(self):\n\t");
        this.input.setTabSize(4);
        this.input.setToolTipText("Write your python code here");
        this.inputScrollPane = new JScrollPane(this.input);
        topLeft.add(this.inputScrollPane);
        top.setLeftComponent(topLeft);
        this.entryScrollPane = new JScrollPane();
        int nItems = server.getListLength("charm/entries", 0);
        EpPList epItems = new EpPList();
        epItems.setLookups(chareTypeItems);
        epItems.load(server.getPList("charm/entries", 0, 0, nItems));
        DefaultMutableTreeNode[] chareRoots = new DefaultMutableTreeNode[chareTypeItems.size()];
        Vector items = epItems.getUserEps();
        int l = items.size();
        i = 0;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode userRoot = new DefaultMutableTreeNode("User Entries");
        for (i = 0; i < l; ++i) {
            EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
            chkbox.addActionListener(this);
            chkbox.setActionCommand("entry");
            int chareType = ((EpInfo)items.elementAt(i)).getChareType();
            if (chareRoots[chareType] == null) {
                chareRoots[chareType] = new DefaultMutableTreeNode(chareTypeItems.elementAt(chareType).getType());
                userRoot.add(chareRoots[chareType]);
            }
            chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
        }
        items = epItems.getSystemEps();
        l = items.size();
        DefaultMutableTreeNode sysRoot = new DefaultMutableTreeNode("System Entries");
        for (i = 0; i < l; ++i) {
            EpCheckBox chkbox = new EpCheckBox((EpInfo)items.elementAt(i));
            chkbox.addActionListener(this);
            chkbox.setActionCommand("breakpoints");
            int chareType = ((EpInfo)items.elementAt(i)).getChareType();
            if (chareRoots[chareType] == null) {
                chareRoots[chareType] = new DefaultMutableTreeNode(chareTypeItems.elementAt(chareType).getType());
                sysRoot.add(chareRoots[chareType]);
            }
            chareRoots[chareType].add(new EpTreeCheckBox(chkbox));
        }
        root.add(sysRoot);
        root.add(userRoot);
        JTree treeBP = new JTree(root);
        treeBP.setRootVisible(false);
        treeBP.collapseRow(0);
        treeBP.expandRow(1);
        treeBP.addMouseListener(new EpTreeListener(treeBP));
        treeBP.setCellRenderer(new EpTreeRenderer());
        treeBP.getSelectionModel().setSelectionMode(1);
        this.entryScrollPane.setViewportView(treeBP);
        top.setRightComponent(this.entryScrollPane);
        this.getContentPane().add(top);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createHorizontalGlue());
        this.confirm = new JButton("Send");
        this.confirm.setActionCommand("ok");
        this.confirm.addActionListener(this);
        this.confirm.setToolTipText("Execute the python script to the application");
        buttons.add(this.confirm);
        buttons.add(Box.createRigidArea(new Dimension(30, 1)));
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttons, "South");
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuOpen = new JMenuItem("Open");
        this.menuFile.add(this.menuOpen);
        this.menuOpen.setActionCommand("open");
        this.menuOpen.addActionListener(this);
        this.menuSave = new JMenuItem("Save...");
        this.menuFile.add(this.menuSave);
        this.menuSave.setActionCommand("save");
        this.menuSave.addActionListener(this);
        this.setJMenuBar(this.menuBar);
        this.pack();
        this.setVisible(true);
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    public String getText() {
        return this.parsedString;
    }

    public int getChareGroup() {
        return ((ChareInfo)this.chare.getSelectedItem()).getGroupID();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            if (this.chare.getSelectedIndex() == 0) {
                JOptionPane.showMessageDialog(this, "Must select an object on which to execute the script", "Error", 0);
                return;
            }
            this.parsedString = this.input.getText();
            if (!this.parsedString.startsWith(beginning)) {
                JOptionPane.showMessageDialog(this, "The code must start with 'def method(self):'", "Error", 0);
                return;
            }
            int first = 0;
            int last = 0;
            while ((first = this.parsedString.indexOf("charm.get", first)) != -1) {
                int startArgs = this.parsedString.indexOf(40, first += 9);
                if (this.parsedString.startsWith("Static", first)) {
                    int splitPoint = this.parsedString.indexOf(")", startArgs);
                    String name = this.parsedString.substring(startArgs + 1, splitPoint).trim();
                    System.out.println("Static name = " + name);
                    String address = this.info.infoCommand("print &" + name.substring(1, name.length() - 1) + "\n");
                    int startAddress = address.indexOf("0x");
                    if (startAddress == -1) {
                        JOptionPane.showMessageDialog(this, "Static variable " + name + " not found", "Error", 0);
                        return;
                    }
                    System.out.println("Reply: " + address);
                    int retType = 112;
                    if (address.indexOf("(int *)") != -1) {
                        retType = 105;
                    } else if (address.indexOf("(char *)") != -1) {
                        retType = 98;
                    } else if (address.indexOf("(short *)") != -1) {
                        retType = 104;
                    } else if (address.indexOf("(long *)") != -1) {
                        retType = 108;
                    } else if (address.indexOf("(float *)") != -1) {
                        retType = 102;
                    } else if (address.indexOf("(double *)") != -1) {
                        retType = 100;
                    } else if (address.indexOf("(char **)") != -1) {
                        retType = 115;
                    }
                    this.parsedString = this.parsedString.substring(0, splitPoint) + "," + address.substring(startAddress).trim() + ",'" + (char)retType + "'" + this.parsedString.substring(splitPoint);
                    continue;
                }
                last = this.parsedString.indexOf(44, startArgs);
                String type = this.parsedString.substring(last + 1, this.parsedString.indexOf(44, last + 1)).trim();
                GenericType t = Inspector.getTypeCreate(type);
                System.out.println("get type " + type + " (last=" + last + ")");
                last = this.parsedString.indexOf(44, last + 1);
                int splitPoint = this.parsedString.indexOf(41, last + 1);
                if (this.parsedString.startsWith("Array", first)) {
                    int size = t.getSize();
                    this.parsedString = this.parsedString.substring(0, splitPoint) + "," + size + this.parsedString.substring(splitPoint);
                    continue;
                }
                if (this.parsedString.startsWith("Value", first)) {
                    String name = this.parsedString.substring(last + 1, this.parsedString.indexOf(41, last + 1)).trim();
                    if (!(t instanceof DataType)) {
                        JOptionPane.showMessageDialog(this, "Invalid parameter '" + type + "' to function getValue", "Error", 0);
                        return;
                    }
                    DataType dt = (DataType)t;
                    int offset = dt.getVariableOffset(name);
                    if (offset < 0) {
                        JOptionPane.showMessageDialog(this, "Invalid variable '" + name + "' in type '" + type + "' to function getValue", "Error", 0);
                        return;
                    }
                    GenericType resultType = dt.getVariableType(name);
                    this.parsedString = this.parsedString.substring(0, splitPoint) + "," + offset + "," + resultType.getType().getName() + this.parsedString.substring(splitPoint);
                    continue;
                }
                if (!this.parsedString.startsWith("Cast", first)) continue;
                String newtype = this.parsedString.substring(last + 1, this.parsedString.indexOf(41, last + 1)).trim();
                GenericType nt = Inspector.getTypeCreate(newtype);
                if (!(t instanceof DataType)) {
                    JOptionPane.showMessageDialog(this, "Invalid parameter '" + type + "' to function getCast", "Error", 0);
                    return;
                }
                if (!(nt instanceof DataType)) {
                    JOptionPane.showMessageDialog(this, "Invalid parameter '" + newtype + "' to function getCast", "Error", 0);
                    return;
                }
                DataType dt = (DataType)t;
                DataType ndt = (DataType)nt;
                int offset = 0;
                if (dt.hasSuperclass(ndt)) {
                    offset = dt.getSuperclassOffset(ndt);
                } else if (ndt.hasSuperclass(dt)) {
                    offset = ndt.getSuperclassOffset(dt);
                } else {
                    JOptionPane.showMessageDialog(this, "Could not cast between '" + type + "' and '" + newtype + "'", "Error", 0);
                    return;
                }
                this.parsedString = this.parsedString.substring(0, splitPoint) + "," + offset + this.parsedString.substring(splitPoint);
            }
            this.confirmed = true;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("cancel")) {
            this.confirmed = false;
            this.parsedString = null;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("open")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new PyFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.loadPythonCode(chooser.getSelectedFile());
            }
        } else if (e.getActionCommand().equals("save")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.addChoosableFileFilter(new PyFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                int response;
                File filename = chooser.getSelectedFile();
                if (!filename.getName().endsWith(".py")) {
                    filename = new File(filename.getAbsolutePath() + ".py");
                }
                if (filename.exists() && (response = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the file?", "File overwrite", 0)) != 0) {
                    return;
                }
                this.savePythonCode(filename);
            }
        }
    }

    boolean loadPythonCode(File f) {
        try {
            StringBuffer fileData = new StringBuffer(1000);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            reader.close();
            this.input.setText(fileData.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to load file '" + f.getName() + "'", "Error", 0);
            return false;
        }
        return true;
    }

    boolean savePythonCode(File f) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            writer.write(this.input.getText());
            writer.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Unable to save file '" + f.getName() + "'", "Error", 0);
            return false;
        }
        return true;
    }
}

