/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

public class KMeansClustering {
    public static void kMeans(double[][] data, int numClusters, int[] clusterMap, double[] distanceFromClusterMean) {
        int numProcs = data.length;
        int numEPs = data[0].length;
        double[][] mean = new double[numClusters][numEPs];
        double[][] oldMean = new double[numClusters][numEPs];
        int[] clusterCounts = new int[numClusters];
        double[][] clusterMinBound = new double[numClusters][numEPs];
        int ep = 0;
        while (ep < numEPs) {
            double minVal = Double.MAX_VALUE;
            double maxVal = Double.MIN_VALUE;
            int p = 0;
            while (p < numProcs) {
                if (data[p][ep] < minVal) {
                    minVal = data[p][ep];
                }
                if (data[p][ep] > maxVal) {
                    maxVal = data[p][ep];
                }
                ++p;
            }
            double interval = (maxVal - minVal + 1.0) / (double)numClusters;
            int k = 0;
            while (k < numClusters) {
                mean[k][ep] = (double)(k + 1) * interval - interval / 2.0 + minVal;
                ++k;
            }
            ++ep;
        }
        while (KMeansClustering.checkMean(mean, oldMean)) {
            int ep2;
            int k = 0;
            while (k < numClusters) {
                clusterCounts[k] = 0;
                ++k;
            }
            int p = 0;
            while (p < numProcs) {
                double minDist = Double.MAX_VALUE;
                int minSample = 0;
                int k2 = 0;
                while (k2 < numClusters) {
                    double tempDist = 0.0;
                    int ep3 = 0;
                    while (ep3 < numEPs) {
                        tempDist += Math.pow(data[p][ep3] - mean[k2][ep3], 2.0);
                        ++ep3;
                    }
                    if ((tempDist = Math.sqrt(tempDist)) < minDist) {
                        minDist = tempDist;
                        minSample = k2;
                    }
                    ++k2;
                }
                int n = minSample;
                clusterCounts[n] = clusterCounts[n] + 1;
                clusterMap[p] = minSample;
                distanceFromClusterMean[p] = minDist;
                ++p;
            }
            k = 0;
            while (k < numClusters) {
                ep2 = 0;
                while (ep2 < numEPs) {
                    clusterMinBound[k][ep2] = Double.MAX_VALUE;
                    mean[k][ep2] = Double.MIN_VALUE;
                    ++ep2;
                }
                ++k;
            }
            p = 0;
            while (p < numProcs) {
                ep2 = 0;
                while (ep2 < numEPs) {
                    if (data[p][ep2] < clusterMinBound[clusterMap[p]][ep2]) {
                        clusterMinBound[clusterMap[p]][ep2] = data[p][ep2];
                    }
                    if (data[p][ep2] > mean[clusterMap[p]][ep2]) {
                        mean[clusterMap[p]][ep2] = data[p][ep2];
                    }
                    ++ep2;
                }
                ++p;
            }
            k = 0;
            while (k < numClusters) {
                ep2 = 0;
                while (ep2 < numEPs) {
                    mean[k][ep2] = clusterCounts[k] > 0 ? (mean[k][ep2] - clusterMinBound[k][ep2]) / 2.0 + clusterMinBound[k][ep2] : oldMean[k][ep2];
                    ++ep2;
                }
                ++k;
            }
        }
    }

    public static boolean checkMean(double[][] mean, double[][] oldMean) {
        boolean returnVal = false;
        int k = 0;
        while (k < mean.length) {
            int ep = 0;
            while (ep < mean[k].length) {
                if (mean[k][ep] != oldMean[k][ep]) {
                    returnVal = true;
                    oldMean[k][ep] = mean[k][ep];
                }
                ++ep;
            }
            ++k;
        }
        return returnVal;
    }

    public static void printMean(double[][] mean) {
        System.out.println("Mean:");
        System.out.println("-----");
        int k = 0;
        while (k < mean.length) {
            System.out.print("[" + k + "]; (");
            int ep = 0;
            while (ep < mean[k].length) {
                System.out.print(" " + mean[k][ep]);
                ++ep;
            }
            System.out.println(" )");
            ++k;
        }
    }

    public static void outputResults(int[] clusterMap, int numClusters) {
        System.out.println("Cluster Map:");
        System.out.println("------------");
        int k = 0;
        while (k < numClusters) {
            System.out.print("[" + k + "]: ");
            int p = 0;
            while (p < clusterMap.length) {
                if (clusterMap[p] == k) {
                    System.out.print(String.valueOf(p) + " ");
                }
                ++p;
            }
            System.out.println();
            ++k;
        }
    }

    public static void main(String[] args) {
        int numClusters = 5;
        double[][] data = new double[][]{{0.0, 5.0}, {1.0, 1.0}, {1.0, 2.0}, {1.0, 4.0}, {2.0, 1.0}, {2.0, 7.0}, {3.0, 6.0}, {3.0, 8.0}, {4.0, 9.0}, {5.0, 2.0}, {5.0, 7.0}, {6.0, 1.0}, {7.0, 2.0}, {9.0, 4.0}, {9.0, 5.0}};
        int[] clusterMap = new int[data.length];
        double[] distanceFromClusterMean = new double[data.length];
        KMeansClustering.kMeans(data, numClusters, clusterMap, distanceFromClusterMean);
        KMeansClustering.outputResults(clusterMap, numClusters);
    }
}

