/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.AllocationGraphDialog;
import charm.debug.AllocationGraphPanel;
import charm.debug.AllocationTreePanel;
import charm.debug.CpdUtil;
import charm.debug.GdbProcess;
import charm.debug.MemoryDialog;
import charm.debug.MemoryPanel;
import charm.debug.MemoryTrace;
import charm.debug.PListOutputArea;
import charm.debug.ParamsDialog;
import charm.debug.ServThread;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.CharePList;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpPList;
import charm.debug.pdata.GenericInfo;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.MsgPList;
import charm.debug.pdata.MsgTypePList;
import charm.debug.pdata.ReadonlyPList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParDebug
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static String filename;
    private static String hostname;
    private static String username;
    private static String portnumber;
    private static String hostnumber;
    private static int numberPes;
    private static String clparams;
    private static String envDisplay;
    private static boolean tunnelNeeded;
    private static Process sshTunnel;
    public static byte[] globals;
    public static int dataPos;
    static ServThread servthread;
    private static GdbProcess gdb;
    public static CpdUtil server;
    private DefaultListModel listModel;
    private PList listItems = null;
    private boolean isRunning = false;
    private boolean[] peList = null;
    public static int currentListedPE;
    private MsgPList messageQueue;
    private EpPList epItems;
    private MsgTypePList msgItems;
    private ChareTypePList chareItems;
    private CpdListInfo[] cpdLists;
    private static JFrame appFrame;
    private JButton startButton;
    private JButton continueButton;
    private JButton quitButton;
    private JButton freezeButton;
    private JButton startGdbButton;
    private JPanel peActualPanel;
    private JPanel sysEpsActualPanel;
    private JPanel userEpsActualPanel;
    private JTextArea programOutputArea;
    private JScrollPane outputAreaScrollPane;
    private PListOutputArea outputArea;
    private JTextArea newOutputArea;
    private JTextField statusArea;
    private JComboBox listsbox;
    private JComboBox pesbox;
    private JList listItemNames;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuAction;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileParameters;
    private JMenuItem menuActionStart;
    private JMenuItem menuActionContinue;
    private JMenuItem menuActionQuit;
    private JMenuItem menuActionFreeze;
    private JMenuItem menuActionMemory;
    private JMenuItem menuActionAllocationTree;
    private JMenuItem menuActionAllocationGraph;

    public static String infoCommand(String string) {
        return gdb.infoCommand(string);
    }

    private void abort(String string) {
        System.out.println(string);
        System.exit(1);
    }

    private String getEnvDisplay() {
        String string = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string = string2 + ":0.0";
            System.out.println("DISPLAY variable = " + string);
        }
        catch (Exception exception) {
            this.abort("Error retrieving IP address for DISPLAY variable: " + exception.getMessage());
        }
        return string;
    }

    public void displayProgramOutput(String string) {
        this.programOutputArea.append(string);
        this.programOutputArea.scrollRectToVisible(new Rectangle(0, this.programOutputArea.getHeight() - 2, 1, 1));
    }

    private static void setNumberPes(String string) {
        try {
            numberPes = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Could not convert number of pes " + string + " to an integer.");
            System.exit(1);
        }
    }

    public void setParametersForProgram(String string, String string2, String string3, String string4, String string5, boolean bl) {
        ParDebug.setNumberPes(string2);
        clparams = string;
        portnumber = string3;
        hostname = string4;
        username = string5;
        tunnelNeeded = bl;
        this.addedRunParameter();
    }

    private void addedRunParameter() {
        this.setStatusMessage("Executable: " + filename + "        number of pes: " + numberPes);
    }

    public void setStatusMessage(String string) {
        this.statusArea.setText(string);
    }

    private void populateNewList(int n, int n2, DefaultListModel defaultListModel) {
        defaultListModel.removeAllElements();
        this.outputArea.setList(null);
        this.newOutputArea.setText("");
        this.listItems = null;
        String string = this.cpdLists[n].name;
        if (string == null) {
            return;
        }
        GenericPList genericPList = this.cpdLists[n].list;
        if (genericPList == null || genericPList.needRefresh()) {
            int n3 = server.getListLength(string, n2);
            this.listItems = server.getPList(string, n2, 0, n3);
        }
        if (genericPList != null) {
            if (genericPList.needRefresh()) {
                genericPList.load(this.listItems);
            }
            genericPList.populate(defaultListModel);
        } else {
            for (PAbstract pAbstract = this.listItems.elementAt(0); pAbstract != null; pAbstract = pAbstract.getNext()) {
                defaultListModel.addElement(pAbstract.getDeepName());
            }
        }
    }

    private void expandListElement(int n, int n2, int n3) {
        currentListedPE = n2;
        String string = this.cpdLists[n].detailedName;
        if (string == null) {
            if (this.cpdLists[n].list != null) {
                this.outputAreaScrollPane.setViewportView(this.newOutputArea);
                Object e = this.listItemNames.getSelectedValue();
                if (e instanceof GenericInfo) {
                    this.outputAreaScrollPane.setViewportView(((GenericInfo)e).getDetails());
                } else {
                    System.out.println("Error: element not of type GenericInfo");
                }
            } else {
                this.outputAreaScrollPane.setViewportView(this.outputArea);
                this.outputArea.setList((PList)this.listItems.elementAt(n3));
            }
        } else {
            this.outputAreaScrollPane.setViewportView(this.outputArea);
            PList pList = server.getPList(string, n2, n3, n3 + 1);
            this.outputArea.setList(pList);
        }
    }

    private void listenTo(JMenuItem jMenuItem, String string, String string2) {
        if (string2 != null) {
            jMenuItem.setToolTipText(string2);
        }
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
    }

    public ParDebug() {
        CpdListInfo[] cpdListInfoArray = new CpdListInfo[11];
        cpdListInfoArray[0] = new CpdListInfo("-- Display --", null, null, null);
        cpdListInfoArray[1] = new CpdListInfo("Charm Objects", "charm/objectNames", null, new CharePList());
        cpdListInfoArray[2] = new CpdListInfo("Array Elements", "charm/arrayElements", null, new CharePList());
        this.messageQueue = new MsgPList();
        cpdListInfoArray[3] = new CpdListInfo("Messages in Queue", "converse/localqueue", null, this.messageQueue);
        cpdListInfoArray[4] = new CpdListInfo("Readonly Variables", "charm/readonly", null, new ReadonlyPList());
        cpdListInfoArray[5] = new CpdListInfo("Readonly Messages", "charm/readonlyMsg", null, null);
        this.epItems = new EpPList();
        cpdListInfoArray[6] = new CpdListInfo("Entry Points", "charm/entries", null, this.epItems);
        this.chareItems = new ChareTypePList();
        cpdListInfoArray[7] = new CpdListInfo("Chare Types", "charm/chares", null, this.chareItems);
        this.msgItems = new MsgTypePList();
        cpdListInfoArray[8] = new CpdListInfo("Message Types", "charm/messages", null, this.msgItems);
        cpdListInfoArray[9] = new CpdListInfo("Mainchares", "charm/mains", null, null);
        cpdListInfoArray[10] = new CpdListInfo("Viewable Lists", "converse/lists", null, null);
        this.cpdLists = cpdListInfoArray;
        this.isRunning = false;
        this.setLayout(new BoxLayout(this, 1));
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuFileOpen = new JMenuItem("Open Program", 79);
        this.menuFile.add(this.menuFileOpen);
        this.listenTo(this.menuFileOpen, "browse", "Open a parallel program to debug");
        this.menuFileParameters = new JMenuItem("Program Parameters", 80);
        this.menuFile.add(this.menuFileParameters);
        this.listenTo(this.menuFileParameters, "params", "Enter command-line parameters for the parallel program");
        this.menuFile.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Exit Debugger", 88);
        this.menuFile.add(jMenuItem);
        this.listenTo(jMenuItem, "exitDebugger", null);
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuActionStart = new JMenuItem("Start", 83);
        this.menuAction.add(this.menuActionStart);
        this.listenTo(this.menuActionStart, "begin", "Start the parallel program");
        this.menuActionContinue = new JMenuItem("Continue", 67);
        this.menuAction.add(this.menuActionContinue);
        this.listenTo(this.menuActionContinue, "unfreeze", "Continue to run the parallel program");
        this.menuActionFreeze = new JMenuItem("Freeze", 70);
        this.menuAction.add(this.menuActionFreeze);
        this.listenTo(this.menuActionFreeze, "freeze", "Freeze the parallel program");
        this.menuActionQuit = new JMenuItem("Quit", 81);
        this.menuAction.add(this.menuActionQuit);
        this.listenTo(this.menuActionQuit, "quit", "Quit the parallel program");
        this.menuAction.addSeparator();
        this.menuActionMemory = new JMenuItem("Memory", 77);
        this.menuAction.add(this.menuActionMemory);
        this.listenTo(this.menuActionMemory, "memory", "Inspect the application memory");
        this.menuActionAllocationTree = new JMenuItem("Memory Allocation Tree", 84);
        this.menuAction.add(this.menuActionAllocationTree);
        this.listenTo(this.menuActionAllocationTree, "allocationTree", "Print the memory allocation tree");
        this.menuActionAllocationGraph = new JMenuItem("Memory Allocation Graph", 71);
        this.menuAction.add(this.menuActionAllocationGraph);
        this.listenTo(this.menuActionAllocationGraph, "allocationGraph", "Print the memory allocation graph");
        this.statusArea = new JTextField(60);
        this.statusArea.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusArea.setMaximumSize(new Dimension(1000000, 40));
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Set Break Points"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        jPanel2.setPreferredSize(new Dimension(200, 380));
        this.sysEpsActualPanel = new JPanel();
        this.sysEpsActualPanel.setLayout(new BoxLayout(this.sysEpsActualPanel, 1));
        JScrollPane jScrollPane = new JScrollPane(this.sysEpsActualPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("System Entry Points"));
        jScrollPane.setPreferredSize(new Dimension(200, 185));
        this.userEpsActualPanel = new JPanel();
        this.userEpsActualPanel.setLayout(new BoxLayout(this.userEpsActualPanel, 1));
        JScrollPane jScrollPane2 = new JScrollPane(this.userEpsActualPanel);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("User Entry Points"));
        jScrollPane2.setPreferredSize(new Dimension(200, 185));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jPanel2.add(jSplitPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control Buttons"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        jPanel4.setPreferredSize(new Dimension(500, 80));
        this.startButton = new JButton("Start");
        this.startButton.setVerticalTextPosition(0);
        this.startButton.setHorizontalTextPosition(2);
        this.startButton.setMnemonic(83);
        this.startButton.setActionCommand("begin");
        this.startButton.setEnabled(true);
        this.startButton.setToolTipText("Run the parallel program from scratch.");
        this.startButton.addActionListener(this);
        this.startButton.setPreferredSize(new Dimension(100, 80));
        this.continueButton = new JButton("Continue");
        this.continueButton.setVerticalTextPosition(3);
        this.continueButton.setHorizontalTextPosition(0);
        this.continueButton.setMnemonic(85);
        this.continueButton.setActionCommand("unfreeze");
        this.continueButton.setEnabled(false);
        this.continueButton.setToolTipText("Resume execution.");
        this.continueButton.addActionListener(this);
        this.continueButton.setPreferredSize(new Dimension(100, 80));
        this.freezeButton = new JButton("Freeze");
        this.freezeButton.setVerticalTextPosition(3);
        this.freezeButton.setHorizontalTextPosition(0);
        this.freezeButton.setActionCommand("freeze");
        this.freezeButton.setEnabled(false);
        this.freezeButton.setToolTipText("Stop execution.");
        this.freezeButton.addActionListener(this);
        this.freezeButton.setPreferredSize(new Dimension(100, 80));
        this.quitButton = new JButton("Quit");
        this.quitButton.setVerticalTextPosition(3);
        this.quitButton.setHorizontalTextPosition(0);
        this.quitButton.setMnemonic(81);
        this.quitButton.setActionCommand("quit");
        this.quitButton.setEnabled(false);
        this.quitButton.setToolTipText("End the program.");
        this.quitButton.addActionListener(this);
        this.quitButton.setPreferredSize(new Dimension(100, 80));
        this.startGdbButton = new JButton("Start GDB");
        this.startGdbButton.setVerticalTextPosition(3);
        this.startGdbButton.setHorizontalTextPosition(0);
        this.startGdbButton.setActionCommand("startgdb");
        this.startGdbButton.setEnabled(false);
        this.startGdbButton.setToolTipText("Start gdb on selected processors.");
        this.startGdbButton.addActionListener(this);
        this.startGdbButton.setPreferredSize(new Dimension(100, 80));
        jPanel4.add(this.startButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.continueButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.freezeButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.quitButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.startGdbButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.programOutputArea = new JTextArea();
        this.programOutputArea.setColumns(100);
        this.programOutputArea.setLineWrap(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.programOutputArea);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("Program Output"));
        jScrollPane3.setPreferredSize(new Dimension(350, 300));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setPreferredSize(new Dimension(50, 380));
        this.peActualPanel = new JPanel();
        this.peActualPanel.setLayout(new BoxLayout(this.peActualPanel, 1));
        JScrollPane jScrollPane4 = new JScrollPane(this.peActualPanel);
        jScrollPane4.setBorder(BorderFactory.createTitledBorder("Pes"));
        jPanel6.add(jScrollPane4);
        jPanel5.add(jScrollPane3);
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(jPanel6);
        jPanel5.setPreferredSize(new Dimension(500, 300));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel3.add(jPanel5);
        jPanel3.setPreferredSize(new Dimension(500, 380));
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel2, jPanel3);
        jSplitPane2.setResizeWeight(0.5);
        jPanel.add(jSplitPane2);
        jPanel.setPreferredSize(new Dimension(600, 380));
        this.add(this.statusArea);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.add(jPanel);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View Entities on PE"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] stringArray = new String[this.cpdLists.length];
        for (int i = 0; i < this.cpdLists.length; ++i) {
            stringArray[i] = this.cpdLists[i].display;
        }
        this.listsbox = new JComboBox<String>(stringArray);
        this.listsbox.setActionCommand("lists");
        this.listsbox.addActionListener(this);
        this.listsbox.setEnabled(false);
        this.listsbox.setPreferredSize(new Dimension(450, 70));
        this.pesbox = new JComboBox();
        this.pesbox.setActionCommand("changepe");
        this.pesbox.addActionListener(this);
        this.pesbox.setEnabled(false);
        this.pesbox.setPreferredSize(new Dimension(100, 70));
        jPanel7.add(this.listsbox);
        jPanel7.add(Box.createRigidArea(new Dimension(50, 70)));
        jPanel7.add(this.pesbox);
        jPanel7.setPreferredSize(new Dimension(600, 70));
        this.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        jPanel8.setPreferredSize(new Dimension(600, 230));
        this.listModel = new DefaultListModel();
        this.listItemNames = new JList(this.listModel);
        this.listItemNames.setSelectionMode(0);
        this.listItemNames.addListSelectionListener(this);
        JScrollPane jScrollPane5 = new JScrollPane(this.listItemNames);
        jScrollPane5.setBorder(BorderFactory.createTitledBorder("Entities"));
        this.outputArea = new PListOutputArea();
        this.newOutputArea = new JTextArea();
        this.newOutputArea.setEditable(false);
        this.newOutputArea.setBackground(this.outputArea.getBackground());
        this.newOutputArea.setLineWrap(true);
        this.newOutputArea.setWrapStyleWord(true);
        this.outputAreaScrollPane = new JScrollPane(this.outputArea);
        this.outputAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.outputAreaScrollPane.setBorder(BorderFactory.createTitledBorder("Details"));
        jScrollPane5.setPreferredSize(new Dimension(200, 230));
        this.outputAreaScrollPane.setPreferredSize(new Dimension(400, 230));
        JSplitPane jSplitPane3 = new JSplitPane(1, jScrollPane5, this.outputAreaScrollPane);
        jSplitPane3.setOneTouchExpandable(true);
        jPanel8.add(jSplitPane3);
        this.add(jPanel8);
        gdb = new GdbProcess(this);
        this.addedRunParameter();
        if (filename != "") {
            this.startProgram();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (actionEvent.getActionCommand().equals("browse")) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                filename = jFileChooser.getSelectedFile().getAbsolutePath();
                this.addedRunParameter();
            }
        } else if (actionEvent.getActionCommand().equals("params")) {
            ParamsDialog paramsDialog = new ParamsDialog((Frame)appFrame, true, this);
            paramsDialog.setLocationRelativeTo(appFrame);
            paramsDialog.setFields(clparams, "" + numberPes, portnumber, hostname, username, tunnelNeeded);
            paramsDialog.pack();
            paramsDialog.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("begin")) {
            this.startProgram();
        } else if (actionEvent.getActionCommand().equals("freeze")) {
            server.bcastCcsRequest("ccs_debug", "freeze", 1, numberPes, this.peList);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(false);
            this.setStatusMessage("Program is frozen on selected pes");
        } else if (actionEvent.getActionCommand().equals("unfreeze")) {
            server.bcastCcsRequest("ccs_continue_break_point", "", 0, numberPes, this.peList);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(true);
            this.setStatusMessage("Program is running");
        } else if (actionEvent.getActionCommand().equals("quit")) {
            server.bcastCcsRequest("ccs_debug_quit", "", 0, numberPes, this.peList);
            this.quitProgram();
        } else if (actionEvent.getActionCommand().equals("startgdb")) {
            server.bcastCcsRequest("ccs_remove_all_break_points", "", 0, numberPes, this.peList);
            for (int i = 0; i < numberPes; ++i) {
                int n;
                if (!this.peList[i]) continue;
                PList pList = server.getPList("hostinfo", i);
                PList pList2 = (PList)pList.elementAt(0);
                byte[] byArray = ((PString)pList2.elementNamed("address")).getBytes();
                int[] nArray = new int[4];
                for (n = 0; n < 4; ++n) {
                    nArray[n] = byArray[n];
                    if (nArray[n] >= 0) continue;
                    int n2 = n;
                    nArray[n2] = nArray[n2] + 256;
                }
                n = ((PNative)pList2.elementNamed("pid")).getIntValue(0);
                String string = null;
                String[] stringArray = null;
                String string2 = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                String string3 = "ssh " + string2 + " \"cat > /tmp/start_gdb." + n + " << END_OF_SCRIPT\n" + "shell /bin/rm -f /tmp/start_gdb." + n + "\n" + "handle SIGWINCH nostop noprint\n" + "handle SIGWAITING nostop noprint\n" + "attach " + n + "\n" + "END_OF_SCRIPT\n" + "gdb " + new File(filename).getAbsolutePath() + " -x /tmp/start_gdb." + n + "\"";
                if (!hostname.equals("localhost")) {
                    string = "ssh -T " + hostname + " ssh -T";
                    stringArray = new String[9];
                    stringArray[5] = hostname;
                    stringArray[6] = "ssh";
                    stringArray[7] = string2;
                    stringArray[8] = string3;
                } else {
                    string = "ssh -T";
                    stringArray = new String[7];
                    stringArray[5] = string2;
                    stringArray[6] = string3;
                }
                stringArray[0] = "xterm";
                stringArray[1] = "-title";
                stringArray[2] = "Node " + i;
                stringArray[3] = "-e";
                stringArray[4] = "/bin/bash";
                stringArray[5] = "-c";
                for (int j = 0; j < stringArray.length; ++j) {
                    System.out.print(stringArray[j] + " ");
                }
                System.out.println();
                try {
                    Process process = Runtime.getRuntime().exec(stringArray);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(actionEvent);
                }
            }
            this.setStatusMessage("Gdb started on selected pes");
        } else if (actionEvent.getActionCommand().equals("breakpoints")) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            if (jCheckBox.isSelected()) {
                server.bcastCcsRequest("ccs_set_break_point", string, 0, numberPes, this.peList);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(false);
                this.setStatusMessage("Break Point set at entry point " + string);
            } else {
                server.bcastCcsRequest("ccs_remove_break_point", string, 0, numberPes, this.peList);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(true);
                this.setStatusMessage("Break Point removed at entry point " + string + " on selected Pes");
            }
        } else if (actionEvent.getActionCommand().equals("memory")) {
            MemoryDialog memoryDialog = new MemoryDialog((Frame)appFrame, true, numberPes);
            if (memoryDialog.confirmed()) {
                MemoryPanel memoryPanel;
                JFrame jFrame = new JFrame("Memory visualization");
                jFrame.setDefaultCloseOperation(2);
                MemoryPanel memoryPanel2 = memoryPanel = new MemoryPanel();
                memoryPanel2.setOpaque(true);
                jFrame.setContentPane(memoryPanel2);
                memoryPanel.loadData(memoryDialog);
                jFrame.setTitle("Memory Processor " + memoryDialog.getPe());
                jFrame.setJMenuBar(memoryPanel.getMenu());
                jFrame.pack();
                jFrame.setVisible(true);
            }
        } else if (actionEvent.getActionCommand().equals("allocationTree")) {
            AllocationTreePanel allocationTreePanel;
            JFrame jFrame = new JFrame("Allocation Tree");
            jFrame.setDefaultCloseOperation(2);
            AllocationTreePanel allocationTreePanel2 = allocationTreePanel = new AllocationTreePanel();
            allocationTreePanel2.setOpaque(true);
            jFrame.setContentPane(allocationTreePanel2);
            jFrame.setTitle("Allocation Tree");
            allocationTreePanel.loadTree(jFrame);
            jFrame.pack();
            jFrame.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("allocationGraph")) {
            AllocationGraphDialog allocationGraphDialog = new AllocationGraphDialog((Frame)appFrame, true, numberPes);
            if (allocationGraphDialog.confirmed()) {
                AllocationGraphPanel allocationGraphPanel;
                JFrame jFrame = new JFrame("Allocation Graph");
                jFrame.setDefaultCloseOperation(2);
                AllocationGraphPanel allocationGraphPanel2 = allocationGraphPanel = new AllocationGraphPanel();
                allocationGraphPanel2.setOpaque(true);
                jFrame.setContentPane(allocationGraphPanel2);
                jFrame.setTitle("Allocation Graph");
                String string = new File(filename).getAbsolutePath();
                String string4 = new File(string).getParent();
                if (string4 == null) {
                    string4 = ".";
                }
                string4 = string4 + "/memoryLog_";
                allocationGraphPanel.load(jFrame, new MemoryTrace(string4, numberPes), allocationGraphDialog);
                jFrame.setJMenuBar(allocationGraphPanel.getMenu());
                jFrame.pack();
                jFrame.setVisible(true);
            }
        } else if (actionEvent.getActionCommand().equals("pecheck")) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            String string5 = string.substring(3);
            this.peList[Integer.parseInt((String)string5)] = jCheckBox.isSelected();
        } else if (actionEvent.getActionCommand().equals("lists") || actionEvent.getActionCommand().equals("changepe")) {
            if (this.pesbox.getSelectedItem() != null) {
                int n = Integer.parseInt((String)this.pesbox.getSelectedItem());
                this.populateNewList(this.listsbox.getSelectedIndex(), n, this.listModel);
            }
        } else if (actionEvent.getActionCommand().equals("exitDebugger")) {
            if (this.isRunning) {
                server.bcastCcsRequest("ccs_debug_quit", "", 0, numberPes, this.peList);
                this.quitProgram();
            }
            System.exit(0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.listItemNames && !jList.isSelectionEmpty()) {
            int n = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.expandListElement(this.listsbox.getSelectedIndex(), n, jList.getSelectedIndex());
        }
    }

    public void startProgram() {
        this.isRunning = true;
        this.programOutputArea.setText("");
        String string = new File(filename).getAbsolutePath();
        String string2 = new File(string).getParent();
        if (string2 == null) {
            string2 = ".";
        }
        String string3 = string2 + "/charmrun";
        if (envDisplay.length() == 0) {
            envDisplay = this.getEnvDisplay();
        }
        String string4 = string3 + " " + "+p" + numberPes + " " + string + " " + clparams + "  +cpd +DebugDisplay " + envDisplay + " ++server";
        if (portnumber.length() != 0) {
            string4 = string4 + " ++server-port " + portnumber;
        }
        if (!hostname.equals("localhost")) {
            if (username.length() > 0) {
                string4 = "-l " + username + " " + string4;
            }
            string4 = "ssh " + hostname + " " + string4;
        }
        System.out.println("ParDebug> " + string4);
        this.programOutputArea.setText(string4);
        Process process = null;
        Runtime runtime = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string4);
        }
        catch (Exception exception) {
            System.out.println("ParDebug> Error executing " + string4);
            this.quitProgram();
            return;
        }
        servthread = new ServThread(this, process);
        servthread.start();
        try {
            JCheckBox jCheckBox;
            String string5;
            int n;
            Object object;
            int n2;
            String string6 = this.getInitialInfo();
            int n3 = string6.indexOf("\n.data ");
            int n4 = string6.indexOf("\n", n3 + 1);
            String string7 = string6.substring(n3 + 6, n4).trim();
            int n5 = string7.indexOf(32);
            int n6 = string7.lastIndexOf(32);
            int n7 = Integer.parseInt(string7.substring(0, n5));
            dataPos = Integer.parseInt(string7.substring(n6 + 1));
            int n8 = string6.indexOf("\n.bss");
            int n9 = string6.indexOf("\n", n8 + 1);
            String string8 = string6.substring(n8 + 6, n9).trim();
            n5 = string8.indexOf(32);
            n6 = string8.lastIndexOf(32);
            int n10 = Integer.parseInt(string8.substring(0, n5));
            int n11 = Integer.parseInt(string8.substring(n6 + 1));
            globals = new byte[16];
            CcsServer.writeInt(globals, 0, dataPos);
            CcsServer.writeInt(globals, 4, dataPos + n7);
            CcsServer.writeInt(globals, 8, n11);
            CcsServer.writeInt(globals, 12, n11 + n10);
            long l = 0L;
            while (ParDebug.servthread.portno == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (l++ <= 600L) continue;
                this.abort("Timeout waiting for program to start up (and print its CCS port number)");
            }
            if (portnumber.length() == 0) {
                portnumber = ParDebug.servthread.portno;
            }
            if (hostname.equals("localhost")) {
                hostnumber = ParDebug.servthread.hostName;
            }
            System.out.println("ParDebug> Charmrun started (CCS IP " + (hostname.equals("localhost") ? hostnumber : hostname) + ", port " + portnumber + ")");
            String[] stringArray = new String[]{hostname.equals("localhost") ? hostnumber : hostname, portnumber};
            if (tunnelNeeded) {
                System.out.println("ParDebug> Tunneling connection through ssh");
                try {
                    sshTunnel = runtime.exec("ssh -2 -c blowfish -L " + portnumber + ":localhost:" + portnumber + " " + hostname);
                }
                catch (Exception exception) {
                    System.out.println("ParDebug> Could not create ssh tunnel");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                stringArray[0] = "localhost";
            }
            System.out.println("Connecting to: " + username + (username.length() > 0 ? "@" : "") + (hostname.equals("localhost") ? hostnumber : hostname) + ":" + portnumber);
            CcsServer ccsServer = CcsServer.create(stringArray, false);
            server = new CpdUtil(ccsServer);
            this.peList = new boolean[numberPes];
            for (n2 = 0; n2 < numberPes; ++n2) {
                object = new Integer(n2).toString();
                this.pesbox.addItem(object);
                String string9 = "pe " + (String)object;
                JCheckBox jCheckBox2 = new JCheckBox(string9);
                this.peActualPanel.add(jCheckBox2);
                jCheckBox2.setSelected(true);
                jCheckBox2.addActionListener(this);
                jCheckBox2.setActionCommand("pecheck");
                this.peList[n2] = true;
            }
            this.peActualPanel.updateUI();
            this.startButton.setEnabled(false);
            this.continueButton.setEnabled(true);
            this.quitButton.setEnabled(false);
            this.freezeButton.setEnabled(false);
            this.startGdbButton.setEnabled(true);
            Inspector.initialize(server);
            n2 = server.getListLength("charm/chares", 0);
            this.chareItems.load(server.getPList("charm/chares", 0, 0, n2));
            this.epItems.setLookups(this.chareItems);
            n2 = server.getListLength("charm/entries", 0);
            this.epItems.load(server.getPList("charm/entries", 0, 0, n2));
            object = this.epItems.getUserEps();
            int n12 = ((Vector)object).size();
            for (n = 0; n < n12; ++n) {
                string5 = ((Vector)object).elementAt(n).toString();
                jCheckBox = new JCheckBox(string5);
                jCheckBox.addActionListener(this);
                jCheckBox.setActionCommand("breakpoints");
                this.userEpsActualPanel.add(jCheckBox);
            }
            this.userEpsActualPanel.updateUI();
            object = this.epItems.getSystemEps();
            n12 = ((Vector)object).size();
            for (n = 0; n < n12; ++n) {
                string5 = ((Vector)object).elementAt(n).toString();
                jCheckBox = new JCheckBox(string5);
                jCheckBox.addActionListener(this);
                jCheckBox.setActionCommand("breakpoints");
                this.sysEpsActualPanel.add(jCheckBox);
            }
            n2 = server.getListLength("charm/messages", 0);
            this.msgItems.load(server.getPList("charm/messages", 0, 0, n2));
            this.messageQueue.setLookups(this.epItems, this.msgItems, this.chareItems);
        }
        catch (Exception exception) {
            System.out.println("Error while starting the application (error: " + exception + ". Aborting...");
            process.destroy();
        }
        this.sysEpsActualPanel.updateUI();
        this.listsbox.setEnabled(true);
        this.pesbox.setEnabled(true);
        this.quitButton.setEnabled(true);
    }

    public void quitProgram() {
        gdb.terminate();
        portnumber = "";
        this.isRunning = false;
        if (sshTunnel != null) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sshTunnel.destroy();
            sshTunnel = null;
        }
        this.startButton.setEnabled(true);
        this.continueButton.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.freezeButton.setEnabled(false);
        this.startGdbButton.setEnabled(false);
        this.listModel.removeAllElements();
        this.outputArea.setList(null);
        this.listsbox.setEnabled(false);
        this.pesbox.removeAllItems();
        this.pesbox.setEnabled(false);
        this.peActualPanel.removeAll();
        this.peActualPanel.updateUI();
        this.userEpsActualPanel.removeAll();
        this.userEpsActualPanel.updateUI();
        this.sysEpsActualPanel.removeAll();
        this.sysEpsActualPanel.updateUI();
        this.setStatusMessage(new String("Ready to start new program"));
    }

    private String getInitialInfo() {
        Object object;
        String string = new File(this.getFilename()).getAbsolutePath();
        String string2 = "size -A " + string;
        String string3 = this.getHostname();
        if (!string3.equals("localhost")) {
            string2 = string3 + " " + string2;
            object = this.getUsername();
            if (!((String)object).equals("")) {
                string2 = "-l " + (String)object + " " + string2;
            }
            string2 = "ssh " + string2;
        }
        try {
            int n;
            object = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("Failed to start gdb info program");
            return "error";
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java ParDebug [[-file <charm program name>] [[-param \"<charm program parameters>\"][-pes <number of pes>]] [-host <hostname>] [-user <username>] [-port <port>] [-sshtunnel] [-display <display>]]");
    }

    String getFilename() {
        return filename;
    }

    String getHostname() {
        return hostname;
    }

    String getUsername() {
        return username;
    }

    public static void main(String[] stringArray) {
        int n;
        hostname = "localhost";
        username = "";
        filename = "";
        portnumber = "";
        numberPes = 1;
        String string = "1";
        clparams = "";
        envDisplay = "";
        tunnelNeeded = false;
        sshTunnel = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; n += 2) {
            if (stringArray[n].equals("-host")) {
                hostname = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-user")) {
                username = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-port")) {
                portnumber = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-file")) {
                filename = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-param")) {
                clparams = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-pes") || stringArray[n].equals("+p")) {
                string = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-display")) {
                envDisplay = stringArray[n + 1];
                continue;
            }
            if (stringArray[n].equals("-sshtunnel")) {
                tunnelNeeded = true;
                --n;
                continue;
            }
            if (stringArray[n].startsWith("+p")) {
                string = stringArray[n].substring(2);
            } else if (!bl) {
                if (stringArray[n].startsWith("-") || stringArray[n].startsWith("+")) {
                    ParDebug.printUsage();
                    System.exit(1);
                } else {
                    filename = stringArray[n];
                    bl = true;
                }
            } else {
                clparams = clparams + " " + stringArray[n];
            }
            --n;
        }
        if (n > stringArray.length) {
            ParDebug.printUsage();
            System.exit(1);
        }
        ParDebug.setNumberPes(string);
        appFrame = new JFrame("Charm Parallel Debugger");
        appFrame.setSize(1000, 1000);
        final ParDebug parDebug = new ParDebug();
        appFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (parDebug.isRunning) {
                    server.bcastCcsRequest("ccs_debug_quit", "", -1, numberPes, null);
                    parDebug.quitProgram();
                }
                System.exit(0);
            }
        });
        appFrame.getContentPane().add((Component)parDebug, "Center");
        Rectangle rectangle = appFrame.getGraphicsConfiguration().getBounds();
        appFrame.setLocation(50 + rectangle.x, 50 + rectangle.y);
        appFrame.setJMenuBar(parDebug.menuBar);
        appFrame.pack();
        appFrame.setVisible(true);
    }

    static {
        appFrame = null;
    }

    private class CpdListInfo {
        public String display;
        public String name;
        public String detailedName;
        public GenericPList list;

        public CpdListInfo(String string, String string2) {
            this.display = string;
            this.name = string2;
            this.detailedName = null;
            this.list = null;
        }

        public CpdListInfo(String string, String string2, String string3, GenericPList genericPList) {
            this.display = string;
            this.name = string2;
            this.detailedName = string3;
            this.list = genericPList;
        }
    }
}

