/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class PrimitiveType
extends GenericType {
    public PrimitiveType(String string) {
        this.name = string;
    }

    public GenericType build(String string, String string2) {
        return this;
    }

    public int getSize() {
        if (this.name.equals("bool")) {
            return Inspector.getBoolSize();
        }
        if (this.name.equals("long long") || this.name.equals("unsigned long long")) {
            return Inspector.getLongLongSize();
        }
        if (this.name.equals("long") || this.name.equals("unsigned long")) {
            return Inspector.getLongSize();
        }
        if (this.name.equals("int") || this.name.equals("unsigned int")) {
            return Inspector.getIntSize();
        }
        if (this.name.equals("short") || this.name.equals("unsigned short")) {
            return 2;
        }
        if (this.name.equals("char") || this.name.equals("unsigned char")) {
            return 1;
        }
        if (this.name.equals("float")) {
            return 4;
        }
        if (this.name.equals("double")) {
            return 8;
        }
        return 0;
    }

    public String toString(String string) {
        return this.name;
    }

    public String memoryToString(String string, ByteBuffer byteBuffer, int n) {
        String string2;
        long l;
        if (n < 0) {
            return "?";
        }
        if (this.name.equals("float")) {
            return Float.toString(byteBuffer.getFloat(n));
        }
        if (this.name.equals("double")) {
            return Double.toString(byteBuffer.getDouble(n));
        }
        int n2 = this.getSize();
        switch (n2) {
            case 1: {
                byte by = byteBuffer.get(n);
                l = by;
                string2 = Byte.toString(by);
                break;
            }
            case 2: {
                short s = byteBuffer.getShort(n);
                l = s;
                string2 = Short.toString(s);
                break;
            }
            case 4: {
                int n3 = byteBuffer.getInt(n);
                l = n3;
                string2 = Integer.toString(n3);
                break;
            }
            case 8: {
                l = byteBuffer.getLong(n);
                string2 = Long.toString(l);
                break;
            }
            default: {
                return "???";
            }
        }
        if (this.name.equals("bool")) {
            return l != 0L ? "true" : "false";
        }
        return string2;
    }

    public String getValue(TypeVisitor typeVisitor) {
        String string;
        long l;
        if (this.name.equals("float")) {
            return Float.toString(typeVisitor.getFloat());
        }
        if (this.name.equals("double")) {
            return Double.toString(typeVisitor.getDouble());
        }
        int n = this.getSize();
        switch (n) {
            case 1: {
                l = typeVisitor.getByte();
                string = Byte.toString(typeVisitor.getByte());
                break;
            }
            case 2: {
                l = typeVisitor.getShort();
                string = Short.toString(typeVisitor.getShort());
                break;
            }
            case 4: {
                l = typeVisitor.getInteger();
                string = Integer.toString(typeVisitor.getInteger());
                break;
            }
            case 8: {
                l = typeVisitor.getLong();
                string = Long.toString(typeVisitor.getLong());
                break;
            }
            default: {
                return "???";
            }
        }
        if (this.name.equals("bool")) {
            return l != 0L ? "true" : "false";
        }
        return string;
    }

    public void visit(TypeVisitor typeVisitor) {
        if (typeVisitor.isValid()) {
            String string = null;
            if (this.name.equals("float")) {
                string = Float.toString(typeVisitor.getFloat());
            }
            if (this.name.equals("double")) {
                string = Double.toString(typeVisitor.getDouble());
            }
            int n = this.getSize();
            long l = 0L;
            switch (n) {
                case 1: {
                    l = typeVisitor.getByte();
                    string = Byte.toString(typeVisitor.getByte());
                    break;
                }
                case 2: {
                    l = typeVisitor.getShort();
                    string = Short.toString(typeVisitor.getShort());
                    break;
                }
                case 4: {
                    l = typeVisitor.getInteger();
                    string = Integer.toString(typeVisitor.getInteger());
                    break;
                }
                case 8: {
                    l = typeVisitor.getLong();
                    string = Long.toString(typeVisitor.getLong());
                    break;
                }
                default: {
                    string = "???";
                }
            }
            if (this.name.equals("bool")) {
                string = l != 0L ? "true" : "false";
            }
            typeVisitor.addValue(string);
        } else {
            typeVisitor.addValue("?");
        }
    }
}

