/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.AllocationPoint;
import charm.debug.MemoryLog;
import charm.debug.ParDebug;
import charm.debug.inspect.Inspector;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class AllocationTreePanel
extends JPanel {
    private JScrollPane scroll;
    private AllocationPoint root;
    private ByteBuffer buf;
    private JTree tree;

    public AllocationTreePanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 500));
        this.scroll = new JScrollPane();
        this.add(this.scroll);
    }

    public void loadTree(JFrame jFrame) {
        int n;
        String string = JOptionPane.showInputDialog("Processor to load (-1 for all)");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n == -1) {
            jFrame.setTitle("Combined Allocation Tree");
        } else {
            jFrame.setTitle("Allocation Tree Processor " + string);
        }
        if (n == -1) {
            n = 0;
        }
        byte[] byArray = ParDebug.server.sendCcsRequestBytes("ccs_debug_allocationTree", string, n);
        this.buf = ByteBuffer.wrap(byArray).order(Inspector.getByteOrder());
        this.root = new AllocationPoint(null);
        this.root.readPuppedBuffer(this.buf);
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.scroll.setViewportView(this.tree);
    }

    public void loadMemoryLogs(List list, boolean bl) {
        this.root = new AllocationPoint(null);
        Hashtable<MemoryLog, MemoryLog> hashtable = new Hashtable<MemoryLog, MemoryLog>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MemoryLog memoryLog = (MemoryLog)iterator.next();
                if (bl && memoryLog.getLocation() == 0L) {
                    this.root = new AllocationPoint(null);
                    hashtable.clear();
                    this.root.addMemoryLog(memoryLog, -1);
                    this.root.getChildWithLocation((long)0L).size = memoryLog.getSizeAfter();
                    continue;
                }
                if (memoryLog.getSize() > 0) {
                    this.root.addMemoryLog(memoryLog, -1);
                    if (!bl) continue;
                    hashtable.put(memoryLog, memoryLog);
                    continue;
                }
                if (memoryLog.getSize() >= 0 || !bl) continue;
                MemoryLog memoryLog2 = (MemoryLog)hashtable.remove(memoryLog);
                if (memoryLog2 != null) {
                    this.root.removeMemoryLog(memoryLog2, -1);
                    continue;
                }
                this.root.removeMemoryLog(memoryLog, -1);
            }
        }
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(20);
        this.scroll.setViewportView(this.tree);
        for (int i = 0; i < 10; ++i) {
            this.tree.expandRow(i);
        }
    }
}

