/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.Symbol;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.Slot;
import java.util.Collections;
import java.util.Vector;

public class MemoryPList {
    private Vector slots = new Vector();
    private Vector names = new Vector();
    public static final int HOLE_SIZE = 0x3200000;

    public int addRow(String string) {
        this.names.add(string);
        this.slots.add(new Vector());
        return this.slots.size() - 1;
    }

    public int addElement(int n, Slot slot) {
        Vector vector = (Vector)this.slots.elementAt(n);
        vector.add(slot);
        return vector.size() - 1;
    }

    public int size() {
        return this.slots.size();
    }

    public int size(int n) {
        return ((Vector)this.slots.elementAt(n)).size();
    }

    public String getName(int n) {
        return (String)this.names.elementAt(n);
    }

    public Slot elementAt(int n, int n2) {
        return (Slot)((Vector)this.slots.elementAt(n)).elementAt(n2);
    }

    public void sort() {
        for (int i = 0; i < this.names.size(); ++i) {
            Collections.sort((Vector)this.slots.elementAt(i));
        }
    }

    public Hole[] findHoles() {
        Vector<Hole> vector = new Vector<Hole>();
        Hole hole = new Hole(0L, 0L);
        vector.add(hole);
        MemoryIterator memoryIterator = new MemoryIterator(this);
        Slot slot = memoryIterator.getNext();
        Slot slot2 = memoryIterator.getNext();
        while (slot2 != null) {
            long l = slot2.getLocation() - (slot.getLocation() + (long)slot.getSize());
            if (l > 0x3200000L) {
                vector.add(new Hole(slot.getLocation() + (long)slot.getSize(), l));
                ++hole.position;
                hole.size += l;
            }
            slot = slot2;
            slot2 = memoryIterator.getNext();
        }
        Hole[] holeArray = new Hole[(int)hole.position + 1];
        holeArray = vector.toArray(holeArray);
        return holeArray;
    }

    public boolean needRefresh() {
        return true;
    }

    public void load(PList pList) {
        this.slots.clear();
        this.names.clear();
        if (pList == null) {
            System.out.println("list is null!");
        }
        for (PAbstract pAbstract = pList.elementAt(0); pAbstract != null; pAbstract = pAbstract.getNext()) {
            PList pList2 = (PList)pAbstract;
            PString pString = (PString)pList2.elementNamed("name");
            int n = this.addRow(pString.getString());
            PList pList3 = (PList)pList2.elementNamed("slots");
            for (PAbstract pAbstract2 = pList3.elementAt(0); pAbstract2 != null; pAbstract2 = pAbstract2.getNext()) {
                int n2;
                PList pList4 = (PList)pAbstract2;
                Slot slot = Inspector.is64bit() ? new Slot(((PNative)pList4.elementNamed("loc")).getLongValue(0)) : new Slot(((PNative)pList4.elementNamed("loc")).getIntValue(0));
                slot.setSize(((PNative)pList4.elementNamed("size")).getIntValue(0));
                int n3 = ((PNative)pList4.elementNamed("flags")).getIntValue(0);
                System.out.println("Found " + slot);
                if ((n3 & 8) != 0) {
                    slot.setLeak(true);
                }
                PNative pNative = (PNative)pList4.elementNamed("stack");
                for (n2 = 0; n2 < pNative.length(); ++n2) {
                    long l = Inspector.is64bit() ? pNative.getLongValue(n2) : (long)pNative.getIntValue(n2);
                    Symbol symbol = Symbol.get(l);
                    slot.addTrace(symbol);
                }
                slot.setType(((PNative)pList4.elementNamed("flags")).getIntValue(0) & 7);
                n2 = this.addElement(n, slot);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Lists:\n");
        for (int i = 0; i < this.names.size(); ++i) {
            stringBuffer.append(this.getName(i) + " {\n");
            for (int j = 0; j < this.size(i); ++j) {
                stringBuffer.append("\tloc=0x" + Long.toHexString(this.elementAt(i, j).getLocation()) + ", size=" + this.elementAt(i, j).getSize() + ", trace: {\n\t\t");
                for (int k = 0; k < this.elementAt(i, j).getTraceSize(); ++k) {
                    if (k > 0) {
                        stringBuffer.append(",\n\t\t");
                    }
                    stringBuffer.append((Symbol)this.elementAt(i, j).getTrace(k));
                }
                stringBuffer.append("\t}\n");
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        for (int i = 0; i < this.names.size(); ++i) {
            System.out.println("List " + this.getName(i));
        }
        return true;
    }

    public class MemoryIterator {
        private Vector heads;
        private MemoryPList source;

        public MemoryIterator(MemoryPList memoryPList2) {
            this.source = memoryPList2;
            this.heads = new Vector(memoryPList2.size());
            for (int i = 0; i < memoryPList2.size(); ++i) {
                if (memoryPList2.size(i) == 0) continue;
                this.add(new Holder(i, 0, memoryPList2.elementAt(i, 0)));
            }
        }

        private void add(Holder holder) {
            int n;
            for (n = 0; n < this.heads.size() && holder.slot.getLocation() >= ((Holder)this.heads.elementAt((int)n)).slot.getLocation(); ++n) {
            }
            this.heads.add(n, holder);
        }

        public Slot getNext() {
            if (this.heads.size() == 0) {
                return null;
            }
            Holder holder = (Holder)this.heads.elementAt(0);
            this.heads.remove(0);
            int n = holder.position + 1;
            if (n < this.source.size(holder.type)) {
                this.add(new Holder(holder.type, n, this.source.elementAt(holder.type, n)));
            }
            return holder.slot;
        }

        private class Holder {
            int type;
            int position;
            Slot slot;

            Holder(int n, int n2, Slot slot) {
                this.type = n;
                this.position = n2;
                this.slot = slot;
            }
        }
    }

    public class Hole {
        long position;
        long size;

        public Hole() {
            this.position = 0L;
            this.size = 0L;
        }

        public Hole(long l, long l2) {
            this.position = l;
            this.size = l2;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }
    }
}

