/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class CallGraph
extends ProjDefs {
    int myRun = 0;
    private int numPe;
    private int numEPs;
    private double[][] messageArray;
    private double[][] byteArray;
    private double[][] externalMessageArray;
    private double[][] externalByteArray;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;

    public CallGraph(int startInterval, int endInterval, long intervalSize, OrderedIntList processorList) {
        this.peList = processorList;
        this.numPe = this.peList.size();
        this.numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.startTime = (long)startInterval * intervalSize;
        this.endTime = (long)endInterval * intervalSize;
        this.messageArray = new double[endInterval - startInterval + 1][this.numEPs * 2];
        this.byteArray = new double[endInterval - startInterval + 1][this.numEPs * 2];
        this.externalMessageArray = new double[endInterval - startInterval + 1][this.numEPs * 2];
        this.externalByteArray = new double[endInterval - startInterval + 1][this.numEPs * 2];
    }

    public void GatherData(Component parent) {
        LogEntryData logdata = new LogEntryData();
        int currPeArrayIndex = 0;
        ProgressMonitor progressBar = new ProgressMonitor(parent, "Reading log files", "", 0, this.numPe);
        while (this.peList.hasMoreElements()) {
            int currPe = this.peList.nextElement();
            if (progressBar.isCanceled()) {
                progressBar.close();
                break;
            }
            progressBar.setNote("[PE: " + currPe + "] Reading data.");
            progressBar.setProgress(currPeArrayIndex + 1);
            GenericLogReader LogFile = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(currPe), MainWindow.runObject[this.myRun].getVersion());
            try {
                LogFile.nextEventOnOrAfter(this.startTime, logdata);
                while (logdata.time < this.endTime) {
                    int currTimeInterval;
                    int destEP;
                    if (logdata.type == 1) {
                        destEP = logdata.entry;
                        currTimeInterval = this.getInterval(logdata.time);
                        double[] dArray = this.messageArray[currTimeInterval];
                        int n = destEP;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray2 = this.byteArray[currTimeInterval];
                        int n2 = destEP;
                        dArray2[n2] = dArray2[n2] + (double)logdata.msglen;
                    } else if (logdata.type == 20 || logdata.type == 21) {
                        destEP = logdata.entry;
                        currTimeInterval = this.getInterval(logdata.time);
                        double[] dArray = this.messageArray[currTimeInterval];
                        int n = destEP;
                        dArray[n] = dArray[n] + (double)logdata.numPEs;
                        double[] dArray3 = this.byteArray[currTimeInterval];
                        int n3 = destEP;
                        dArray3[n3] = dArray3[n3] + (double)(logdata.msglen * logdata.numPEs);
                    } else if (logdata.type == 2) {
                        int currEP = logdata.entry;
                        int srcPe = logdata.pe;
                        int currTimeInterval2 = this.getInterval(logdata.time);
                        double[] dArray = this.messageArray[currTimeInterval2];
                        int n = currEP + this.numEPs;
                        dArray[n] = dArray[n] + 1.0;
                        double[] dArray4 = this.byteArray[currTimeInterval2];
                        int n4 = currEP + this.numEPs;
                        dArray4[n4] = dArray4[n4] + (double)logdata.msglen;
                        if (currPe != srcPe) {
                            double[] dArray5 = this.externalMessageArray[currTimeInterval2];
                            int n5 = currEP + this.numEPs;
                            dArray5[n5] = dArray5[n5] + 1.0;
                            double[] dArray6 = this.externalByteArray[currTimeInterval2];
                            int n6 = currEP + this.numEPs;
                            dArray6[n6] = dArray6[n6] + (double)logdata.msglen;
                        }
                    }
                    LogFile.nextEvent(logdata);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            ++currPeArrayIndex;
        }
        progressBar.close();
    }

    public double[][] getMessageArray() {
        return this.messageArray;
    }

    public double[][] getByteArray() {
        return this.byteArray;
    }

    public double[][] getExternalMessageArray() {
        return this.externalMessageArray;
    }

    public double[][] getExternalByteArray() {
        return this.externalByteArray;
    }

    private int getInterval(long currTime) {
        float x = currTime - this.startTime;
        return (int)((x /= (float)(this.endTime - this.startTime)) * (float)this.messageArray.length);
    }
}

