/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.LogIndex;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.ProjDefs;
import projections.analysis.TimelineEvent;
import projections.analysis.ViewerEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.Timeline.UserEventObject;
import projections.misc.LogEntryData;
import projections.misc.LogLoadException;

public class LogLoader
extends ProjDefs {
    int myRun = 0;
    private boolean isProcessing = false;
    boolean ampiTraceOn = false;
    public final boolean useTimeIndexes = false;
    private LogIndex index;

    public long determineEndTime(OrderedIntList validPEs) {
        long BeginTime = 0L;
        long EndTime = Integer.MIN_VALUE;
        int nPe = validPEs.size();
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Determining end time", "", 0, nPe);
        validPEs.reset();
        int count = 1;
        while (validPEs.hasMoreElements()) {
            int pe = validPEs.nextElement();
            if (!progressBar.isCanceled()) {
                progressBar.setNote("[" + pe + "] " + count + " of " + nPe + " files");
                progressBar.setProgress(count);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper end time!");
                System.exit(-1);
            }
            ++count;
            long lastRecordedTime = 0L;
            int dummyInt = 0;
            int type = 0;
            try {
                RandomAccessFile InFile = new RandomAccessFile(new File(MainWindow.runObject[this.myRun].getLogName(pe)), "r");
                long back = InFile.length() - 240L;
                if (back < 0L) {
                    back = 0L;
                }
                InFile.seek(back);
                while (InFile.readByte() != 10) {
                }
                while (true) {
                    String Line;
                    if ((Line = InFile.readLine()) == null) {
                        throw new EOFException();
                    }
                    StringTokenizer st = new StringTokenizer(Line);
                    type = Integer.parseInt(st.nextToken());
                    if (type == 7) {
                        long Time2 = Long.parseLong(st.nextToken());
                        if (Time2 <= EndTime) break;
                        EndTime = Time2;
                        break;
                    }
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 20: 
                        case 21: {
                            dummyInt = Integer.parseInt(st.nextToken());
                            dummyInt = Integer.parseInt(st.nextToken());
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 13: 
                        case 26: 
                        case 100: {
                            dummyInt = Integer.parseInt(st.nextToken());
                            break;
                        }
                    }
                    lastRecordedTime = Long.parseLong(st.nextToken());
                }
                InFile.close();
            }
            catch (EOFException e) {
                System.err.println("[" + pe + "] " + "WARNING: Partial Log: Faking End " + "Time determination at last recorded " + "time of " + lastRecordedTime);
                if (lastRecordedTime <= EndTime) continue;
                EndTime = lastRecordedTime;
            }
            catch (IOException E) {
                System.err.println("Couldn't read log file " + MainWindow.runObject[this.myRun].getLogName(pe));
            }
        }
        progressBar.close();
        return EndTime - BeginTime;
    }

    public void createAMPIUsageProfile(int procId, long beginTime, long endTime, Vector procThdVec) throws LogLoadException {
        GenericLogReader logFileRd = null;
        LogEntryData rawLogData = null;
        LogEntry curEntry = null;
        LogEntry prevEntry = null;
        AmpiProcessProfile curProcessing = null;
        Hashtable<Object, AmpiProcessProfile> procThdMap = new Hashtable<Object, AmpiProcessProfile>();
        try {
            logFileRd = new GenericLogReader(procId, MainWindow.runObject[this.myRun].getVersion());
            rawLogData = new LogEntryData();
            do {
                logFileRd.nextEvent(rawLogData);
                curEntry = LogEntry.adapt(rawLogData);
            } while (curEntry.TransactionType != 2 || curEntry.Entry == -1 || curEntry.Time < beginTime);
            curProcessing = new AmpiProcessProfile(curEntry.Time, curEntry.id);
            prevEntry = curEntry;
            boolean reachEndTime = false;
            while (!reachEndTime) {
                logFileRd.nextEvent(rawLogData);
                curEntry = LogEntry.adapt(rawLogData);
                if (curEntry.Entry == -1) continue;
                switch (curEntry.TransactionType) {
                    case 2: {
                        if (curProcessing != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        AmpiProcessProfile tmp = new AmpiProcessProfile(curEntry.Time, curEntry.id);
                        AmpiProcessProfile storedProfile = (AmpiProcessProfile)procThdMap.get(tmp.toHashKey());
                        curProcessing = storedProfile == null ? tmp : storedProfile;
                        break;
                    }
                    case 3: {
                        AmpiFunctionData curFunc;
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (!curProcessing.getAuxCallFuncStack().empty()) {
                            curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                            curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        }
                        if (procThdMap.get(curProcessing.toHashKey()) == null) {
                            procThdMap.put(curProcessing.toHashKey(), curProcessing);
                        }
                        curProcessing = null;
                        if (curEntry.Time < endTime) break;
                        reachEndTime = true;
                        break;
                    }
                    case 22: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData curFunc = curEntry.ampiData;
                        Stack auxStk = curProcessing.getAuxCallFuncStack();
                        auxStk.push(curFunc);
                        break;
                    }
                    case 23: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (curProcessing.getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        if (curFunc.FunctionID != curEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curProcessing.getAuxCallFuncStack().pop();
                        curProcessing.getFinalCallFuncStack().push(curFunc);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (curProcessing == null) break;
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (curProcessing.getAuxCallFuncStack().empty()) break;
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        break;
                    }
                }
                prevEntry = curEntry;
            }
        }
        catch (EOFException reachEndTime) {
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(procId));
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(procId), 1);
        }
        Enumeration e = procThdMap.keys();
        while (e.hasMoreElements()) {
            AmpiProcessProfile p = (AmpiProcessProfile)procThdMap.get(e.nextElement());
            if (p.getFinalCallFuncStack().size() <= 0) continue;
            procThdVec.add(p);
        }
    }

    public void createAMPIFuncTimeProfile(int procId, long beginTime, long endTime, Vector procThdVec) throws LogLoadException {
        GenericLogReader logFileRd = null;
        LogEntryData rawLogData = null;
        LogEntry curEntry = null;
        LogEntry prevEntry = null;
        AmpiProcessProfile curProcessing = null;
        Hashtable<Object, AmpiProcessProfile> procThdMap = new Hashtable<Object, AmpiProcessProfile>();
        try {
            logFileRd = new GenericLogReader(procId, MainWindow.runObject[this.myRun].getVersion());
            rawLogData = new LogEntryData();
            do {
                logFileRd.nextEvent(rawLogData);
                curEntry = LogEntry.adapt(rawLogData);
            } while (curEntry.TransactionType != 2 || curEntry.Entry == -1 || curEntry.Time < beginTime);
            curProcessing = new AmpiProcessProfile(curEntry.Time, curEntry.id);
            prevEntry = curEntry;
            boolean reachEndTime = false;
            while (!reachEndTime) {
                logFileRd.nextEvent(rawLogData);
                curEntry = LogEntry.adapt(rawLogData);
                if (curEntry.Entry == -1) continue;
                switch (curEntry.TransactionType) {
                    case 2: {
                        if (curProcessing != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        AmpiProcessProfile tmp = new AmpiProcessProfile(curEntry.Time, curEntry.id);
                        AmpiProcessProfile storedProfile = (AmpiProcessProfile)procThdMap.get(tmp.toHashKey());
                        curProcessing = storedProfile == null ? tmp : storedProfile;
                        break;
                    }
                    case 3: {
                        AmpiFunctionData.AmpiFuncExecInterval gap;
                        AmpiFunctionData curFunc;
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (!curProcessing.getAuxCallFuncStack().empty()) {
                            curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                            gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                            curFunc.insertExecInterval(gap);
                            curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        }
                        if (procThdMap.get(curProcessing.toHashKey()) == null) {
                            procThdMap.put(curProcessing.toHashKey(), curProcessing);
                        }
                        curProcessing = null;
                        if (curEntry.Time < endTime) break;
                        reachEndTime = true;
                        break;
                    }
                    case 22: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData curFunc = curEntry.ampiData;
                        Stack auxStk = curProcessing.getAuxCallFuncStack();
                        auxStk.push(curFunc);
                        break;
                    }
                    case 23: {
                        if (curProcessing == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (curProcessing.getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        if (curFunc.FunctionID != curEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        AmpiFunctionData.AmpiFuncExecInterval gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                        curFunc.insertExecInterval(gap);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        curProcessing.getAuxCallFuncStack().pop();
                        curProcessing.getFinalCallFuncStack().push(curFunc);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (curProcessing == null) break;
                        curProcessing.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        if (curProcessing.getAuxCallFuncStack().empty()) break;
                        AmpiFunctionData curFunc = (AmpiFunctionData)curProcessing.getAuxCallFuncStack().peek();
                        AmpiFunctionData.AmpiFuncExecInterval gap = new AmpiFunctionData.AmpiFuncExecInterval(prevEntry.Time, curEntry.Time);
                        curFunc.insertExecInterval(gap);
                        curFunc.incrAccExecTime(curEntry.Time - prevEntry.Time);
                        break;
                    }
                }
                prevEntry = curEntry;
            }
        }
        catch (EOFException reachEndTime) {
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(procId));
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(procId), 1);
        }
        Enumeration e = procThdMap.keys();
        while (e.hasMoreElements()) {
            AmpiProcessProfile p = (AmpiProcessProfile)procThdMap.get(e.nextElement());
            if (p.getFinalCallFuncStack().size() <= 0) continue;
            procThdVec.add(p);
        }
    }

    public Vector createtimeline(int PeNum, long Begin, long End, Vector Timeline, Vector userEventVector) throws LogLoadException {
        long BeginTime = 0L;
        long Time2 = Long.MIN_VALUE;
        LogEntry LE = null;
        TimelineEvent TE = null;
        UserEventObject userEventObject = null;
        TimelineMessage TM = null;
        PackTime PT = null;
        System.gc();
        try {
            GenericLogReader reader = new GenericLogReader(PeNum, MainWindow.runObject[this.myRun].getVersion());
            LogEntryData data = new LogEntryData();
            if (MainWindow.runObject[this.myRun].getNumFunctionEvents() > 0) {
                this.ampiTraceOn = true;
            }
            this.isProcessing = false;
            LogEntry lastBeginEvent = null;
            TimelineEvent lastBeginTimelineEvent = null;
            while (true) {
                reader.nextEvent(data);
                LE = LogEntry.adapt(data);
                if (LE.Time >= Begin) break;
                if (LE.Entry == -1) continue;
                if (LE.TransactionType == 2 && LE.Entry != -1) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = LE;
                    continue;
                }
                if (LE.TransactionType == 3 && LE.Entry != -1) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = null;
                    continue;
                }
                if (LE.TransactionType == 14) {
                    Time2 = LE.Time - BeginTime;
                    lastBeginEvent = LE;
                    continue;
                }
                if (LE.TransactionType != 15) continue;
                lastBeginEvent = null;
            }
            if (Time2 == Long.MIN_VALUE) {
                Time2 = Begin;
            }
            if (LE.Time > End) {
                switch (LE.TransactionType) {
                    case 2: {
                        System.out.println("finished empty timeline for " + PeNum);
                        return Timeline;
                    }
                    case 3: {
                        if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2 && lastBeginEvent.Entry == LE.Entry) {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                            Timeline.addElement(TE);
                        }
                        return Timeline;
                    }
                    case 14: {
                        System.out.println("finished empty timeline for " + PeNum);
                        return Timeline;
                    }
                    case 15: {
                        if (lastBeginEvent != null && lastBeginEvent.TransactionType == 14) {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, -1, -1);
                            Timeline.addElement(TE);
                        }
                        return Timeline;
                    }
                }
                if (lastBeginEvent != null) {
                    switch (lastBeginEvent.TransactionType) {
                        case 2: {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                            Timeline.addElement(TE);
                            break;
                        }
                        case 14: {
                            TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, -1, -1);
                            Timeline.addElement(TE);
                        }
                    }
                } else {
                    System.out.println("finished empty timeline for " + PeNum);
                }
                return Timeline;
            }
            CallStackManager cstack = new CallStackManager();
            LogEntry enclosingDummy = null;
            ObjectId tid = null;
            AmpiFunctionData ampiData = null;
            block31: while (true) {
                if (LE.Entry != -1) {
                    switch (LE.TransactionType) {
                        case 22: {
                            lastBeginEvent = null;
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                            }
                            TE = new TimelineEvent();
                            TE.isFunction = true;
                            TE.BeginTime = LE.Time - BeginTime;
                            TE.EntryPoint = LE.FunctionID;
                            TE.EventID = -1;
                            TE.id = enclosingDummy.id;
                            cstack.push(LE.ampiData, TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            Timeline.addElement(TE);
                            break;
                        }
                        case 23: {
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                cstack.pop(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            }
                            TE = null;
                            tid = enclosingDummy.id;
                            ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                            if (ampiData == null || ampiData.FunctionID == 0) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, enclosingDummy.Entry, enclosingDummy.Pe, enclosingDummy.MsgLen, enclosingDummy.recvTime, enclosingDummy.id, -1, enclosingDummy.cpuBegin, enclosingDummy.cpuEnd, enclosingDummy.numPapiCounts, enclosingDummy.papiCounts);
                                Timeline.addElement(TE);
                                break;
                            }
                            TE = new TimelineEvent();
                            TE.isFunction = true;
                            TE.BeginTime = LE.Time - BeginTime;
                            TE.EntryPoint = ampiData.FunctionID;
                            TE.EventID = -1;
                            TE.id = tid;
                            TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                            Timeline.addElement(TE);
                            break;
                        }
                        case 2: {
                            lastBeginEvent = null;
                            if (this.isProcessing) {
                                if (TE != null) {
                                    TE.EndTime = LE.Time - BeginTime;
                                }
                                TE = null;
                            }
                            this.isProcessing = true;
                            if (this.ampiTraceOn && LE.Entry == 0) {
                                enclosingDummy = LE;
                                tid = enclosingDummy.id;
                                ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                                if (ampiData != null && ampiData.FunctionID != 0) {
                                    TE = new TimelineEvent();
                                    TE.isFunction = true;
                                    TE.BeginTime = LE.Time - BeginTime;
                                    TE.EntryPoint = ampiData.FunctionID;
                                    TE.SrcPe = enclosingDummy.Pe;
                                    TE.EventID = enclosingDummy.EventID;
                                    TE.MsgLen = enclosingDummy.MsgLen;
                                    TE.RecvTime = enclosingDummy.recvTime;
                                    TE.id = tid;
                                    TE.callStack = cstack.getStack(TE.id.id[0], TE.id.id[1], TE.id.id[2]);
                                    Timeline.addElement(TE);
                                    break;
                                }
                            }
                            TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, LE.Entry, LE.Pe, LE.MsgLen, LE.recvTime, LE.id, LE.EventID, LE.cpuBegin, LE.cpuEnd, LE.numPapiCounts, LE.papiCounts);
                            Timeline.addElement(TE);
                            lastBeginTimelineEvent = TE;
                            break;
                        }
                        case 3: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2 && lastBeginEvent.Entry == LE.Entry) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, LE.Time - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline.addElement(TE);
                                TE = null;
                                this.isProcessing = false;
                                break;
                            }
                            lastBeginEvent = null;
                            if (this.ampiTraceOn && LE.Entry == 0) {
                                tid = enclosingDummy.id;
                                ampiData = (AmpiFunctionData)cstack.read(tid.id[0], tid.id[1], tid.id[2]);
                                if (ampiData != null && ampiData.FunctionID != 0) {
                                    if (TE != null) {
                                        TE.EndTime = LE.Time - BeginTime;
                                    }
                                    TE = null;
                                    enclosingDummy = null;
                                    break;
                                }
                            }
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                                TE.cpuEnd = LE.cpuEnd;
                                int i = 0;
                                while (i < LE.numPapiCounts) {
                                    TE.papiCounts[i] = LE.papiCounts[i] - TE.papiCounts[i];
                                    ++i;
                                }
                            }
                            TE = null;
                            this.isProcessing = false;
                            break;
                        }
                        case 26: {
                            lastBeginTimelineEvent.UserSpecifiedData = LE.userSuppliedValue();
                            break;
                        }
                        case 1: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline.addElement(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline.addElement(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(PeNum, TE.EventID, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 20: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline.addElement(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline.addElement(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(PeNum, TE.EventID, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID, LE.numPEs);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 21: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline.addElement(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            boolean tempte = false;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe, LE.MsgLen);
                                Timeline.addElement(TE);
                                tempte = true;
                            }
                            TM = new TimelineMessage(PeNum, TE.EventID, LE.Time - BeginTime, LE.Entry, LE.MsgLen, LE.EventID, LE.destPEs);
                            TE.addMessage(TM);
                            if (!tempte) break;
                            TE = null;
                            break;
                        }
                        case 13: {
                            UserEventObject event = new UserEventObject(LE.Time - BeginTime, LE.Entry, LE.EventID, 1);
                            userEventVector.addElement(event);
                            break;
                        }
                        case 100: {
                            userEventObject = new UserEventObject(LE.Time - BeginTime, LE.Entry, LE.EventID, 2);
                            userEventObject.EndTime = End;
                            reader.nextEvent(data);
                            LE = LogEntry.adapt(data);
                            if (LE.TransactionType != 100) {
                                userEventObject = null;
                                continue block31;
                            }
                            if (userEventObject.CharmEventID != LE.EventID || userEventObject.UserEventID != LE.Entry) {
                                userEventObject = null;
                                continue block31;
                            }
                            userEventObject.EndTime = LE.Time - BeginTime;
                            userEventVector.addElement(userEventObject);
                            if (Timeline.isEmpty()) break;
                            TimelineEvent curLastOne = (TimelineEvent)Timeline.lastElement();
                            long tleBeginTime = curLastOne.BeginTime;
                            if (tleBeginTime > userEventObject.BeginTime || userEventObject.BeginTime - tleBeginTime > 3L) break;
                            curLastOne.userEventName = userEventObject.Name;
                            break;
                        }
                        case 16: {
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 2) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, lastBeginEvent.Entry, lastBeginEvent.Pe);
                                Timeline.addElement(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            if (TE == null) {
                                TE = new TimelineEvent(LE.Time - BeginTime, LE.Time - BeginTime, -2, LE.Pe);
                                Timeline.addElement(TE);
                            }
                            PT = new PackTime(LE.Time - BeginTime);
                            TE.addPack(PT);
                            break;
                        }
                        case 17: {
                            if (PT != null) {
                                PT.EndTime = LE.Time - BeginTime;
                            }
                            PT = null;
                            if (TE == null || TE.EntryPoint != -2) break;
                            TE = null;
                            break;
                        }
                        case 14: {
                            lastBeginEvent = null;
                            if (MainWindow.IGNORE_IDLE) break;
                            TE = new TimelineEvent(LE.Time - BeginTime, Long.MAX_VALUE, -1, -1);
                            Timeline.addElement(TE);
                            break;
                        }
                        case 15: {
                            if (MainWindow.IGNORE_IDLE) break;
                            if (lastBeginEvent != null && lastBeginEvent.TransactionType == 14) {
                                TE = new TimelineEvent(lastBeginEvent.Time - BeginTime, End - BeginTime, -1, -1);
                                Timeline.addElement(TE);
                                this.isProcessing = true;
                            }
                            lastBeginEvent = null;
                            if (TE != null) {
                                TE.EndTime = LE.Time - BeginTime;
                            }
                            TE = null;
                        }
                    }
                }
                reader.nextEvent(data);
                LE = LogEntry.adapt(data);
                if (LE.Entry != -1 && LE.Time - BeginTime > End) break;
            }
            while (TE != null) {
                if (LE.Entry != -1 && LE.TransactionType == 3) {
                    TE.EndTime = LE.Time - BeginTime;
                    TE = null;
                }
                reader.nextEvent(data);
                LE = LogEntry.adapt(data);
            }
        }
        catch (EOFException lastBeginEvent) {
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(PeNum));
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(PeNum), 1);
        }
        return Timeline;
    }

    private ViewerEvent entrytotext(LogEntry LE) {
        long BeginTime = 0L;
        ViewerEvent VE = new ViewerEvent();
        VE.Time = LE.Time - BeginTime;
        VE.EventType = LE.TransactionType;
        VE.numDestPEs = LE.numPEs;
        if (LE.Entry == -1) {
            return null;
        }
        switch (LE.TransactionType) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return VE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 21: {
                String[][] e2desc = MainWindow.runObject[this.myRun].getEntryNames();
                VE.Dest = new String(String.valueOf(e2desc[LE.Entry][1]) + "::" + e2desc[LE.Entry][0]);
                if (LE.TransactionType != 1) {
                    VE.SrcPe = LE.Pe;
                }
                return VE;
            }
        }
        return null;
    }

    public long searchtimeline(int PeNum, int Entry2, int Num) throws LogLoadException {
        long BeginTime = 0L;
        long Count = 0L;
        LogEntry LE = null;
        try {
            System.gc();
            GenericLogReader reader = new GenericLogReader(PeNum, MainWindow.runObject[this.myRun].getVersion());
            LogEntryData data = new LogEntryData();
            while (true) {
                reader.nextEvent(data);
                LE = LogEntry.adapt(data);
                if (LE.Entry == -1) continue;
                if (LE.Entry == Entry2 && LE.TransactionType == 2) {
                    ++Count;
                }
                if (Count > (long)Num) break;
            }
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(PeNum));
        }
        catch (EOFException E) {
        }
        catch (IOException E) {
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(PeNum), 1);
        }
        return LE.Time - BeginTime;
    }

    public Vector view(int PeNum) throws LogLoadException {
        Vector<ViewerEvent> ret = null;
        try {
            ret = new Vector<ViewerEvent>();
            GenericLogReader reader = new GenericLogReader(PeNum, MainWindow.runObject[this.myRun].getVersion());
            LogEntryData data = new LogEntryData();
            while (true) {
                reader.nextEvent(data);
                ViewerEvent VE = this.entrytotext(LogEntry.adapt(data));
                if (VE == null) continue;
                ret.addElement(VE);
            }
        }
        catch (FileNotFoundException E) {
            System.out.println("ERROR: couldn't open file " + MainWindow.runObject[this.myRun].getLogName(PeNum));
        }
        catch (EOFException E) {
        }
        catch (IOException E) {
            System.out.println("throwing....2");
            throw new LogLoadException(MainWindow.runObject[this.myRun].getLogName(PeNum), 1);
        }
        return ret;
    }

    public void createTimeIndexes(OrderedIntList processorList) {
        if (this.index == null) {
            String indexFilename = String.valueOf(MainWindow.runObject[this.myRun].getFilename()) + ".index";
            this.index = new LogIndex(indexFilename, this);
        }
        this.index.createTimeIndexes(processorList);
    }
}

