/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import projections.gui.IntTextField;
import projections.gui.LogFileViewerWindow;
import projections.gui.MainWindow;
import projections.gui.Util;

public class LogFileViewerDialog
extends Dialog
implements ActionListener,
TextListener {
    int myRun = 0;
    private static final long serialVersionUID = 1L;
    private IntTextField textField;
    private int pmax;
    private Button bOK;
    private Button bCancel;
    private LogFileViewerWindow logFilesWindow;

    public LogFileViewerDialog(LogFileViewerWindow logFilesWindow) {
        super(logFilesWindow, "Select Log File", true);
        this.logFilesWindow = logFilesWindow;
        this.pmax = MainWindow.runObject[this.myRun].getNumProcessors() - 1;
        Label l1 = new Label("Select a processor to view the log file for.");
        Label l2 = new Label("Valid processors: (0 - " + this.pmax + ")");
        this.textField = new IntTextField(0, 5);
        this.textField.addTextListener(this);
        this.textField.addActionListener(this);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.setLayout(gbl);
        Util.gblAdd(this, l1, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(this, l2, gbc, 0, 1, 1, 1, 1, 1, 0, 5, 5, 5);
        Util.gblAdd(this, this.textField, gbc, 0, 2, 1, 1, 1, 1, 5, 5, 5, 5);
        Panel p = new Panel();
        p.add(this.bOK);
        p.add(this.bCancel);
        Util.gblAdd(this, p, gbc, 0, 3, 1, 1, 1, 1, 5, 5, 5, 5);
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bOK) {
                this.logFilesWindow.setLogFileNum(this.textField.getValue());
            }
            this.logFilesWindow.CloseDialog();
        } else if (evt.getSource() instanceof IntTextField) {
            this.logFilesWindow.setLogFileNum(this.textField.getValue());
            this.logFilesWindow.CloseDialog();
        }
    }

    public void textValueChanged(TextEvent evt) {
        if (evt.getSource() instanceof IntTextField) {
            IntTextField f = (IntTextField)evt.getSource();
            if (f.getValue() < 0) {
                int lastCaretPosition = f.getCaretPosition();
                f.setText("0");
                f.setCaretPosition(lastCaretPosition);
            } else if (f.getValue() > this.pmax) {
                int lastCaretPosition = f.getCaretPosition();
                f.setText("" + this.pmax);
                f.setCaretPosition(lastCaretPosition);
            }
        }
    }
}

