/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.MessageWindow;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.U;

public class EntryMethodObject
extends JComponent
implements Comparable,
MouseListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private MessageWindow msgwindow;
    private long beginTime;
    private long endTime;
    private long recvTime;
    private long cpuTime;
    private long cpuBegin;
    private long cpuEnd;
    private int entry;
    private int msglen;
    int EventID;
    private ObjectId tid;
    int pCurrent;
    int pCreation;
    Integer userSuppliedData;
    private TimelineMessage creationMessage;
    private double usage;
    private float packusage;
    private long packtime;
    private int whichTimelineVerticalIndex;
    private int leftCoord = 0;
    private int rightCoord = 0;
    private String tleUserEventName;
    private Data data = null;
    public TreeSet messages;
    private PackTime[] packs;
    private int numPapiCounts = 0;
    private long[] papiCounts;
    private boolean isFunction = false;
    private static DecimalFormat format_ = new DecimalFormat();
    private AmpiFunctionData[] funcData;

    public EntryMethodObject(Data data, TimelineEvent tle, TreeSet msgs, PackTime[] packs, int p1) {
        int ecount;
        format_.setGroupingUsed(true);
        this.setVisible(true);
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
        this.data = data;
        this.beginTime = tle.BeginTime;
        this.endTime = tle.EndTime;
        this.cpuBegin = tle.cpuBegin;
        this.cpuEnd = tle.cpuEnd;
        this.cpuTime = this.cpuEnd - this.cpuBegin;
        this.entry = tle.EntryPoint;
        this.messages = msgs;
        this.packs = packs;
        this.pCurrent = p1;
        this.pCreation = tle.SrcPe;
        this.EventID = tle.EventID;
        this.msglen = tle.MsgLen;
        this.recvTime = tle.RecvTime;
        this.tid = tle.id != null ? new ObjectId(tle.id) : new ObjectId();
        this.userSuppliedData = tle.UserSpecifiedData;
        this.tleUserEventName = tle.userEventName;
        this.numPapiCounts = tle.numPapiCounts;
        this.papiCounts = tle.papiCounts;
        this.isFunction = tle.isFunction;
        this.setUsage();
        this.setPackUsage();
        if (this.isFunction) {
            this.funcData = new AmpiFunctionData[tle.callStack.size()];
            tle.callStack.copyInto(this.funcData);
        } else if (tle.EntryPoint >= 0 && tle.EntryPoint >= (ecount = MainWindow.runObject[this.myRun].getNumUserEntries())) {
            System.out.println("<b>Fatal error: invalid entry " + tle.EntryPoint + " on processor " + this.pCurrent + "</b>!");
            System.exit(1);
        }
        this.updateToolTipText();
        if (!this.isIdleEvent()) {
            this.addMouseListener(this);
        }
    }

    public void updateToolTipText() {
        String infoString = "";
        if (this.isFunction) {
            infoString = String.valueOf(infoString) + "<i>Function</i>: " + MainWindow.runObject[this.myRun].getFunctionName(this.entry) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>";
            infoString = String.valueOf(infoString) + "<i>End Time</i>: " + format_.format(this.endTime) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Total Time</i>: " + U.t(this.endTime - this.beginTime) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Msgs created</i>: " + this.messages.size() + "<br>";
            infoString = String.valueOf(infoString) + "<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>";
            infoString = String.valueOf(infoString) + "<hr><br><i>Function Callstack</i>:<br>";
            int i = 0;
            while (i < this.funcData.length) {
                AmpiFunctionData functionData = this.funcData[i];
                infoString = String.valueOf(infoString) + "<i>[Func]</i>: " + MainWindow.runObject[this.myRun].getFunctionName(functionData.FunctionID) + "<br>";
                infoString = String.valueOf(infoString) + "&nbsp&nbps&nbsp&nbps<i>line</i>:" + functionData.LineNo + " <i>file</i>: " + functionData.sourceFileName + "<br>";
                ++i;
            }
        } else if (this.entry >= 0) {
            infoString = String.valueOf(infoString) + "<b>" + MainWindow.runObject[this.myRun].getEntryNames()[this.entry][1] + "::" + MainWindow.runObject[this.myRun].getEntryNames()[this.entry][0] + "</b><br><br>";
            if (this.msglen > 0) {
                infoString = String.valueOf(infoString) + "<i>Msg Len</i>: " + this.msglen + "<br>";
            }
            infoString = String.valueOf(infoString) + "<i>Begin Time</i>: " + format_.format(this.beginTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + format_.format(this.cpuBegin) + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>End Time</i>: " + format_.format(this.endTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + format_.format(this.cpuEnd) + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Total Time</i>: " + U.t(this.endTime - this.beginTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + U.t(this.cpuTime) + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Packing</i>: " + U.t(this.packtime);
            if (this.packtime > 0L) {
                infoString = String.valueOf(infoString) + " (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Msgs created</i>: " + this.messages.size() + "<br>";
            infoString = String.valueOf(infoString) + "<i>Created by processor</i>: " + this.pCreation + "<br>";
            infoString = String.valueOf(infoString) + "<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>";
            if (this.tleUserEventName != null) {
                infoString = String.valueOf(infoString) + "<i>Associated User Event</i>: " + this.tleUserEventName + "<br>";
            }
            if (this.recvTime > 0L) {
                infoString = String.valueOf(infoString) + "<i>Recv Time</i>: " + this.recvTime + "<br>";
            }
            if (this.numPapiCounts > 0) {
                infoString = String.valueOf(infoString) + "<i>*** PAPI counts ***</i><br>";
                int i = 0;
                while (i < this.numPapiCounts) {
                    infoString = String.valueOf(infoString) + MainWindow.runObject[this.myRun].getPerfCountNames()[i] + " = " + format_.format(this.papiCounts[i]) + "<br>";
                    ++i;
                }
            }
        } else if (this.entry == -1) {
            infoString = String.valueOf(infoString) + "<b>Idle Time</b><br><br>";
            infoString = String.valueOf(infoString) + "<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>";
            infoString = String.valueOf(infoString) + "<i>End Time</i>: " + format_.format(this.endTime) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Total Time</i>: " + U.t(this.endTime - this.beginTime) + "<br>";
        } else if (this.entry == -2) {
            infoString = String.valueOf(infoString) + "<i>Unaccounted Time</i><br>";
            infoString = String.valueOf(infoString) + "<i>Begin Time</i>: " + format_.format(this.beginTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + format_.format(this.cpuBegin) + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>End Time</i>: " + format_.format(this.endTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + format_.format(this.cpuEnd) + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Total Time</i>: " + U.t(this.endTime - this.beginTime);
            if (this.cpuTime > 0L) {
                infoString = String.valueOf(infoString) + " (" + this.cpuTime + ")";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Packing</i>: " + U.t(this.packtime);
            if (this.packtime > 0L) {
                infoString = String.valueOf(infoString) + " (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)";
            }
            infoString = String.valueOf(infoString) + "<br>";
            infoString = String.valueOf(infoString) + "<i>Num Msgs created</i>: " + this.messages.size() + "<br>";
        }
        if (this.userSuppliedData != null) {
            infoString = String.valueOf(infoString) + "<i>User Supplied Data:</i> " + this.userSuppliedData + "<br>";
        }
        this.setToolTipText("<html><body>" + infoString + "</html></body>");
    }

    public void CloseMessageWindow() {
        this.msgwindow = null;
    }

    private void drawLeftArrow(Graphics g, Color c, int startY, int h) {
        int[] nArray = new int[3];
        nArray[0] = 5;
        nArray[2] = 5;
        int[] xpts = nArray;
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setColor(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setColor(c.brighter());
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setColor(c.darker());
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    private void drawRightArrow(Graphics g, Color c, int startY, int h, int right) {
        int[] xpts = new int[]{right - 6, right, right - 6};
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setColor(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setColor(c.brighter());
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setColor(c.darker());
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getEntry() {
        return this.entry;
    }

    public Set getMessages() {
        return this.messages;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public float getNonPackUsage() {
        return (float)this.usage - this.packusage;
    }

    public int getNumMsgs() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.size();
    }

    public float getPackUsage() {
        return this.packusage;
    }

    public int getPCreation() {
        return this.pCreation;
    }

    public int getPCurrent() {
        return this.pCurrent;
    }

    public float getUsage() {
        return (float)this.usage;
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.entry >= 0) {
            if (evt.getModifiers() == 16) {
                this.OpenMessageWindow();
            } else {
                this.data.entryMethodObjectRightClick(this);
            }
        }
    }

    public HashSet traceBackwardDependencies() {
        EntryMethodObject obj = this;
        HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
        boolean done = false;
        while (!done) {
            TimelineMessage created_message;
            done = true;
            v.add(obj);
            if (obj.entry == -1 || obj.pCreation > this.data.numPEs() || this.data.mesgVector[obj.pCreation] == null || (created_message = obj.creationMessage()) == null || (obj = (EntryMethodObject)this.data.messageToSendingObjectsMap.get(created_message)) == null) continue;
            done = false;
        }
        return v;
    }

    public HashSet traceForwardDependencies() {
        HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
        int i = 0;
        while (i < this.data.tloArray.length) {
            int j = 0;
            while (j < this.data.tloArray[i].length) {
                EntryMethodObject obj = this.data.tloArray[i][j];
                TimelineMessage m = obj.creationMessage();
                if (m != null && this.messages.contains(m)) {
                    v.add(obj);
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public TimelineMessage creationMessage() {
        if (this.data != null && this.pCreation >= 0 && this.data.eventIDToMessageMap != null && this.data.eventIDToMessageMap[this.pCreation] != null && this.pCreation < this.data.eventIDToMessageMap.length) {
            return (TimelineMessage)this.data.eventIDToMessageMap[this.pCreation].get(this.EventID);
        }
        return null;
    }

    public void mouseEntered(MouseEvent evt) {
        boolean needRepaint = false;
        if (this.data.traceMessagesOnHover()) {
            HashSet fwd = this.traceForwardDependencies();
            HashSet back = this.traceBackwardDependencies();
            this.data.clearMessageSendLines();
            this.data.addMessageSendLine(back);
            this.data.addMessageSendLineAlt(fwd);
            this.data.HighlightObjects(fwd);
            this.data.HighlightObjects(back);
            needRepaint = true;
        }
        if (this.data.traceOIDOnHover()) {
            Set allWithSameId = (Set)this.data.oidToEntryMethonObjectsMap.get(this.tid);
            this.data.HighlightObjects(allWithSameId);
            needRepaint = true;
        }
        if (needRepaint) {
            this.data.displayMustBeRepainted();
        }
    }

    public void mouseExited(MouseEvent evt) {
        boolean needRepaint = false;
        if (this.data.traceMessagesOnHover()) {
            this.data.clearObjectHighlights();
            this.data.clearMessageSendLines();
            needRepaint = true;
        }
        if (this.data.traceOIDOnHover()) {
            this.data.clearObjectHighlights();
            needRepaint = true;
        }
        if (needRepaint) {
            this.data.displayMustBeRepainted();
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    private void OpenMessageWindow() {
        if (this.msgwindow == null) {
            this.msgwindow = new MessageWindow(this);
            Dimension d = this.msgwindow.getPreferredSize();
            this.msgwindow.setSize(480, d.width);
        }
        this.msgwindow.setVisible(true);
    }

    public boolean isIdleEvent() {
        return this.entry == -1;
    }

    public void paintComponent(Graphics g) {
        Color c;
        super.paintComponent(g);
        if (this.isIdleEvent() && !this.data.showIdle || this.isIdleEvent() && MainWindow.IGNORE_IDLE) {
            return;
        }
        if (this.isIdleEvent()) {
            Color bg = this.data.getBackgroundColor();
            int brightness = bg.getRed() + bg.getGreen() + bg.getBlue();
            c = brightness > 384 ? bg.darker() : Color.white;
        } else if (this.entry == -2) {
            c = this.getBackground();
        } else {
            c = this.data.entryColor()[this.entry];
            if (this.isFunction) {
                c = MainWindow.runObject[this.myRun].getFunctionColor(this.entry);
            }
        }
        if (!this.isIdleEvent() && this.data.colorbyObjectId()) {
            c = this.colorFromOID();
        }
        if (this.data.isObjectDimmed(this)) {
            c = c.darker().darker();
        }
        if (this.data.colorByUserSupplied() && this.userSuppliedData != null && (this.userSuppliedData + 4096) % 2 == 1) {
            c = Color.darkGray;
        }
        int rectWidth = this.getWidth();
        int rectHeight = this.data.barheight();
        if (this.entry == -1) {
            rectHeight -= 6;
        }
        int verticalInset = (this.getHeight() - rectHeight) / 2;
        int left = 0;
        int right = rectWidth - 1;
        if (this.beginTime < this.data.beginTime()) {
            this.drawLeftArrow(g, c, verticalInset, rectHeight);
            rectWidth -= 5;
            left = 5;
        }
        if (this.endTime > this.data.endTime()) {
            this.drawRightArrow(g, c, verticalInset, rectHeight, rectWidth);
            right = (rectWidth -= 5) - 6;
        }
        g.setColor(c);
        if (rectWidth > 1 || this.entry != -1) {
            g.fillRect(left, verticalInset, rectWidth, rectHeight);
        }
        if (rectWidth > 2) {
            g.setColor(c.brighter());
            g.drawLine(left, verticalInset, right, verticalInset);
            if (left == 0) {
                g.drawLine(0, verticalInset, 0, verticalInset + rectHeight - 1);
            }
            g.setColor(c.darker());
            g.drawLine(left, verticalInset + rectHeight - 1, right, verticalInset + rectHeight - 1);
            if (right == rectWidth - 1) {
                g.drawLine(rectWidth - 1, verticalInset, rectWidth - 1, verticalInset + rectHeight - 1);
            }
        }
        if (this.data.showPacks && this.packs != null) {
            g.setColor(Color.pink);
            int p = 0;
            while (p < this.packs.length) {
                long packBeginTime = this.packs[p].BeginTime;
                long packEndTime = this.packs[p].EndTime;
                if (packEndTime >= this.data.beginTime() && packBeginTime <= this.data.endTime()) {
                    int packBeginPanelCoordX = this.data.timeToScreenPixelLeft(packBeginTime);
                    int packBeginObjectCoordX = packBeginPanelCoordX - this.leftCoord;
                    int packEndPanelCoordX = this.data.timeToScreenPixelRight(packEndTime);
                    int packEndObjectCoordX = packEndPanelCoordX - this.leftCoord;
                    g.fillRect(packBeginObjectCoordX, verticalInset + rectHeight, packEndObjectCoordX - packBeginObjectCoordX + 1, this.data.messagePackHeight());
                }
                ++p;
            }
        }
        if (this.data.showMsgs && this.messages != null) {
            g.setColor(this.getForeground());
            for (TimelineMessage msg : this.messages) {
                long msgtime = msg.Time;
                if (msgtime < this.data.beginTime() || msgtime > this.data.endTime()) continue;
                int msgPanelCoordX = this.data.timeToScreenPixelLeft(msgtime);
                int msgObjectCoordX = msgPanelCoordX - this.leftCoord;
                g.drawLine(msgObjectCoordX, verticalInset + rectHeight, msgObjectCoordX, verticalInset + rectHeight + this.data.messageSendHeight());
            }
        }
    }

    private Color colorFromOID() {
        int h1 = (this.getTid().id[0] + 2) * 7841 % 223;
        int h2 = (this.getTid().id[1] + 3) * 7841 % 223;
        int h3 = (this.getTid().id[2] + 5) * 7841 % 223;
        int h4 = (this.getTid().id[3] + 7) * 7841 % 223;
        int h5 = h1 ^ h3 ^ h2 ^ h4;
        h5 ^= h5 / 1024;
        float h = (float)(h5 % 512) / 512.0f;
        float s = 1.0f;
        float b = 1.0f;
        b = h5 % 2 == 0 ? 1.0f : 0.5f;
        return Color.getHSBColor(h, s, b);
    }

    public void setLocationAndSize(int actualDisplayWidth) {
        this.leftCoord = this.data.timeToScreenPixel(this.beginTime, actualDisplayWidth);
        this.rightCoord = this.data.timeToScreenPixel(this.endTime, actualDisplayWidth);
        if (this.endTime > this.data.endTime()) {
            this.rightCoord = this.data.timeToScreenPixelRight(this.data.endTime(), actualDisplayWidth);
        }
        if (this.beginTime < this.data.beginTime()) {
            this.leftCoord = this.data.timeToScreenPixelLeft(this.data.beginTime(), actualDisplayWidth);
        }
        int width = this.rightCoord - this.leftCoord + 1;
        int singleTimelineH = this.data.singleTimelineHeight();
        this.setBounds(this.leftCoord, this.whichTimelineVerticalIndex * singleTimelineH, width, singleTimelineH);
    }

    public void setPackUsage() {
        this.packtime = 0L;
        if (this.packs != null) {
            int p = 0;
            while (p < this.packs.length) {
                this.packtime += this.packs[p].EndTime - this.packs[p].BeginTime;
                if (this.packs[p].BeginTime < this.data.beginTime()) {
                    this.packtime -= this.data.beginTime() - this.packs[p].BeginTime;
                }
                if (this.packs[p].EndTime > this.data.endTime()) {
                    this.packtime -= this.packs[p].EndTime - this.data.endTime();
                }
                ++p;
            }
            this.packusage = this.packtime * 100L;
            this.packusage /= (float)(this.data.endTime() - this.data.beginTime());
        }
    }

    public void setUsage() {
        if (this.entry < -1) {
            return;
        }
        this.usage = this.endTime - this.beginTime;
        if (this.beginTime < this.data.beginTime()) {
            this.usage -= (double)(this.data.beginTime() - this.beginTime);
        }
        if (this.endTime > this.data.endTime()) {
            this.usage -= (double)(this.endTime - this.data.endTime());
        }
        this.usage /= (double)(this.data.endTime() - this.data.beginTime());
        this.usage *= 100.0;
    }

    public void setWhichTimeline(int p) {
        this.whichTimelineVerticalIndex = p;
    }

    public int getEventID() {
        return this.EventID;
    }

    public int compareTo(Object o) {
        EntryMethodObject obj = (EntryMethodObject)o;
        if (this.pCreation != obj.pCreation) {
            return this.pCreation - obj.pCreation;
        }
        if (this.pCurrent != obj.pCurrent) {
            return this.pCurrent - obj.pCurrent;
        }
        return this.EventID - obj.EventID;
    }

    public ObjectId getTid() {
        return this.tid;
    }
}

