/* DEFS: message ComlibDummyMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_ComlibDummyMsg::operator new(size_t s){
  return ComlibDummyMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_ComlibDummyMsg::operator new(size_t s, int* sz){
  return ComlibDummyMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_ComlibDummyMsg::operator new(size_t s, int* sz,const int pb){
  return ComlibDummyMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_ComlibDummyMsg::operator new(size_t s, const int p) {
  return ComlibDummyMsg::alloc(__idx, s, 0, p);
}
void* CMessage_ComlibDummyMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[1];
  offsets[0] = ALIGN8(sz);
  ComlibDummyMsg *newmsg = (ComlibDummyMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void* CMessage_ComlibDummyMsg::pack(ComlibDummyMsg *msg) {
  return (void *) msg;
}
ComlibDummyMsg* CMessage_ComlibDummyMsg::unpack(void* buf) {
  ComlibDummyMsg *msg = (ComlibDummyMsg *) buf;
  return msg;
}
int CMessage_ComlibDummyMsg::__idx=0;
#endif

/* DEFS: message ComlibMulticastMsg{
ComlibMulticastIndexCount indicesCount[];
CkArrayIndexMax indices[];
char usrMsg[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_ComlibMulticastMsg::operator new(size_t s){
  return ComlibMulticastMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_ComlibMulticastMsg::operator new(size_t s, int* sz){
  return ComlibMulticastMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_ComlibMulticastMsg::operator new(size_t s, int* sz,const int pb){
  return ComlibMulticastMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_ComlibMulticastMsg::operator new(size_t s, int sz0, int sz1, int sz2) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return ComlibMulticastMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_ComlibMulticastMsg::operator new(size_t s, int sz0, int sz1, int sz2, const int p) {
  int sizes[3];
  sizes[0] = sz0;
  sizes[1] = sz1;
  sizes[2] = sz2;
  return ComlibMulticastMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_ComlibMulticastMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[4];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(ComlibMulticastIndexCount)*sizes[0]);
  if(sizes==0)
    offsets[2] = offsets[0];
  else
    offsets[2] = offsets[1] + ALIGN8(sizeof(CkArrayIndexMax)*sizes[1]);
  if(sizes==0)
    offsets[3] = offsets[0];
  else
    offsets[3] = offsets[2] + ALIGN8(sizeof(char)*sizes[2]);
  ComlibMulticastMsg *newmsg = (ComlibMulticastMsg *) CkAllocMsg(msgnum, offsets[3], pb);
  newmsg->indicesCount = (ComlibMulticastIndexCount *) ((char *)newmsg + offsets[0]);
  newmsg->indices = (CkArrayIndexMax *) ((char *)newmsg + offsets[1]);
  newmsg->usrMsg = (char *) ((char *)newmsg + offsets[2]);
  return (void *) newmsg;
}
void* CMessage_ComlibMulticastMsg::pack(ComlibMulticastMsg *msg) {
  msg->indicesCount = (ComlibMulticastIndexCount *) ((char *)msg->indicesCount - (char *)msg);
  msg->indices = (CkArrayIndexMax *) ((char *)msg->indices - (char *)msg);
  msg->usrMsg = (char *) ((char *)msg->usrMsg - (char *)msg);
  return (void *) msg;
}
ComlibMulticastMsg* CMessage_ComlibMulticastMsg::unpack(void* buf) {
  ComlibMulticastMsg *msg = (ComlibMulticastMsg *) buf;
  msg->indicesCount = (ComlibMulticastIndexCount *) ((size_t)msg->indicesCount + (char *)msg);
  msg->indices = (CkArrayIndexMax *) ((size_t)msg->indices + (char *)msg);
  msg->usrMsg = (char *) ((size_t)msg->usrMsg + (char *)msg);
  return msg;
}
int CMessage_ComlibMulticastMsg::__idx=0;
#endif

/* DEFS: group ComlibManager: IrrGroup{
ComlibManager(CkMigrateMessage* impl_msg);
ComlibManager(void);
void barrier(void);
void barrier2(void);
void resumeFromBarrier2(void);
void receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0);
void receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id);
void collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ComlibManager::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ComlibManager(CkMigrateMessage* impl_msg);
 */

/* DEFS: ComlibManager(void);
 */

/* DEFS: void barrier(void);
 */
void CProxyElement_ComlibManager::barrier(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void barrier2(void);
 */
void CProxyElement_ComlibManager::barrier2(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void resumeFromBarrier2(void);
 */
void CProxyElement_ComlibManager::resumeFromBarrier2(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0);
 */
void CProxyElement_ComlibManager::receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id);
 */
void CProxyElement_ComlibManager::receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkQ<CharmMessageHolder* > &remoteQ, int id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1);
 */
void CProxyElement_ComlibManager::collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
/* DEFS: ComlibManager(CkMigrateMessage* impl_msg);
 */
 int CkIndex_ComlibManager::__idx_ComlibManager_CkMigrateMessage=0;
void CkIndex_ComlibManager::_call_ComlibManager_CkMigrateMessage(void* impl_msg,ComlibManager * impl_obj)
{
  new (impl_obj) ComlibManager((CkMigrateMessage*)impl_msg);
}

/* DEFS: ComlibManager(void);
 */
CkGroupID CProxy_ComlibManager::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_ComlibManager::__idx, CkIndex_ComlibManager::__idx_ComlibManager_void, impl_msg);
}
 int CkIndex_ComlibManager::__idx_ComlibManager_void=0;
void CkIndex_ComlibManager::_call_ComlibManager_void(void* impl_msg,ComlibManager * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) ComlibManager();
}

/* DEFS: void barrier(void);
 */
void CProxy_ComlibManager::barrier(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_barrier_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::barrier(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_barrier_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_barrier_void=0;
void CkIndex_ComlibManager::_call_barrier_void(void* impl_msg,ComlibManager * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->barrier();
}

/* DEFS: void barrier2(void);
 */
void CProxy_ComlibManager::barrier2(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::barrier2(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_barrier2_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_barrier2_void=0;
void CkIndex_ComlibManager::_call_barrier2_void(void* impl_msg,ComlibManager * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->barrier2();
}

/* DEFS: void resumeFromBarrier2(void);
 */
void CProxy_ComlibManager::resumeFromBarrier2(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::resumeFromBarrier2(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_resumeFromBarrier2_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_resumeFromBarrier2_void=0;
void CkIndex_ComlibManager::_call_resumeFromBarrier2_void(void* impl_msg,ComlibManager * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->resumeFromBarrier2();
}

/* DEFS: void receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0);
 */
void CProxy_ComlibManager::receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(StrategyWrapper &)sw;
    //Have to cast away const-ness to get pup routine
    implP|(CkHashtableT<ClibGlobalArrayIndex,int > &)impl_noname_0;
  }
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_receiveTable_marshall5, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_receiveTable_marshall5=0;
void CkIndex_ComlibManager::_call_receiveTable_marshall5(void* impl_msg,ComlibManager * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  StrategyWrapper sw; implP|sw;
  CkHashtableT<ClibGlobalArrayIndex,int > impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveTable(sw, impl_noname_0);
}
int CkIndex_ComlibManager::_callmarshall_receiveTable_marshall5(char* impl_buf,ComlibManager * impl_obj) {
  /*Unmarshall pup'd fields: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  StrategyWrapper sw; implP|sw;
  CkHashtableT<ClibGlobalArrayIndex,int > impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveTable(sw, impl_noname_0);
  return implP.size();
}
void CkIndex_ComlibManager::_marshallmessagepup_receiveTable_marshall5(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  StrategyWrapper sw; implP|sw;
  CkHashtableT<ClibGlobalArrayIndex,int > impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("sw");
  implDestP|sw;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_0");
  implDestP|impl_noname_0;
}

/* DEFS: void receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id);
 */
void CProxy_ComlibManager::receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkQ<CharmMessageHolder* > &remoteQ, int id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: const CkQ<CharmMessageHolder* > &remoteQ, int id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkQ<CharmMessageHolder* > &)remoteQ;
    implP|id;
  }
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_receiveRemoteSend_marshall6=0;
void CkIndex_ComlibManager::_call_receiveRemoteSend_marshall6(void* impl_msg,ComlibManager * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkQ<CharmMessageHolder* > &remoteQ, int id*/
  PUP::fromMem implP(impl_buf);
  CkQ<CharmMessageHolder* > remoteQ; implP|remoteQ;
  int id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveRemoteSend(remoteQ, id);
}
int CkIndex_ComlibManager::_callmarshall_receiveRemoteSend_marshall6(char* impl_buf,ComlibManager * impl_obj) {
  /*Unmarshall pup'd fields: const CkQ<CharmMessageHolder* > &remoteQ, int id*/
  PUP::fromMem implP(impl_buf);
  CkQ<CharmMessageHolder* > remoteQ; implP|remoteQ;
  int id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->receiveRemoteSend(remoteQ, id);
  return implP.size();
}
void CkIndex_ComlibManager::_marshallmessagepup_receiveRemoteSend_marshall6(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkQ<CharmMessageHolder* > &remoteQ, int id*/
  PUP::fromMem implP(impl_buf);
  CkQ<CharmMessageHolder* > remoteQ; implP|remoteQ;
  int id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remoteQ");
  implDestP|remoteQ;
  if (implDestP.hasComments()) implDestP.comment("id");
  implDestP|id;
}

/* DEFS: void collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1);
 */
void CProxy_ComlibManager::collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, ckGetGroupID(),0);
}
    void CProxy_ComlibManager::collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ComlibLocalStats &)s;
    implP|src;
    //Have to cast away const-ness to get pup routine
    implP|(CkVec<ClibGlobalArrayIndex > &)impl_noname_1;
  }
      CkSendMsgBranchMulti(CkIndex_ComlibManager::__idx_collectStats_marshall7, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_ComlibManager::__idx_collectStats_marshall7=0;
void CkIndex_ComlibManager::_call_collectStats_marshall7(void* impl_msg,ComlibManager * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1*/
  PUP::fromMem implP(impl_buf);
  ComlibLocalStats s; implP|s;
  int src; implP|src;
  CkVec<ClibGlobalArrayIndex > impl_noname_1; implP|impl_noname_1;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->collectStats(s, src, impl_noname_1);
}
int CkIndex_ComlibManager::_callmarshall_collectStats_marshall7(char* impl_buf,ComlibManager * impl_obj) {
  /*Unmarshall pup'd fields: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1*/
  PUP::fromMem implP(impl_buf);
  ComlibLocalStats s; implP|s;
  int src; implP|src;
  CkVec<ClibGlobalArrayIndex > impl_noname_1; implP|impl_noname_1;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->collectStats(s, src, impl_noname_1);
  return implP.size();
}
void CkIndex_ComlibManager::_marshallmessagepup_collectStats_marshall7(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1*/
  PUP::fromMem implP(impl_buf);
  ComlibLocalStats s; implP|s;
  int src; implP|src;
  CkVec<ClibGlobalArrayIndex > impl_noname_1; implP|impl_noname_1;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
  if (implDestP.hasComments()) implDestP.comment("src");
  implDestP|src;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_1");
  implDestP|impl_noname_1;
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ComlibManager::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,ComlibManager::isIrreducible());
// REG: ComlibManager(CkMigrateMessage* impl_msg);
  __idx_ComlibManager_CkMigrateMessage = CkRegisterEp("ComlibManager(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_ComlibManager_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_ComlibManager_CkMigrateMessage);

// REG: ComlibManager(void);
  __idx_ComlibManager_void = CkRegisterEp("ComlibManager(void)",
     (CkCallFnPtr)_call_ComlibManager_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_ComlibManager_void);

// REG: void barrier(void);
  __idx_barrier_void = CkRegisterEp("barrier(void)",
     (CkCallFnPtr)_call_barrier_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void barrier2(void);
  __idx_barrier2_void = CkRegisterEp("barrier2(void)",
     (CkCallFnPtr)_call_barrier2_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void resumeFromBarrier2(void);
  __idx_resumeFromBarrier2_void = CkRegisterEp("resumeFromBarrier2(void)",
     (CkCallFnPtr)_call_resumeFromBarrier2_void, 0, __idx, 0+CK_EP_INTRINSIC);

// REG: void receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0);
  __idx_receiveTable_marshall5 = CkRegisterEp("receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0)",
     (CkCallFnPtr)_call_receiveTable_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_receiveTable_marshall5,(CkMarshallUnpackFn)_callmarshall_receiveTable_marshall5);
  CkRegisterMessagePupFn(__idx_receiveTable_marshall5,(CkMessagePupFn)_marshallmessagepup_receiveTable_marshall5);

// REG: void receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id);
  __idx_receiveRemoteSend_marshall6 = CkRegisterEp("receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id)",
     (CkCallFnPtr)_call_receiveRemoteSend_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_receiveRemoteSend_marshall6,(CkMarshallUnpackFn)_callmarshall_receiveRemoteSend_marshall6);
  CkRegisterMessagePupFn(__idx_receiveRemoteSend_marshall6,(CkMessagePupFn)_marshallmessagepup_receiveRemoteSend_marshall6);

// REG: void collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1);
  __idx_collectStats_marshall7 = CkRegisterEp("collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1)",
     (CkCallFnPtr)_call_collectStats_marshall7, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_collectStats_marshall7,(CkMarshallUnpackFn)_callmarshall_collectStats_marshall7);
  CkRegisterMessagePupFn(__idx_collectStats_marshall7,(CkMessagePupFn)_marshallmessagepup_collectStats_marshall7);
}
#endif

/* DEFS: mainchare ComlibManagerMain: Chare{
ComlibManagerMain(CkArgMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ComlibManagerMain::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ComlibManagerMain(CkArgMsg* impl_msg);
 */
CkChareID CProxy_ComlibManagerMain::ckNew(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_ComlibManagerMain::__idx, CkIndex_ComlibManagerMain::__idx_ComlibManagerMain_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  return impl_ret;
}
void CProxy_ComlibManagerMain::ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int impl_onPE)
{
  CkCreateChare(CkIndex_ComlibManagerMain::__idx, CkIndex_ComlibManagerMain::__idx_ComlibManagerMain_CkArgMsg, impl_msg, pcid, impl_onPE);
}
  CProxy_ComlibManagerMain::CProxy_ComlibManagerMain(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_ComlibManagerMain::__idx, CkIndex_ComlibManagerMain::__idx_ComlibManagerMain_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  ckSetChareID(impl_ret);
}
 int CkIndex_ComlibManagerMain::__idx_ComlibManagerMain_CkArgMsg=0;
void CkIndex_ComlibManagerMain::_call_ComlibManagerMain_CkArgMsg(void* impl_msg,ComlibManagerMain * impl_obj)
{
  new (impl_obj) ComlibManagerMain((CkArgMsg*)impl_msg);
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ComlibManagerMain::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_Chare::__idx);
// REG: ComlibManagerMain(CkArgMsg* impl_msg);
  __idx_ComlibManagerMain_CkArgMsg = CkRegisterEp("ComlibManagerMain(CkArgMsg* impl_msg)",
     (CkCallFnPtr)_call_ComlibManagerMain_CkArgMsg, CMessage_CkArgMsg::__idx, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMainChare(__idx, __idx_ComlibManagerMain_CkArgMsg);
}
#endif

  PUPable_def(DummyStrategy);

  PUPable_def(NodeMulticast);

  PUPable_def(StreamingStrategy);

  PUPable_def(MPIStrategy);

  PUPable_def(DirectMulticastStrategy);

  PUPable_def(RectMulticastStrategy);

  PUPable_def(EachToManyMulticastStrategy);

  PUPable_def(RingMulticastStrategy);

  PUPable_def(PipeBroadcastStrategy);

  PUPable_def(MeshStreamingStrategy);

  PUPable_def(PrioStreaming);

  PUPable_def(BroadcastStrategy);

  PUPable_def(MultiRingMulticast);

#ifndef CK_TEMPLATES_ONLY
void _registercomlib(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message ComlibDummyMsg;
*/
CMessage_ComlibDummyMsg::__register("ComlibDummyMsg", sizeof(ComlibDummyMsg),(CkPackFnPtr) ComlibDummyMsg::pack,(CkUnpackFnPtr) ComlibDummyMsg::unpack);

/* REG: message ComlibMulticastMsg{
ComlibMulticastIndexCount indicesCount[];
CkArrayIndexMax indices[];
char usrMsg[];
}
;
*/
CMessage_ComlibMulticastMsg::__register("ComlibMulticastMsg", sizeof(ComlibMulticastMsg),(CkPackFnPtr) ComlibMulticastMsg::pack,(CkUnpackFnPtr) ComlibMulticastMsg::unpack);

/* REG: group ComlibManager: IrrGroup{
ComlibManager(CkMigrateMessage* impl_msg);
ComlibManager(void);
void barrier(void);
void barrier2(void);
void resumeFromBarrier2(void);
void receiveTable(const StrategyWrapper &sw, const CkHashtableT<ClibGlobalArrayIndex,int > &impl_noname_0);
void receiveRemoteSend(const CkQ<CharmMessageHolder* > &remoteQ, int id);
void collectStats(const ComlibLocalStats &s, int src, const CkVec<ClibGlobalArrayIndex > &impl_noname_1);
};
*/
  CkIndex_ComlibManager::__register("ComlibManager", sizeof(ComlibManager));

/* REG: mainchare ComlibManagerMain: Chare{
ComlibManagerMain(CkArgMsg* impl_msg);
};
*/
  CkIndex_ComlibManagerMain::__register("ComlibManagerMain", sizeof(ComlibManagerMain));

      PUPable_reg(DummyStrategy);

      PUPable_reg(NodeMulticast);

      PUPable_reg(StreamingStrategy);

      PUPable_reg(MPIStrategy);

      PUPable_reg(DirectMulticastStrategy);

      PUPable_reg(RectMulticastStrategy);

      PUPable_reg(EachToManyMulticastStrategy);

      PUPable_reg(RingMulticastStrategy);

      PUPable_reg(PipeBroadcastStrategy);

      PUPable_reg(MeshStreamingStrategy);

      PUPable_reg(PrioStreaming);

      PUPable_reg(BroadcastStrategy);

      PUPable_reg(MultiRingMulticast);

}
#endif
