/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class StringVisitor
extends TypeVisitor {
    int spacing = 0;
    StringBuffer result = new StringBuffer();

    public StringVisitor(ByteBuffer b) {
        super(b);
    }

    @Override
    public void addElement(GenericElement e, String v) {
        int i;
        GenericType gt = e.getType();
        String t = gt.getName();
        String n = e.getName();
        int pointer = e.getPointer() + gt.getPointer();
        this.result.append('\n');
        for (i = 0; i < this.spacing; ++i) {
            this.result.append("  ");
        }
        if (t != null) {
            this.result.append(t);
        }
        for (i = 0; i < pointer; ++i) {
            this.result.append('*');
        }
        if (n != null) {
            this.result.append(' ').append(n);
        }
        this.result.append(" = ");
        if (v != null) {
            this.result.append(v);
        }
    }

    @Override
    public void push() {
        ++this.spacing;
        this.result.append('{');
    }

    @Override
    public void pop() {
        --this.spacing;
        this.result.append('\n');
        for (int i = 0; i < this.spacing; ++i) {
            this.result.append("  ");
        }
        this.result.append('}');
    }

    @Override
    public Object getResult() {
        return this.result;
    }
}

