/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import projections.analysis.ProjMain;
import projections.gui.BackGroundImagePanel;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainWindow;
import projections.gui.ScreenInfo;

public class MainSummaryGraphPanel
extends JTabbedPane {
    private MainWindow parent;
    private MainRunStatusPanel statusPanel;
    private boolean empty;
    private Image bgimage;
    private JPanel fillerPanel;

    public MainSummaryGraphPanel(MainWindow parent, MainRunStatusPanel statusPanel) {
        this.parent = parent;
        this.statusPanel = statusPanel;
        this.addChangeListener(this.statusPanel);
        if (!ProjMain.FUNNY) {
            this.fillerPanel = new JPanel();
            this.fillerPanel.setBackground(Color.black);
            this.fillerPanel.setPreferredSize(new Dimension(ScreenInfo.screenWidth / 3, ScreenInfo.screenHeight / 3));
        } else {
            try {
                URL imageURL = parent.getClass().getResource("/projections/images/noSummary.jpg");
                this.bgimage = Toolkit.getDefaultToolkit().getImage(imageURL);
                this.fillerPanel = new BackGroundImagePanel(this.bgimage, false);
            }
            catch (Exception E) {
                System.out.println("Warning: can't load background image. Continuing.");
                this.fillerPanel = new BackGroundImagePanel(null);
            }
            this.fillerPanel.setBackground(Color.black);
        }
        this.setEmpty();
    }

    public void add(String title, Component panel, String tooltip) {
        if (this.empty) {
            this.remove(0);
            this.empty = false;
        }
        this.insertTab(title, null, panel, tooltip, this.getTabCount());
        this.setForegroundAt(0, Color.black);
        ((JComponent)panel).revalidate();
        this.parent.validate();
    }

    public void removeCurrent() {
        this.remove(this.getSelectedIndex());
        if (this.getTabCount() == 0) {
            this.setEmpty();
        }
    }

    public void removeAll() {
        int startTabCount = this.getTabCount();
        for (int i = 0; i < startTabCount; ++i) {
            this.removeCurrent();
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void setEmpty() {
        this.empty = true;
        this.insertTab("No Summary Data Available", null, this.fillerPanel, "No Summary Data loaded", 0);
        this.setForegroundAt(0, Color.red);
        this.setSelectedIndex(0);
        this.fillerPanel.revalidate();
        this.parent.validate();
    }

    public Dimension getMinimumSize() {
        return new Dimension(ScreenInfo.screenWidth / 3, ScreenInfo.screenHeight / 3);
    }
}

