/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import projections.analysis.EPNamdDefs;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class EPDataGenerator
extends ProjDefs
implements EPNamdDefs {
    int myRun = 0;

    public EPDataGenerator(long[][] data, OrderedIntList validPEs, long startTime, long endTime) {
        OrderedIntList tmpPEs = validPEs.copyOf();
        LogEntryData logData = new LogEntryData();
        int numUserEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        int numUserEvents = MainWindow.runObject[this.myRun].getNumUserDefinedEvents();
        boolean processing = false;
        boolean packing = false;
        boolean unpacking = false;
        boolean inIdle = false;
        long beginTime = 0L;
        long userBeginTime = 0L;
        long packStartTime = 0L;
        long unpackStartTime = 0L;
        long subtractTime = 0L;
        while (tmpPEs.hasMoreElements()) {
            int pe = tmpPEs.nextElement();
            GenericLogReader reader = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(pe), MainWindow.runObject[this.myRun].getVersion());
            processing = false;
            packing = false;
            unpacking = false;
            inIdle = false;
            beginTime = 0L;
            packStartTime = 0L;
            unpackStartTime = 0L;
            subtractTime = 0L;
            try {
                block15: while (true) {
                    reader.nextEvent(logData);
                    if (logData.time < startTime || logData.time > endTime) continue;
                    switch (logData.type) {
                        case 14: {
                            inIdle = true;
                            subtractTime = 0L;
                            beginTime = logData.time;
                            continue block15;
                        }
                        case 15: {
                            if (!inIdle) continue block15;
                            long[] lArray = data[0];
                            int n = numUserEPs + numUserEvents;
                            lArray[n] = lArray[n] + (logData.time - beginTime - subtractTime);
                            inIdle = false;
                            continue block15;
                        }
                        case 16: {
                            packing = true;
                            packStartTime = logData.time;
                            continue block15;
                        }
                        case 17: {
                            if (!packing) continue block15;
                            long[] lArray = data[0];
                            int n = numUserEPs + numUserEvents + 1;
                            lArray[n] = lArray[n] + (logData.time - packStartTime);
                            if (processing) {
                                subtractTime += logData.time - packStartTime;
                            }
                            packing = false;
                            continue block15;
                        }
                        case 18: {
                            unpacking = true;
                            unpackStartTime = logData.time;
                            continue block15;
                        }
                        case 19: {
                            if (!unpacking) continue block15;
                            long[] lArray = data[0];
                            int n = numUserEPs + numUserEvents + 2;
                            lArray[n] = lArray[n] + (logData.time - unpackStartTime);
                            if (processing) {
                                subtractTime += logData.time - unpackStartTime;
                            }
                            unpacking = false;
                            continue block15;
                        }
                        case 2: {
                            processing = true;
                            subtractTime = 0L;
                            beginTime = logData.time;
                            continue block15;
                        }
                        case 3: {
                            if (!processing) continue block15;
                            long[] lArray = data[0];
                            int n = logData.entry;
                            lArray[n] = lArray[n] + (logData.time - beginTime - subtractTime);
                            processing = false;
                            continue block15;
                        }
                        case 100: {
                            int eventID = logData.userEventID;
                            userBeginTime = logData.time;
                            reader.nextEvent(logData);
                            while (logData.userEventID != eventID) {
                                reader.nextEvent(logData);
                            }
                            long[] lArray = data[0];
                            int n = numUserEPs + MainWindow.runObject[this.myRun].getUserDefinedEventIndex(logData.userEventID);
                            lArray[n] = lArray[n] + (logData.time - userBeginTime);
                            if (!(processing | inIdle)) continue block15;
                            subtractTime += logData.time - userBeginTime;
                            continue block15;
                        }
                    }
                }
            }
            catch (EOFException eventID) {
            }
            catch (Exception e) {
                System.err.println("Exception found. Bad");
            }
        }
    }
}

