/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.File;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericSummaryReader;
import projections.analysis.StsReader;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.MiscUtil;

public class MultiRunData {
    static int myRun = 0;
    private StsReader[] stsReaders;
    private int[] sortedStsMap;
    private double[][][] dataTable;
    public static final int NUM_TYPES = 4;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_TIMES_CALLED = 1;
    public static final int TYPE_NUM_MSG_SENT = 2;
    public static final int TYPE_SIZE_MSG = 3;
    private static final String[] typeNames = new String[]{"Execution Time", "Num Msgs Received", "Num Msgs Sent", "Msg Size"};
    private double[] runWallTimes;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;

    public MultiRunData(String[] listOfStsFilenames) throws IOException {
        try {
            this.numRuns = listOfStsFilenames.length;
            if (this.numRuns == 0) {
                throw new IOException("MultiRunData cannot be initialized with zero runs!");
            }
            this.stsReaders = new StsReader[this.numRuns];
            int[] pesPerRun = new int[this.numRuns];
            int run = 0;
            while (run < this.numRuns) {
                this.stsReaders[run] = new StsReader(listOfStsFilenames[run], true);
                pesPerRun[run] = this.stsReaders[run].getProcessorCount();
                ++run;
            }
            this.sortedStsMap = MiscUtil.sortAndMap(pesPerRun);
            MiscUtil.applyMap(this.stsReaders, this.sortedStsMap);
            OrderedIntList[][] validPESets = new OrderedIntList[this.numRuns][];
            boolean hasSummary = true;
            boolean hasLog = true;
            int run2 = 0;
            while (run2 < this.numRuns) {
                validPESets[run2] = MultiRunData.detectFiles(this.stsReaders[run2]);
                hasSummary = hasSummary && !validPESets[run2][1].isEmpty();
                hasLog = hasLog && !validPESets[run2][0].isEmpty();
                ++run2;
            }
            this.numEPs = this.stsReaders[0].getEntryCount();
            run2 = 1;
            while (run2 < this.numRuns) {
                if (this.numEPs != this.stsReaders[run2].getEntryCount()) {
                    System.err.println("Error! Incompatible data sets!");
                    System.exit(-1);
                }
                ++run2;
            }
            this.epNames = new String[this.numEPs];
            int ep = 0;
            while (ep < this.numEPs) {
                this.epNames[ep] = this.stsReaders[0].getEntryNameByID(ep);
                ++ep;
            }
            this.runNames = new String[this.numRuns];
            run2 = 0;
            while (run2 < this.numRuns) {
                this.runNames[run2] = "(" + pesPerRun[run2] + ")" + "[" + this.stsReaders[run2].getMachineName() + "]";
                ++run2;
            }
            this.dataTable = new double[4][this.numRuns][this.numEPs];
            this.runWallTimes = new double[this.numRuns];
            if (hasSummary) {
                int run3 = 0;
                while (run3 < this.numRuns) {
                    int numPE = pesPerRun[run3];
                    OrderedIntList validPEs = validPESets[run3][1];
                    validPEs.reset();
                    double scale = (double)numPE / ((double)validPEs.size() * 1.0);
                    ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[MultiRunData.myRun].guiRoot, "Reading summary Data for run " + run3 + " of " + this.numRuns, "", 0, validPEs.size());
                    progressBar.setMillisToDecideToPopup(100);
                    progressBar.setMillisToPopup(1000);
                    int count = 0;
                    while (validPEs.hasMoreElements()) {
                        int pe = validPEs.nextElement();
                        if (!progressBar.isCanceled()) {
                            progressBar.setNote("[PE: " + pe + " ] Reading Processor data.");
                            progressBar.setProgress(count);
                        } else {
                            System.err.println("Fatal error! Multirun  cannot function without  a complete read!");
                            System.exit(-1);
                        }
                        GenericSummaryReader reader = new GenericSummaryReader(MainWindow.runObject[myRun].getSumName(pe), MainWindow.runObject[myRun].getVersion());
                        int ep2 = 0;
                        while (ep2 < this.numEPs) {
                            double[] dArray = this.dataTable[0][run3];
                            int n = ep2;
                            dArray[n] = dArray[n] + (double)reader.epData[ep2][0] * scale;
                            double[] dArray2 = this.dataTable[1][run3];
                            int n2 = ep2;
                            dArray2[n2] = dArray2[n2] + (double)reader.epData[ep2][1] * scale;
                            ++ep2;
                        }
                        int n = run3;
                        this.runWallTimes[n] = this.runWallTimes[n] + (double)reader.numIntervals * reader.intervalSize * 1000000.0 * scale;
                        ++count;
                    }
                    progressBar.close();
                    ++run3;
                }
            } else if (!hasLog) {
                System.err.println("No data available! Catastrophic error!");
                System.exit(-1);
            }
        }
        catch (IOException e) {
            throw new IOException("MultiRun data read failed: 13" + e);
        }
    }

    public int getNumEPs() {
        return this.numEPs;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public double[][] getData(int type) {
        return this.dataTable[type];
    }

    public double[][][] getData() {
        return this.dataTable;
    }

    public double[] getEPData(int type, int runID) {
        return this.dataTable[type][runID];
    }

    public double[] getRunData(int type, int ep) {
        double[] returnData = new double[this.numRuns];
        int run = 0;
        while (run < this.numRuns) {
            returnData[run] = this.dataTable[type][run][ep];
            ++run;
        }
        return returnData;
    }

    public double[] getRunWallTimes() {
        return this.runWallTimes;
    }

    public String[] getEPNames() {
        return this.epNames;
    }

    public String[] getRunNames() {
        return this.runNames;
    }

    public static String getTypeName(int dataType) {
        return typeNames[dataType];
    }

    private static OrderedIntList[] detectFiles(StsReader sts) {
        OrderedIntList[] validPEs = new OrderedIntList[5];
        int i = 0;
        while (i < 5) {
            validPEs[i] = new OrderedIntList();
            ++i;
        }
        i = 0;
        while (i < sts.getProcessorCount()) {
            if (new File(MainWindow.runObject[myRun].getSumName(i)).isFile()) {
                validPEs[1].insert(i);
            }
            if (new File(MainWindow.runObject[myRun].getSumDetailName(i)).isFile()) {
                validPEs[2].insert(i);
            }
            if (new File(MainWindow.runObject[myRun].getLogName(i)).isFile()) {
                validPEs[0].insert(i);
            }
            ++i;
        }
        return validPEs;
    }
}

