/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.Symbol;
import java.util.Vector;

public class Slot
implements Comparable {
    private long location;
    private int size;
    private boolean isLeak;
    private int type;
    private int chareID;
    private Vector backtrace;
    public static final int LEAK_FLAG = 8;
    public static final int TYPE_MASK = 7;
    public static final int UNKNOWN_TYPE = 0;
    public static final int SYSTEM_TYPE = 1;
    public static final int USER_TYPE = 2;
    public static final int CHARE_TYPE = 3;
    public static final int MESSAGE_TYPE = 4;

    public Slot(long loc) {
        this.location = loc;
        this.isLeak = false;
        this.type = 0;
        this.chareID = 0;
        this.backtrace = new Vector();
    }

    public void setSize(int sz) {
        this.size = sz;
    }

    public void setLeak(boolean l) {
        this.isLeak = l;
    }

    public void setType(int t) {
        this.type = t;
    }

    public void setChareID(int c) {
        this.chareID = c;
    }

    public void addTrace(Object elem) {
        this.backtrace.add(elem);
    }

    public long getLocation() {
        return this.location;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLeak() {
        return this.isLeak;
    }

    public int getType() {
        return this.type;
    }

    public int getChareID() {
        return this.chareID;
    }

    public int getTraceSize() {
        return this.backtrace.size();
    }

    public Object getTrace(int i) {
        return this.backtrace.elementAt(i);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        if (this.isLeak()) {
            tmp.append("*** LEAKING ***\n");
        }
        tmp.append("Memory type: ");
        switch (this.type) {
            case 1: {
                tmp.append("system");
                break;
            }
            case 2: {
                tmp.append("user");
                break;
            }
            case 3: {
                tmp.append("chare object");
                break;
            }
            case 4: {
                tmp.append("message");
                break;
            }
            default: {
                tmp.append("unknown");
            }
        }
        tmp.append("\nSlot at position 0x" + Long.toHexString(this.location) + " of size " + this.size + " bytes.");
        tmp.append("Belonging to chare " + this.chareID + ". Backtrace:\n");
        for (int i = 0; i < this.backtrace.size(); ++i) {
            tmp.append("\tfunction ").append((Symbol)this.backtrace.elementAt(i) + "\n");
        }
        return tmp.toString();
    }

    public int compareTo(Object o) {
        Slot os = (Slot)o;
        return this.location == os.location ? 0 : (this.location > os.location ? 1 : -1);
    }
}

